/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wsdeploy;

import com.sun.xml.rpc.processor.config.HandlerChainInfo;
import com.sun.xml.rpc.processor.config.HandlerInfo;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.streaming.XMLReaderFactory;
import com.sun.xml.rpc.tools.wsdeploy.Constants;
import com.sun.xml.rpc.tools.wsdeploy.DeploymentException;
import com.sun.xml.rpc.tools.wsdeploy.EndpointInfo;
import com.sun.xml.rpc.tools.wsdeploy.EndpointMappingInfo;
import com.sun.xml.rpc.tools.wsdeploy.WebServicesInfo;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;

public class DeploymentDescriptorParser {
    public WebServicesInfo parse(InputStream inputStream) {
        try {
            XMLReader xMLReader = XMLReaderFactory.newInstance().createXMLReader(inputStream);
            xMLReader.next();
            return this.parseWebServices(xMLReader);
        }
        catch (XMLReaderException xMLReaderException) {
            throw new DeploymentException("deployment.parser.xmlReader", xMLReaderException);
        }
    }

    protected WebServicesInfo parseWebServices(XMLReader xMLReader) {
        if (!xMLReader.getName().equals(Constants.QNAME_WEB_SERVICES)) {
            DeploymentDescriptorParser.failWithFullName("deployment.parser.invalidElement", xMLReader);
        }
        WebServicesInfo webServicesInfo = new WebServicesInfo();
        String string = this.getMandatoryNonEmptyAttribute(xMLReader, "version");
        if (!string.equals("1.0")) {
            DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidVersionNumber", xMLReader, string);
        }
        webServicesInfo.setTargetNamespaceBase(this.getNonEmptyAttribute(xMLReader, "targetNamespaceBase"));
        webServicesInfo.setTypeNamespaceBase(this.getNonEmptyAttribute(xMLReader, "typeNamespaceBase"));
        webServicesInfo.setUrlPatternBase(this.getNonEmptyAttribute(xMLReader, "urlPatternBase"));
        boolean bl = false;
        while (xMLReader.nextElementContent() != 2) {
            if (xMLReader.getName().equals(Constants.QNAME_ENDPOINT)) {
                if (bl) {
                    DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidElement", xMLReader);
                    continue;
                }
                webServicesInfo.add(this.parseEndpoint(xMLReader));
                continue;
            }
            if (xMLReader.getName().equals(Constants.QNAME_ENDPOINT_MAPPING)) {
                webServicesInfo.add(this.parseEndpointMapping(xMLReader));
                bl = true;
                continue;
            }
            DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidElement", xMLReader);
        }
        xMLReader.close();
        Map map = webServicesInfo.getEndpoints();
        Map map2 = webServicesInfo.getEndpointMappings();
        boolean bl2 = true;
        boolean bl3 = true;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            EndpointInfo endpointInfo = (EndpointInfo)iterator.next();
            if (endpointInfo.getModel() == null) {
                bl2 = false;
            }
            if (map2.get(endpointInfo.getName()) != null) continue;
            bl3 = false;
        }
        if (!bl2) {
            if (webServicesInfo.getTargetNamespaceBase() == null) {
                throw new DeploymentException("deployment.parser.missing.attribute.no.line", new Object[]{Constants.QNAME_WEB_SERVICES.getLocalPart(), "targetNamespaceBase"});
            }
            if (webServicesInfo.getTypeNamespaceBase() == null) {
                throw new DeploymentException("deployment.parser.missing.attribute.no.line", new Object[]{Constants.QNAME_WEB_SERVICES.getLocalPart(), "typeNamespaceBase"});
            }
        }
        if (!bl3 && webServicesInfo.getUrlPatternBase() == null) {
            throw new DeploymentException("deployment.parser.missing.attribute.no.line", new Object[]{Constants.QNAME_WEB_SERVICES.getLocalPart(), "urlPatternBase"});
        }
        return webServicesInfo;
    }

    protected EndpointInfo parseEndpoint(XMLReader xMLReader) {
        EndpointInfo endpointInfo = new EndpointInfo();
        endpointInfo.setName(this.getMandatoryNonEmptyAttribute(xMLReader, "name"));
        endpointInfo.setDisplayName(this.getAttribute(xMLReader, "displayName"));
        endpointInfo.setDescription(this.getAttribute(xMLReader, "description"));
        endpointInfo.setInterface(this.getAttribute(xMLReader, "interface"));
        endpointInfo.setImplementation(this.getAttribute(xMLReader, "implementation"));
        endpointInfo.setModel(this.getAttribute(xMLReader, "model"));
        if (xMLReader.nextElementContent() == 1) {
            if (xMLReader.getName().equals(Constants.QNAME_HANDLER_CHAINS)) {
                while (xMLReader.nextElementContent() != 2) {
                    if (xMLReader.getName().equals(Constants.QNAME_CHAIN)) {
                        Object object;
                        Object object2;
                        String string = this.getMandatoryNonEmptyAttribute(xMLReader, "runAt");
                        HandlerChainInfo handlerChainInfo = new HandlerChainInfo();
                        String string2 = this.getAttribute(xMLReader, "roles");
                        if (string2 != null) {
                            object2 = XmlUtil.parseTokenList(string2);
                            object = object2.iterator();
                            while (object.hasNext()) {
                                handlerChainInfo.addRole((String)object.next());
                            }
                        }
                        while (xMLReader.nextElementContent() != 2) {
                            if (xMLReader.getName().equals(Constants.QNAME_HANDLER)) {
                                String string3;
                                Object object3;
                                Object object4;
                                object2 = new HandlerInfo();
                                object = this.getMandatoryNonEmptyAttribute(xMLReader, "className");
                                ((HandlerInfo)object2).setHandlerClassName((String)object);
                                String string4 = this.getAttribute(xMLReader, "headers");
                                if (string4 != null) {
                                    object4 = XmlUtil.parseTokenList(string4);
                                    object3 = object4.iterator();
                                    while (object3.hasNext()) {
                                        String string5;
                                        string3 = (String)object3.next();
                                        String string6 = XmlUtil.getPrefix(string3);
                                        String string7 = XmlUtil.getLocalPart(string3);
                                        if (string6 == null) {
                                            string6 = "";
                                        }
                                        if ((string5 = xMLReader.getURI(string6)) == null) {
                                            DeploymentDescriptorParser.failWithLocalName("configuration.invalidAttributeValue", xMLReader, "headers");
                                        }
                                        ((HandlerInfo)object2).addHeaderName(new QName(string5, string7));
                                    }
                                }
                                object4 = ((HandlerInfo)object2).getProperties();
                                while (xMLReader.nextElementContent() != 2) {
                                    if (xMLReader.getName().equals(Constants.QNAME_PROPERTY)) {
                                        object3 = this.getMandatoryNonEmptyAttribute(xMLReader, "name");
                                        string3 = this.getMandatoryAttribute(xMLReader, "value");
                                        object4.put(object3, string3);
                                        DeploymentDescriptorParser.ensureNoContent(xMLReader);
                                        continue;
                                    }
                                    DeploymentDescriptorParser.failWithLocalName("configuration.invalidElement", xMLReader);
                                }
                                handlerChainInfo.add((HandlerInfo)object2);
                                continue;
                            }
                            DeploymentDescriptorParser.failWithLocalName("configuration.invalidElement", xMLReader);
                        }
                        if (string.equals("client")) {
                            endpointInfo.setClientHandlerChainInfo(handlerChainInfo);
                            continue;
                        }
                        if (string.equals("server")) {
                            endpointInfo.setServerHandlerChainInfo(handlerChainInfo);
                            continue;
                        }
                        DeploymentDescriptorParser.failWithLocalName("configuration.invalidAttributeValue", xMLReader, "runAt");
                        continue;
                    }
                    DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidElement", xMLReader);
                }
                DeploymentDescriptorParser.ensureNoContent(xMLReader);
            } else {
                DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidElement", xMLReader);
            }
        }
        return endpointInfo;
    }

    protected EndpointMappingInfo parseEndpointMapping(XMLReader xMLReader) {
        EndpointMappingInfo endpointMappingInfo = new EndpointMappingInfo();
        endpointMappingInfo.setName(this.getMandatoryNonEmptyAttribute(xMLReader, "endpointName"));
        endpointMappingInfo.setUrlPattern(this.getMandatoryNonEmptyAttribute(xMLReader, "urlPattern"));
        DeploymentDescriptorParser.ensureNoContent(xMLReader);
        return endpointMappingInfo;
    }

    protected String getAttribute(XMLReader xMLReader, String string) {
        Attributes attributes = xMLReader.getAttributes();
        String string2 = attributes.getValue(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    protected String getNonEmptyAttribute(XMLReader xMLReader, String string) {
        String string2 = this.getAttribute(xMLReader, string);
        if (string2 != null && string2.equals("")) {
            DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidAttributeValue", xMLReader, string);
        }
        return string2;
    }

    protected String getMandatoryAttribute(XMLReader xMLReader, String string) {
        String string2 = this.getAttribute(xMLReader, string);
        if (string2 == null) {
            DeploymentDescriptorParser.failWithLocalName("deployment.parser.missing.attribute", xMLReader, string);
        }
        return string2;
    }

    protected String getMandatoryNonEmptyAttribute(XMLReader xMLReader, String string) {
        String string2 = this.getAttribute(xMLReader, string);
        if (string2 == null) {
            DeploymentDescriptorParser.failWithLocalName("deployment.parser.missing.attribute", xMLReader, string);
        } else if (string2.equals("")) {
            DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidAttributeValue", xMLReader, string);
        }
        return string2;
    }

    protected static void ensureNoContent(XMLReader xMLReader) {
        if (xMLReader.nextElementContent() != 2) {
            DeploymentDescriptorParser.fail("deployment.parser.unexpectedContent", xMLReader);
        }
    }

    protected static void fail(String string, XMLReader xMLReader) {
        throw new DeploymentException(string, Integer.toString(xMLReader.getLineNumber()));
    }

    protected static void failWithFullName(String string, XMLReader xMLReader) {
        throw new DeploymentException(string, new Object[]{Integer.toString(xMLReader.getLineNumber()), xMLReader.getName().toString()});
    }

    protected static void failWithLocalName(String string, XMLReader xMLReader) {
        throw new DeploymentException(string, new Object[]{Integer.toString(xMLReader.getLineNumber()), xMLReader.getLocalName()});
    }

    protected static void failWithLocalName(String string, XMLReader xMLReader, String string2) {
        throw new DeploymentException(string, new Object[]{Integer.toString(xMLReader.getLineNumber()), xMLReader.getLocalName(), string2});
    }
}

