/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.ant;

import com.sun.xml.rpc.tools.wscompile.CompileTool;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Wscompile
extends MatchingTask {
    protected Path compileClasspath = null;
    private File baseDir = null;
    protected boolean define = false;
    private String features = null;
    private boolean debug = false;
    protected boolean client = false;
    protected boolean server = false;
    protected boolean both = false;
    private String HTTPProxyURL = null;
    private URL proxyURL = null;
    protected boolean genImport = false;
    private boolean keep = false;
    private File modelFile = null;
    private File nonClassDir = null;
    private boolean optimize = false;
    private File sourceBase;
    protected boolean verbose = false;
    protected boolean version = false;
    protected boolean xPrintStackTrace = false;
    private File xDebugModel = null;
    private File config = null;
    private boolean includeAntRuntime = false;
    private boolean includeJavaRuntime = false;

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setClasspath(Path path) {
        if (this.compileClasspath == null) {
            this.compileClasspath = path;
        } else {
            this.compileClasspath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public Path getCP() {
        return this.getClasspath();
    }

    public void setCP(Path path) {
        this.setClasspath(path);
    }

    public File getBase() {
        return this.baseDir;
    }

    public void setBase(File file) {
        this.baseDir = file;
    }

    public boolean getDefine() {
        return this.define;
    }

    public void setDefine(boolean bl) {
        this.define = bl;
    }

    public String getF() {
        return this.getFeatures();
    }

    public void setF(String string) {
        this.setFeatures(string);
    }

    public String getFeatures() {
        return this.features;
    }

    public void setFeatures(String string) {
        this.features = string;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getGen() {
        return this.getClient();
    }

    public void setGen(boolean bl) {
        this.setClient(bl);
    }

    public boolean getClient() {
        return this.client;
    }

    public void setClient(boolean bl) {
        this.client = bl;
    }

    public boolean getServer() {
        return this.server;
    }

    public void setServer(boolean bl) {
        this.server = bl;
    }

    public boolean getBoth() {
        return this.both;
    }

    public void setBoth(boolean bl) {
        this.both = bl;
    }

    public String getHTTPProxy() {
        return this.HTTPProxyURL;
    }

    public void setHTTPProxy(String string) {
        if (string != null && !string.equals("")) {
            this.HTTPProxyURL = string.startsWith("http://") ? string : "http://" + string;
            try {
                URL uRL = new URL(this.HTTPProxyURL);
                this.setProxyServer(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                throw new Error("Invalid HTTP URL specified: " + this.HTTPProxyURL);
            }
        }
    }

    public URL getProxyServer() {
        return this.proxyURL;
    }

    public void setProxyServer(URL uRL) {
        this.proxyURL = uRL;
    }

    public boolean getImport() {
        return this.genImport;
    }

    public void setImport(boolean bl) {
        this.genImport = bl;
    }

    public boolean getKeep() {
        return this.keep;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public File getModel() {
        return this.modelFile;
    }

    public void setModel(File file) {
        this.modelFile = file;
    }

    public File getNonClassDir() {
        return this.nonClassDir;
    }

    public void setNonClassDir(File file) {
        this.nonClassDir = file;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean bl) {
        this.optimize = bl;
    }

    public void setSourceBase(File file) {
        this.keep = true;
        this.sourceBase = file;
    }

    public File getSourceBase() {
        return this.sourceBase;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getVersion() {
        return this.version;
    }

    public void setVersion(boolean bl) {
        this.version = bl;
    }

    public boolean getXPrintStackTrace() {
        return this.xPrintStackTrace;
    }

    public void setXPrintStackTrace(boolean bl) {
        this.xPrintStackTrace = bl;
    }

    public File getXDebugModel() {
        return this.xDebugModel;
    }

    public void setXDebugModel(File file) {
        this.xDebugModel = file;
    }

    public File getConfig() {
        return this.config;
    }

    public void setConfig(File file) {
        this.config = file;
    }

    public void setIncludeantruntime(boolean bl) {
        this.includeAntRuntime = bl;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean bl) {
        this.includeJavaRuntime = bl;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    private Path generateCompileClasspath() {
        Path path = new Path(this.getProject());
        if (this.getClasspath() == null) {
            if (this.getIncludeantruntime()) {
                path.addExisting(Path.systemClasspath);
            }
        } else if (this.getIncludeantruntime()) {
            path.addExisting(this.getClasspath().concatSystemClasspath("last"));
        } else {
            path.addExisting(this.getClasspath().concatSystemClasspath("ignore"));
        }
        if (this.getIncludejavaruntime()) {
            path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
            path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
        }
        return path;
    }

    private Commandline setupWscompileCommand(String[] stringArray) {
        String string;
        Path path;
        Commandline commandline = new Commandline();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                commandline.createArgument().setValue(stringArray[n]);
                ++n;
            }
        }
        if ((path = this.getClasspath()) != null && !path.toString().equals("")) {
            commandline.createArgument().setValue("-classpath");
            commandline.createArgument().setPath(path);
        }
        if (null != this.getBase() && !this.getBase().equals("")) {
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setFile(this.getBase());
        }
        if (this.getDefine()) {
            commandline.createArgument().setValue("-define");
        }
        if (this.getFeatures() != null && !this.getFeatures().equals("")) {
            commandline.createArgument().setValue("-features:" + this.getFeatures());
        }
        if (this.getDebug()) {
            commandline.createArgument().setValue("-g");
        }
        if (this.getBoth()) {
            commandline.createArgument().setValue("-gen:both");
        } else if (this.getClient()) {
            commandline.createArgument().setValue("-gen:client");
        } else if (this.getServer()) {
            commandline.createArgument().setValue("-gen:server");
        }
        if (this.getProxyServer() != null && (string = this.getProxyServer().getHost()) != null && !string.equals("")) {
            String string2 = "-httpproxy:" + string;
            if (this.getProxyServer().getPort() != -1) {
                string2 = string2 + ":" + this.getProxyServer().getPort();
            }
            commandline.createArgument().setValue(string2);
        }
        if (this.getImport()) {
            commandline.createArgument().setValue("-import");
        }
        if (this.getKeep()) {
            commandline.createArgument().setValue("-keep");
        }
        if (this.getModel() != null && !this.getModel().equals("")) {
            commandline.createArgument().setValue("-model");
            commandline.createArgument().setFile(this.getModel());
        }
        if (null != this.getNonClassDir() && !this.getNonClassDir().equals("")) {
            commandline.createArgument().setValue("-nd");
            commandline.createArgument().setFile(this.getNonClassDir());
        }
        if (this.getOptimize()) {
            commandline.createArgument().setValue("-O");
        }
        if (null != this.getSourceBase() && !this.getSourceBase().equals("")) {
            commandline.createArgument().setValue("-s");
            commandline.createArgument().setFile(this.getSourceBase());
        }
        if (this.getVerbose()) {
            commandline.createArgument().setValue("-verbose");
        }
        if (this.getVersion()) {
            commandline.createArgument().setValue("-version");
        }
        if (this.getXPrintStackTrace()) {
            commandline.createArgument().setValue("-Xprintstacktrace");
        }
        if (this.getXDebugModel() != null && !this.getXDebugModel().equals("")) {
            commandline.createArgument().setValue("-Xdebugmodel:" + this.getXDebugModel());
        }
        if (this.getConfig() != null) {
            commandline.createArgument().setValue(this.getConfig().toString());
        }
        return commandline;
    }

    private Commandline setupWscompileCommand() {
        return this.setupWscompileCommand(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (!this.getVersion()) {
            if (this.getConfig() == null) throw new BuildException("wscompile config file does not exist!", this.location);
            if (!this.getConfig().exists()) {
                throw new BuildException("wscompile config file does not exist!", this.location);
            }
        }
        Commandline commandline = this.setupWscompileCommand();
        if (this.verbose) {
            this.log("command line: wscompile " + commandline.toString());
        }
        LogOutputStream logOutputStream = new LogOutputStream((Task)this, 1);
        try {
            try {
                CompileTool compileTool = new CompileTool((OutputStream)logOutputStream, "wscompile");
                boolean bl = compileTool.run(commandline.getArguments());
                if (!bl) {
                    if (this.verbose) throw new BuildException("wscompile failed", this.location);
                    this.log("Command invoked: wscompile " + commandline.toString());
                    throw new BuildException("wscompile failed", this.location);
                }
                Object var6_6 = null;
            }
            catch (Exception exception) {
                if (!(exception instanceof BuildException)) throw new BuildException("Error starting wscompile: ", (Throwable)exception, this.getLocation());
                throw (BuildException)exception;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                logOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
        try {}
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        logOutputStream.close();
    }
}

