/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.util.xml.XmlUtil;
import javax.xml.namespace.QName;

public class XMLReaderUtil {
    private XMLReaderUtil() {
    }

    public static QName getQNameValue(XMLReader xMLReader, QName qName) {
        String string = xMLReader.getAttributes().getValue(qName);
        return string == null ? null : XMLReaderUtil.decodeQName(xMLReader, string);
    }

    public static QName decodeQName(XMLReader xMLReader, String string) {
        String string2 = XmlUtil.getPrefix(string);
        String string3 = XmlUtil.getLocalPart(string);
        String string4 = string2 == null ? null : xMLReader.getURI(string2);
        return new QName(string4, string3);
    }

    public static void verifyReaderState(XMLReader xMLReader, int n) {
        if (xMLReader.getState() != n) {
            throw new XMLReaderException("xmlreader.unexpectedState", new Object[]{XMLReaderUtil.getStateName(n), XMLReaderUtil.getLongStateName(xMLReader)});
        }
    }

    public static String getStateName(XMLReader xMLReader) {
        return XMLReaderUtil.getStateName(xMLReader.getState());
    }

    public static String getLongStateName(XMLReader xMLReader) {
        int n = xMLReader.getState();
        String string = XMLReaderUtil.getStateName(n);
        if (n == 1 || n == 1) {
            string = string + ": " + xMLReader.getName();
        }
        return string;
    }

    public static String getStateName(int n) {
        switch (n) {
            case 0: {
                return "BOF";
            }
            case 1: {
                return "START";
            }
            case 2: {
                return "END";
            }
            case 3: {
                return "CHARS";
            }
            case 4: {
                return "PI";
            }
            case 5: {
                return "EOF";
            }
        }
        return "UNKNOWN";
    }
}

