/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.rpc.sp.NamespaceSupport;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderBase;
import com.sun.xml.rpc.util.StructMap;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class RecordedXMLReader
extends XMLReaderBase {
    protected static final QName EMPTY_QNAME = new QName("");
    int frameIndex = 0;
    List frames = new ArrayList();
    ReaderFrame currentFrame;
    NamespaceSupport originalNamespaces;
    NamespaceSupport namespaceSupport;
    boolean lastRetWasEnd;

    public RecordedXMLReader(XMLReader xMLReader, NamespaceSupport namespaceSupport) {
        this.originalNamespaces = new NamespaceSupport(namespaceSupport);
        this.namespaceSupport = new NamespaceSupport(namespaceSupport);
        this.lastRetWasEnd = false;
        int n = xMLReader.getElementId();
        while (xMLReader.getState() != 2 || xMLReader.getElementId() != n) {
            this.recordFrame(xMLReader);
            xMLReader.next();
        }
        this.recordFrame(xMLReader);
        this.setFrame(0);
    }

    protected void recordFrame(XMLReader xMLReader) {
        AttributeFrame attributeFrame = null;
        switch (xMLReader.getState()) {
            case 1: {
                attributeFrame = new AttributeFrame(xMLReader.getAttributes());
            }
            case 2: {
                this.addFrame(new ReaderFrame(xMLReader.getState(), xMLReader.getElementId(), xMLReader.getLineNumber(), xMLReader.getName(), attributeFrame));
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.addFrame(new ReaderFrame(xMLReader.getState(), xMLReader.getElementId(), xMLReader.getLineNumber(), xMLReader.getValue()));
            }
        }
    }

    protected void addFrame(ReaderFrame readerFrame) {
        this.frames.add(readerFrame);
    }

    protected ReaderFrame getFrame(int n) {
        return (ReaderFrame)this.frames.get(n);
    }

    protected void setFrame(int n) {
        this.currentFrame = this.getFrame(n);
        this.frameIndex = n;
    }

    protected void nextFrame() {
        this.setFrame(this.frameIndex + 1);
    }

    public void reset() {
        this.frameIndex = 0;
        this.lastRetWasEnd = false;
    }

    public void close() {
        this.reset();
    }

    public int getState() {
        return this.currentFrame.state;
    }

    public QName getName() {
        return this.currentFrame.name;
    }

    public String getURI() {
        return this.getName().getNamespaceURI();
    }

    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    public Attributes getAttributes() {
        return this.currentFrame.attributes;
    }

    public String getValue() {
        return this.currentFrame.value;
    }

    public int getElementId() {
        return this.currentFrame.elementId;
    }

    public int getLineNumber() {
        return this.currentFrame.lineNumber;
    }

    public String getURI(String string) {
        return this.namespaceSupport.getURI(string);
    }

    public Iterator getPrefixes() {
        return this.namespaceSupport.getPrefixes();
    }

    public int next() {
        if (this.frameIndex + 1 >= this.frames.size() - 1) {
            return 5;
        }
        this.nextFrame();
        int n = this.getState();
        if (this.lastRetWasEnd) {
            this.namespaceSupport.popContext();
            this.lastRetWasEnd = false;
        }
        if (n == 1) {
            this.namespaceSupport.pushContext();
            Attributes attributes = this.getAttributes();
            int n2 = 0;
            while (n2 < attributes.getLength()) {
                if (attributes.isNamespaceDeclaration(n2)) {
                    String string = attributes.getLocalName(n2);
                    String string2 = attributes.getValue(n2);
                    this.namespaceSupport.declarePrefix(string, string2);
                }
                ++n2;
            }
        } else if (n == 2) {
            this.lastRetWasEnd = true;
        }
        return n;
    }

    public XMLReader recordElement() {
        return new RecordedXMLReader(this, this.namespaceSupport);
    }

    public void skipElement(int n) {
        while (this.currentFrame.state != 5 && (this.currentFrame.state != 2 || this.currentFrame.elementId != n)) {
            if (this.next() != 5) continue;
            return;
        }
    }

    static class AttributeFrame
    implements Attributes {
        private static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
        StructMap recordedAttributes = new StructMap();
        List qnames = null;
        List values = null;

        AttributeFrame(Attributes attributes) {
            int n = 0;
            while (n < attributes.getLength()) {
                this.recordedAttributes.put(attributes.getName(n), attributes.getValue(n));
                ++n;
            }
        }

        List getQNames() {
            if (this.qnames == null) {
                this.qnames = (List)this.recordedAttributes.keys();
            }
            return this.qnames;
        }

        List getValues() {
            if (this.values == null) {
                this.values = (List)this.recordedAttributes.values();
            }
            return this.values;
        }

        public int getIndex(QName qName) {
            List list = this.getQNames();
            int n = 0;
            while (n < list.size()) {
                if (list.get(n).equals(qName)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public int getIndex(String string, String string2) {
            List list = this.getQNames();
            int n = 0;
            while (n < list.size()) {
                QName qName = (QName)list.get(n);
                if (qName.getNamespaceURI().equals(string) && qName.getLocalPart().equals(string2)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public int getIndex(String string) {
            List list = this.getQNames();
            int n = 0;
            while (n < list.size()) {
                QName qName = (QName)list.get(n);
                if (qName.getLocalPart().equals(string)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public int getLength() {
            return this.recordedAttributes.size();
        }

        public String getLocalName(int n) {
            return this.getName(n).getLocalPart();
        }

        public QName getName(int n) {
            List list = this.getQNames();
            return (QName)list.get(n);
        }

        public String getPrefix(int n) {
            QName qName = this.getName(n);
            return XmlUtil.getPrefix(qName.getNamespaceURI());
        }

        public String getURI(int n) {
            return this.getName(n).getNamespaceURI();
        }

        public String getValue(int n) {
            if (n == -1) {
                return null;
            }
            List list = this.getValues();
            return (String)list.get(n);
        }

        public String getValue(QName qName) {
            return this.getValue(this.getIndex(qName));
        }

        public String getValue(String string, String string2) {
            return this.getValue(this.getIndex(string, string2));
        }

        public String getValue(String string) {
            return this.getValue(this.getIndex(string));
        }

        public boolean isNamespaceDeclaration(int n) {
            return this.getURI(n) == XMLNS_NAMESPACE_URI;
        }
    }

    static class ReaderFrame {
        QName name;
        int state;
        Attributes attributes;
        String value;
        int elementId;
        int lineNumber;

        ReaderFrame(int n) {
            this.state = n;
            this.name = EMPTY_QNAME;
            this.attributes = null;
            this.value = null;
            this.elementId = -1;
            this.lineNumber = 0;
        }

        ReaderFrame(int n, int n2, int n3) {
            this(n);
            this.elementId = n2;
            this.lineNumber = n3;
        }

        ReaderFrame(int n, int n2, int n3, QName qName, Attributes attributes) {
            this(n, n2, n3);
            this.name = qName;
            this.attributes = attributes;
        }

        ReaderFrame(int n, int n2, int n3, String string) {
            this(n, n2, n3);
            this.value = string;
        }
    }
}

