/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class LoggingXMLReader
implements XMLReader {
    PrintWriter log;
    XMLReader reader;

    public LoggingXMLReader(OutputStream outputStream, XMLReader xMLReader) {
        this(new PrintWriter(outputStream), xMLReader);
    }

    public LoggingXMLReader(PrintWriter printWriter, XMLReader xMLReader) {
        this.log = printWriter;
        this.reader = xMLReader;
    }

    public int next() {
        int n = this.reader.next();
        this.log.println("Next state: " + XMLReaderUtil.getStateName(this.reader));
        return n;
    }

    public int nextContent() {
        int n = this.reader.nextContent();
        this.log.println("Next content state: " + XMLReaderUtil.getStateName(this.reader));
        return n;
    }

    public int nextElementContent() {
        int n = this.reader.nextElementContent();
        this.log.println("Next element content state: " + XMLReaderUtil.getStateName(this.reader));
        return n;
    }

    public int getState() {
        int n = this.reader.getState();
        this.log.println("Current state: " + XMLReaderUtil.getStateName(this.reader));
        return n;
    }

    public QName getName() {
        QName qName = this.reader.getName();
        this.log.println("name: " + qName);
        return qName;
    }

    public String getURI() {
        String string = this.reader.getURI();
        this.log.println("uri: " + string);
        return string;
    }

    public String getLocalName() {
        String string = this.reader.getLocalName();
        this.log.println("localName: " + string);
        return string;
    }

    public Attributes getAttributes() {
        Attributes attributes = this.reader.getAttributes();
        this.log.println("attributes: " + attributes);
        return attributes;
    }

    public String getValue() {
        String string = this.reader.getValue();
        this.log.println("value: " + string);
        return string;
    }

    public int getElementId() {
        int n = this.reader.getElementId();
        this.log.println("id: " + n);
        return n;
    }

    public int getLineNumber() {
        int n = this.reader.getLineNumber();
        this.log.println("lineNumber: " + n);
        return n;
    }

    public String getURI(String string) {
        String string2 = this.reader.getURI(string);
        this.log.println("uri for: " + string + ": " + string2);
        return string2;
    }

    public Iterator getPrefixes() {
        return this.reader.getPrefixes();
    }

    public XMLReader recordElement() {
        return this.reader.recordElement();
    }

    public void skipElement() {
        this.reader.skipElement();
        this.log.println("Skipped to: " + XMLReaderUtil.getStateName(this.reader));
    }

    public void skipElement(int n) {
        this.reader.skipElement(n);
        this.log.println("Skipped to: " + XMLReaderUtil.getStateName(this.reader));
    }

    public void close() {
        this.reader.close();
        this.log.println("reader closed");
    }
}

