/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http;

import com.sun.xml.rpc.server.http.ServletDelegate;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXRPCServlet
extends HttpServlet {
    protected ServletDelegate delegate = null;
    private LocalizableMessageFactory messageFactory;
    private Localizer localizer;
    private static final String DELEGATE_PROPERTY = "delegate";
    private static final String DEFAULT_DELEGATE_CLASS_NAME = "com.sun.xml.rpc.server.http.JAXRPCServletDelegate";
    private static final String EA_CONFIG_FILE_PROPERTY = "configuration.file";
    private static final String EA_DELEGATE_CLASS_NAME = "com.sun.xml.rpc.server.http.ea.JAXRPCServletDelegate";
    public static final String JAXRPC_RI_RUNTIME_INFO = "com.sun.xml.rpc.server.http.info";
    public static final String JAXRPC_RI_PROPERTY_PUBLISH_WSDL = "com.sun.xml.rpc.server.http.publishWSDL";
    public static final String JAXRPC_RI_PROPERTY_PUBLISH_MODEL = "com.sun.xml.rpc.server.http.publishModel";
    public static final String JAXRPC_RI_PROPERTY_PUBLISH_STATUS_PAGE = "com.sun.xml.rpc.server.http.publishStatusPage";
    private static final Log logger = LogFactory.getLog((String)"javax.enterprise.system.webservices.rpc");

    public void init(ServletConfig servletConfig) throws ServletException {
        this.localizer = new Localizer();
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.jaxrpcservlet");
        try {
            String string = servletConfig.getInitParameter(DELEGATE_PROPERTY);
            if (string == null && servletConfig.getInitParameter(EA_CONFIG_FILE_PROPERTY) != null) {
                string = EA_DELEGATE_CLASS_NAME;
            }
            if (string == null) {
                string = DEFAULT_DELEGATE_CLASS_NAME;
            }
            Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            this.delegate = (ServletDelegate)clazz.newInstance();
            this.delegate.init(servletConfig);
        }
        catch (ServletException servletException) {
            logger.error((Object)servletException.getMessage(), (Throwable)servletException);
            throw servletException;
        }
        catch (Throwable throwable) {
            String string = this.localizer.localize(this.messageFactory.getMessage("error.servlet.caughtThrowableInInit", new Object[]{throwable}));
            logger.error((Object)string, throwable);
            throw new ServletException(string);
        }
    }

    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (this.delegate != null) {
            this.delegate.doPost(httpServletRequest, httpServletResponse);
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (this.delegate != null) {
            this.delegate.doGet(httpServletRequest, httpServletResponse);
        }
    }
}

