/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;

public abstract class ProcessorEnvironmentBase
implements ProcessorEnvironment {
    protected URLClassLoader classLoader = null;

    public URLClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new URLClassLoader(ProcessorEnvironmentBase.pathToURLs(this.getClassPath().toString()));
        }
        return this.classLoader;
    }

    public static URL[] pathToURLs(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = ProcessorEnvironmentBase.fileToURL(new File(stringTokenizer.nextToken()));
            if (object == null) continue;
            uRLArray[n++] = object;
        }
        if (uRLArray.length != n) {
            object = new URL[n];
            System.arraycopy(uRLArray, 0, object, 0, n);
            uRLArray = object;
        }
        return uRLArray;
    }

    public static URL fileToURL(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        string = string.replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!file.isFile()) {
            string = string + "/";
        }
        try {
            return new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("file");
        }
    }
}

