/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.ExtendedModelVisitor;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.literal.LiteralTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.sun.xml.rpc.processor.util.ComponentWriter;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

public class ModelWriter
extends ExtendedModelVisitor
implements ProcessorAction,
SOAPTypeVisitor,
LiteralTypeVisitor {
    private IndentingWriter _writer;
    private ComponentWriter _componentWriter;
    private String _currentNamespaceURI;
    private Set _visitedComplexTypes;
    private static final boolean writeComponentInformation = false;

    public ModelWriter(IndentingWriter indentingWriter) {
        this._writer = indentingWriter;
        this._componentWriter = new ComponentWriter(this._writer);
    }

    public ModelWriter(OutputStream outputStream) {
        this(new IndentingWriter(new OutputStreamWriter(outputStream), 2));
    }

    public ModelWriter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Model model) {
        try {
            try {
                this._visitedComplexTypes = new HashSet();
                this.visit(model);
                this._writer.close();
            }
            catch (Exception exception) {
                Object var4_3 = null;
                this._visitedComplexTypes = null;
                this._currentNamespaceURI = null;
            }
            Object var4_2 = null;
            this._visitedComplexTypes = null;
            this._currentNamespaceURI = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._visitedComplexTypes = null;
            this._currentNamespaceURI = null;
            throw throwable;
        }
    }

    public void perform(Model model, Configuration configuration, Properties properties) {
        this.write(model);
    }

    protected void preVisit(Model model) throws Exception {
        this._writer.p("MODEL ");
        this.writeQName(model.getName());
        this._writer.pln();
        this._writer.pI();
        this._currentNamespaceURI = model.getTargetNamespaceURI();
        if (this._currentNamespaceURI != null) {
            this._writer.p("TARGET-NAMESPACE ");
            this._writer.pln(this._currentNamespaceURI);
        }
    }

    protected void postVisit(Model model) throws Exception {
        this.processTypes(model);
        this._writer.pO();
    }

    protected void processTypes(Model model) throws Exception {
        Iterator iterator = model.getExtraTypes();
        while (iterator.hasNext()) {
            AbstractType abstractType = (AbstractType)iterator.next();
            if (abstractType.isLiteralType()) {
                this.describe((LiteralType)abstractType);
                continue;
            }
            if (!abstractType.isSOAPType()) continue;
            this.describe((SOAPType)abstractType);
        }
    }

    protected void preVisit(Service service) throws Exception {
        this._writer.p("SERVICE ");
        this.writeQName(service.getName());
        this._writer.p(" INTERFACE ");
        this._writer.p(service.getJavaInterface().getName());
        this._writer.pln();
        this._writer.pI();
        this._currentNamespaceURI = service.getName().getNamespaceURI();
    }

    protected void postVisit(Service service) throws Exception {
        this._writer.pO();
    }

    protected void preVisit(Port port) throws Exception {
        this._writer.p("PORT ");
        this.writeQName(port.getName());
        this._writer.p(" INTERFACE ");
        this._writer.p(port.getJavaInterface().getName());
        this._writer.pln();
        this._writer.pI();
        this._currentNamespaceURI = port.getName().getNamespaceURI();
    }

    protected void postVisit(Port port) throws Exception {
        this._writer.pO();
    }

    protected void preVisit(Operation operation) throws Exception {
        this._writer.p("OPERATION ");
        this.writeQName(operation.getName());
        if (operation.isOverloaded()) {
            this._writer.p(" (OVERLOADED)");
        }
        if (operation.getStyle() != null) {
            if (operation.getStyle().equals(SOAPStyle.RPC)) {
                this._writer.p(" (RPC)");
            } else if (operation.getStyle().equals(SOAPStyle.DOCUMENT)) {
                this._writer.p(" (DOCUMENT)");
            }
        }
        this._writer.pln();
        this._writer.pI();
    }

    protected void postVisit(Operation operation) throws Exception {
        this._writer.pO();
    }

    protected void preVisit(Request request) throws Exception {
        this._writer.plnI("REQUEST");
    }

    protected void postVisit(Request request) throws Exception {
        this._writer.pO();
    }

    protected void preVisit(Response response) throws Exception {
        this._writer.plnI("RESPONSE");
    }

    protected void postVisit(Response response) throws Exception {
        this._writer.pO();
    }

    protected void preVisit(Fault fault) throws Exception {
        this._writer.p("FAULT ");
        this._writer.p(fault.getName());
        this._writer.pln();
        this._writer.pI();
    }

    protected void postVisit(Fault fault) throws Exception {
        this._writer.pO();
    }

    protected void visitBodyBlock(Block block) throws Exception {
        this._writer.p("BODY-BLOCK ");
        this.writeQName(block.getName());
        this._writer.p(" TYPE ");
        this.writeQName(block.getType().getName());
        if (block.getType().isLiteralType()) {
            this._writer.pln(" (LITERAL)");
            this.describe((LiteralType)block.getType());
        } else if (block.getType().isSOAPType()) {
            this._writer.pln(" (ENCODED)");
            this.describe((SOAPType)block.getType());
        }
    }

    protected void visitHeaderBlock(Block block) throws Exception {
        this._writer.p("HEADER-BLOCK ");
        this.writeQName(block.getName());
        this._writer.p(" TYPE ");
        this.writeQName(block.getType().getName());
        if (block.getType().isLiteralType()) {
            this._writer.pln(" (LITERAL)");
            this.describe((LiteralType)block.getType());
        } else if (block.getType().isSOAPType()) {
            this._writer.pln(" (ENCODED)");
            this.describe((SOAPType)block.getType());
        }
    }

    protected void visitFaultBlock(Block block) throws Exception {
        this._writer.p("FAULT-BLOCK ");
        this.writeQName(block.getName());
        this._writer.p(" TYPE ");
        this.writeQName(block.getType().getName());
        if (block.getType().isLiteralType()) {
            this._writer.pln(" (LITERAL)");
            this.describe((LiteralType)block.getType());
        } else if (block.getType().isSOAPType()) {
            this._writer.pln(" (ENCODED)");
            this.describe((SOAPType)block.getType());
        }
    }

    protected void visit(Parameter parameter) throws Exception {
        this._writer.p("PARAMETER ");
        this._writer.p(parameter.getName());
        this._writer.p(" TYPE ");
        this.writeQName(parameter.getType().getName());
        if (parameter.isEmbedded()) {
            this._writer.p(" (EMBEDDED)");
        }
        if (parameter.getType().isLiteralType()) {
            this._writer.pln(" (LITERAL)");
            this.describe((LiteralType)parameter.getType());
        } else if (parameter.getType().isSOAPType()) {
            this._writer.pln(" (ENCODED)");
            this.describe((SOAPType)parameter.getType());
        }
    }

    protected void describe(LiteralType literalType) throws Exception {
        this._writer.pI();
        literalType.accept(this);
        this._writer.pO();
    }

    public void visit(LiteralSimpleType literalSimpleType) throws Exception {
        this._writer.p("LITERAL-SIMPLE-TYPE ");
        this.writeQName(literalSimpleType.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(literalSimpleType.getJavaType().getName());
        this._writer.pln();
    }

    public void visit(LiteralSequenceType literalSequenceType) throws Exception {
        this.visitLiteralStructuredType(literalSequenceType, "LITERAL-SEQUENCE-TYPE ", true);
    }

    public void visit(LiteralAllType literalAllType) throws Exception {
        this.visitLiteralStructuredType(literalAllType, "LITERAL-ALL-TYPE ", true);
    }

    private void visitLiteralStructuredType(LiteralStructuredType literalStructuredType, String string, boolean bl) throws Exception {
        boolean bl2 = this._visitedComplexTypes.contains(literalStructuredType);
        this._writer.p(string);
        this.writeQName(literalStructuredType.getName());
        if (bl2) {
            this._writer.p(" (REF)");
        } else {
            this._visitedComplexTypes.add(literalStructuredType);
        }
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(literalStructuredType.getJavaType().getName());
        this._writer.pln();
        if (bl2) {
            return;
        }
        if (bl) {
            this._writer.pI();
            this.processAttributeMembers(literalStructuredType);
            this.processElementMembers(literalStructuredType);
            this._writer.pO();
        }
    }

    protected void processAttributeMembers(LiteralStructuredType literalStructuredType) throws Exception {
        Iterator iterator = literalStructuredType.getAttributeMembers();
        while (iterator.hasNext()) {
            LiteralAttributeMember literalAttributeMember = (LiteralAttributeMember)iterator.next();
            this.writeAttributeMember(literalAttributeMember);
        }
    }

    protected void writeAttributeMember(LiteralAttributeMember literalAttributeMember) throws Exception {
        this._writer.p("ATTRIBUTE ");
        this._writer.p(literalAttributeMember.getName().getLocalPart());
        if (literalAttributeMember.isRequired()) {
            this._writer.p(" (REQUIRED)");
        }
        this._writer.pln();
        this.describe(literalAttributeMember.getType());
    }

    protected void processElementMembers(LiteralStructuredType literalStructuredType) throws Exception {
        Iterator iterator = literalStructuredType.getElementMembers();
        while (iterator.hasNext()) {
            LiteralElementMember literalElementMember = (LiteralElementMember)iterator.next();
            this.writeElementMember(literalElementMember);
        }
    }

    protected void writeElementMember(LiteralElementMember literalElementMember) throws Exception {
        this._writer.p("ELEMENT ");
        this._writer.p(literalElementMember.getName().getLocalPart());
        if (literalElementMember.isNillable()) {
            this._writer.p(" (NILLABLE)");
        }
        if (literalElementMember.isRequired()) {
            this._writer.p(" (REQUIRED)");
        }
        if (literalElementMember.isRepeated()) {
            this._writer.p(" (REPEATED)");
        }
        this._writer.pln();
        this.describe(literalElementMember.getType());
    }

    public void visit(LiteralArrayType literalArrayType) throws Exception {
        this._writer.p("LITERAL-ARRAY-TYPE ");
        this.writeQName(literalArrayType.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(literalArrayType.getJavaType().getName());
        this._writer.pln();
        this.describe(literalArrayType.getElementType());
    }

    public void visit(LiteralFragmentType literalFragmentType) throws Exception {
        this._writer.p("LITERAL-FRAGMENT-TYPE ");
        this.writeQName(literalFragmentType.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(literalFragmentType.getJavaType().getName());
        this._writer.pln();
    }

    protected void describe(SOAPType sOAPType) throws Exception {
        this._writer.pI();
        sOAPType.accept(this);
        this._writer.pO();
    }

    public void visit(SOAPArrayType sOAPArrayType) throws Exception {
        this._writer.p("SOAP-ARRAY-TYPE ");
        this.writeQName(sOAPArrayType.getName());
        this._writer.p(" RANK ");
        this._writer.p(Integer.toString(sOAPArrayType.getRank()));
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(sOAPArrayType.getJavaType().getName());
        this._writer.pln();
        this.describe(sOAPArrayType.getElementType());
    }

    public void visit(SOAPCustomType sOAPCustomType) throws Exception {
        this._writer.p("SOAP-CUSTOM-TYPE ");
        this.writeQName(sOAPCustomType.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(sOAPCustomType.getJavaType().getName());
        this._writer.pln();
        this._writer.pI();
        this._writer.pO();
    }

    public void visit(SOAPEnumerationType sOAPEnumerationType) throws Exception {
        this._writer.p("SOAP-ENUMERATION-TYPE ");
        this.writeQName(sOAPEnumerationType.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(sOAPEnumerationType.getJavaType().getName());
        this._writer.pln();
        this.describe(sOAPEnumerationType.getBaseType());
    }

    public void visit(SOAPSimpleType sOAPSimpleType) throws Exception {
        this._writer.p("SOAP-SIMPLE-TYPE ");
        this.writeQName(sOAPSimpleType.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(sOAPSimpleType.getJavaType().getName());
        this._writer.pln();
    }

    public void visit(SOAPAnyType sOAPAnyType) throws Exception {
        this._writer.p("SOAP-ANY-TYPE ");
        this.writeQName(sOAPAnyType.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(sOAPAnyType.getJavaType().getName());
        this._writer.pln();
    }

    public void visit(SOAPOrderedStructureType sOAPOrderedStructureType) throws Exception {
        this.visitSOAPStructureType(sOAPOrderedStructureType, "SOAP-ORDERED-STRUCTURE-TYPE", true);
    }

    public void visit(SOAPUnorderedStructureType sOAPUnorderedStructureType) throws Exception {
        this.visitSOAPStructureType(sOAPUnorderedStructureType, "SOAP-UNORDERED-STRUCTURE-TYPE", true);
    }

    public void visit(RPCRequestOrderedStructureType rPCRequestOrderedStructureType) throws Exception {
        this.visitSOAPStructureType(rPCRequestOrderedStructureType, "RPC-REQUEST-ORDERED-STRUCTURE-TYPE", false);
    }

    public void visit(RPCRequestUnorderedStructureType rPCRequestUnorderedStructureType) throws Exception {
        this.visitSOAPStructureType(rPCRequestUnorderedStructureType, "RPC-REQUEST-UNORDERED-STRUCTURE-TYPE", false);
    }

    public void visit(RPCResponseStructureType rPCResponseStructureType) throws Exception {
        this.visitSOAPStructureType(rPCResponseStructureType, "RPC-RESPONSE-STRUCTURE-TYPE", false);
    }

    private void visitSOAPStructureType(SOAPStructureType sOAPStructureType, String string, boolean bl) throws Exception {
        boolean bl2 = this._visitedComplexTypes.contains(sOAPStructureType);
        this._writer.p(string);
        this._writer.p(" ");
        this.writeQName(sOAPStructureType.getName());
        if (bl2) {
            this._writer.p(" (REF)");
        } else {
            this._visitedComplexTypes.add(sOAPStructureType);
        }
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(sOAPStructureType.getJavaType().getName());
        this._writer.pln();
        if (bl2) {
            return;
        }
        if (bl) {
            this._writer.pI();
            if (sOAPStructureType.getParentType() != null) {
                this._writer.pln("PARENT TYPE");
                this._writer.pI();
                this.describe(sOAPStructureType.getParentType());
                this._writer.pO();
            }
            this.processMembers(sOAPStructureType);
            this._writer.pO();
        }
    }

    protected void processMembers(SOAPStructureType sOAPStructureType) throws Exception {
        Iterator iterator = sOAPStructureType.getMembers();
        while (iterator.hasNext()) {
            SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)iterator.next();
            this.writeMember(sOAPStructureMember);
        }
    }

    protected void writeMember(SOAPStructureMember sOAPStructureMember) throws Exception {
        this._writer.p("MEMBER ");
        if (sOAPStructureMember.isInherited()) {
            this._writer.p("(INHERITED) ");
        }
        this._writer.p(sOAPStructureMember.getName().getLocalPart());
        this._writer.pln();
        this.describe(sOAPStructureMember.getType());
    }

    protected void writeQName(QName qName) throws IOException {
        if (qName == null) {
            this._writer.p("null");
        } else {
            String string = qName.getNamespaceURI();
            if (!string.equals(this._currentNamespaceURI) && string.length() > 0) {
                if (string.equals("http://schemas.xmlsoap.org/wsdl/")) {
                    this._writer.p("{wsdl}");
                } else if (string.equals("http://www.w3.org/2001/XMLSchema")) {
                    this._writer.p("{xsd}");
                } else {
                    this._writer.p("{");
                    this._writer.p(string);
                    this._writer.p("}");
                }
            }
            this._writer.p(qName.getLocalPart());
        }
    }
}

