/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.schema;

import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.schema.AnnotationComponent;
import com.sun.xml.rpc.processor.schema.AttributeDeclarationComponent;
import com.sun.xml.rpc.processor.schema.AttributeGroupDefinitionComponent;
import com.sun.xml.rpc.processor.schema.AttributeUseComponent;
import com.sun.xml.rpc.processor.schema.ComplexTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.Component;
import com.sun.xml.rpc.processor.schema.ElementDeclarationComponent;
import com.sun.xml.rpc.processor.schema.EnumerationFacet;
import com.sun.xml.rpc.processor.schema.InternalSchema;
import com.sun.xml.rpc.processor.schema.InternalSchemaConstants;
import com.sun.xml.rpc.processor.schema.ModelGroupComponent;
import com.sun.xml.rpc.processor.schema.ModelGroupDefinitionComponent;
import com.sun.xml.rpc.processor.schema.ParticleComponent;
import com.sun.xml.rpc.processor.schema.SimpleTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.Symbol;
import com.sun.xml.rpc.processor.schema.TypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.UnimplementedFeatureException;
import com.sun.xml.rpc.processor.schema.WildcardComponent;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.document.schema.SchemaEntity;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.document.soap.SOAPConstants;
import com.sun.xml.rpc.wsdl.framework.AbstractDocument;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

public class InternalSchemaBuilder {
    private AbstractDocument _document;
    private InternalSchema _schema;
    private Map _wellKnownTypes;
    private Map _wellKnownAttributes;
    private Map _wellKnownAttributeGroups;
    private Map _wellKnownElements;
    private ComplexTypeDefinitionComponent _urType;
    private SimpleTypeDefinitionComponent _simpleUrType;
    private Map _namedTypeComponentsBeingDefined;
    private static final Set _primitiveTypeNames;
    private static final Set _soapTypeNames;
    private static final Set _setEmpty;
    private static final Set _setExtRes;
    private static final Set _setExtResSub;
    private static final Set _setExtResListUnion;
    private static final Set _setLaxSkipStrict;

    public InternalSchemaBuilder(AbstractDocument abstractDocument, Properties properties) {
        this._document = abstractDocument;
        this._schema = new InternalSchema(this);
        this.createWellKnownTypes();
        this.createWellKnownAttributes();
        this.createWellKnownAttributeGroups();
        this.createWellKnownElements();
    }

    public InternalSchema getSchema() {
        return this._schema;
    }

    public TypeDefinitionComponent buildTypeDefinition(QName qName) {
        TypeDefinitionComponent typeDefinitionComponent;
        boolean bl;
        block8: {
            bl = false;
            if (this._namedTypeComponentsBeingDefined == null) {
                this._namedTypeComponentsBeingDefined = new HashMap();
                bl = true;
            }
            typeDefinitionComponent = (TypeDefinitionComponent)this._wellKnownTypes.get(qName);
            if (typeDefinitionComponent == null) break block8;
            TypeDefinitionComponent typeDefinitionComponent2 = typeDefinitionComponent;
            Object var8_7 = null;
            if (bl) {
                this._namedTypeComponentsBeingDefined = null;
            }
            return typeDefinitionComponent2;
        }
        try {
            SchemaEntity schemaEntity = (SchemaEntity)this._document.find(SchemaKinds.XSD_TYPE, qName);
            SchemaElement schemaElement = schemaEntity.getElement();
            typeDefinitionComponent = this.buildTopLevelTypeDefinition(schemaElement, this._schema);
            this._schema.add(typeDefinitionComponent);
            TypeDefinitionComponent typeDefinitionComponent3 = typeDefinitionComponent;
            Object var8_8 = null;
            if (bl) {
                this._namedTypeComponentsBeingDefined = null;
            }
            return typeDefinitionComponent3;
        }
        catch (ValidationException validationException) {
            try {
                throw new ModelException(validationException);
            }
            catch (Throwable throwable) {
                block9: {
                    Object var8_9 = null;
                    if (!bl) break block9;
                    this._namedTypeComponentsBeingDefined = null;
                }
                throw throwable;
            }
        }
    }

    public AttributeDeclarationComponent buildAttributeDeclaration(QName qName) {
        try {
            AttributeDeclarationComponent attributeDeclarationComponent = (AttributeDeclarationComponent)this._wellKnownAttributes.get(qName);
            if (attributeDeclarationComponent != null) {
                return attributeDeclarationComponent;
            }
            SchemaEntity schemaEntity = (SchemaEntity)this._document.find(SchemaKinds.XSD_ATTRIBUTE, qName);
            SchemaElement schemaElement = schemaEntity.getElement();
            attributeDeclarationComponent = this.buildTopLevelAttributeDeclaration(schemaElement, this._schema);
            this._schema.add(attributeDeclarationComponent);
            return attributeDeclarationComponent;
        }
        catch (ValidationException validationException) {
            throw new ModelException(validationException);
        }
    }

    public ElementDeclarationComponent buildElementDeclaration(QName qName) {
        try {
            ElementDeclarationComponent elementDeclarationComponent = (ElementDeclarationComponent)this._wellKnownElements.get(qName);
            if (elementDeclarationComponent != null) {
                return elementDeclarationComponent;
            }
            SchemaEntity schemaEntity = (SchemaEntity)this._document.find(SchemaKinds.XSD_ELEMENT, qName);
            SchemaElement schemaElement = schemaEntity.getElement();
            elementDeclarationComponent = this.buildTopLevelElementDeclaration(schemaElement, this._schema);
            this._schema.add(elementDeclarationComponent);
            return elementDeclarationComponent;
        }
        catch (ValidationException validationException) {
            throw new ModelException(validationException);
        }
    }

    public AttributeGroupDefinitionComponent buildAttributeGroupDefinition(QName qName) {
        try {
            AttributeGroupDefinitionComponent attributeGroupDefinitionComponent = (AttributeGroupDefinitionComponent)this._wellKnownAttributeGroups.get(qName);
            if (attributeGroupDefinitionComponent != null) {
                return attributeGroupDefinitionComponent;
            }
            SchemaEntity schemaEntity = (SchemaEntity)this._document.find(SchemaKinds.XSD_ATTRIBUTE_GROUP, qName);
            SchemaElement schemaElement = schemaEntity.getElement();
            attributeGroupDefinitionComponent = this.buildTopLevelAttributeGroupDefinition(schemaElement, this._schema);
            this._schema.add(attributeGroupDefinitionComponent);
            return attributeGroupDefinitionComponent;
        }
        catch (ValidationException validationException) {
            throw new ModelException(validationException);
        }
    }

    public ModelGroupDefinitionComponent buildModelGroupDefinition(QName qName) {
        this.failUnimplemented("F002");
        return null;
    }

    public ComplexTypeDefinitionComponent getUrType() {
        return this._urType;
    }

    public SimpleTypeDefinitionComponent getSimpleUrType() {
        return this._simpleUrType;
    }

    protected ElementDeclarationComponent buildTopLevelElementDeclaration(SchemaElement schemaElement, InternalSchema internalSchema) {
        ElementDeclarationComponent elementDeclarationComponent = this.internalBuildElementDeclaration(schemaElement, internalSchema);
        String string = schemaElement.getValueOfMandatoryAttribute("name");
        elementDeclarationComponent.setName(new QName(schemaElement.getSchema().getTargetNamespaceURI(), string));
        if (schemaElement.getValueOfAttributeOrNull("minOccurs") != null) {
            this.failValidation("validation.invalidAttribute", "minOccurs", schemaElement.getLocalName());
        }
        if (schemaElement.getValueOfAttributeOrNull("maxOccurs") != null) {
            this.failValidation("validation.invalidAttribute", "maxOccurs", schemaElement.getLocalName());
        }
        return elementDeclarationComponent;
    }

    protected AttributeGroupDefinitionComponent buildTopLevelAttributeGroupDefinition(SchemaElement schemaElement, InternalSchema internalSchema) {
        AttributeGroupDefinitionComponent attributeGroupDefinitionComponent = new AttributeGroupDefinitionComponent();
        String string = schemaElement.getValueOfMandatoryAttribute("name");
        attributeGroupDefinitionComponent.setName(new QName(schemaElement.getSchema().getTargetNamespaceURI(), string));
        Iterator iterator = schemaElement.children();
        while (iterator.hasNext()) {
            SchemaElement schemaElement2 = (SchemaElement)iterator.next();
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE)) {
                attributeGroupDefinitionComponent.addAttributeUse(this.buildAttributeUse(schemaElement2, null, internalSchema));
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE_GROUP)) {
                String string2 = schemaElement2.getValueOfMandatoryAttribute("ref");
                attributeGroupDefinitionComponent.addAttributeGroup(internalSchema.findAttributeGroupDefinition(schemaElement2.asQName(string2)));
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ANY_ATTRIBUTE)) {
                this.failUnimplemented("F003");
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            this.failValidation("validation.invalidElement", schemaElement2.getLocalName());
        }
        return attributeGroupDefinitionComponent;
    }

    protected AttributeDeclarationComponent buildTopLevelAttributeDeclaration(SchemaElement schemaElement, InternalSchema internalSchema) {
        Object object;
        Object object2;
        AttributeDeclarationComponent attributeDeclarationComponent = new AttributeDeclarationComponent();
        String string = schemaElement.getValueOfMandatoryAttribute("name");
        String string2 = schemaElement.getValueOfAttributeOrNull("form");
        if (string2 == null && (string2 = schemaElement.getRoot().getValueOfAttributeOrNull("attributeFormDefault")) == null) {
            string2 = "";
        }
        if (string2.equals("qualified")) {
            attributeDeclarationComponent.setName(new QName(schemaElement.getSchema().getTargetNamespaceURI(), string));
        } else {
            attributeDeclarationComponent.setName(new QName(string));
        }
        attributeDeclarationComponent.setScope(null);
        boolean bl = false;
        Iterator iterator = schemaElement.children();
        while (iterator.hasNext()) {
            object2 = (SchemaElement)iterator.next();
            if (((SchemaElement)object2).getQName().equals(SchemaConstants.QNAME_SIMPLE_TYPE)) {
                if (bl) {
                    this.failValidation("validation.invalidElement", schemaElement.getLocalName());
                }
                attributeDeclarationComponent.setTypeDefinition(this.buildSimpleTypeDefinition((SchemaElement)object2, internalSchema));
                bl = true;
                continue;
            }
            if (((SchemaElement)object2).getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            this.failValidation("validation.invalidElement", ((SchemaElement)object2).getLocalName());
        }
        if (bl) {
            this.assertNoAttribute(schemaElement, "type");
        } else {
            object2 = schemaElement.getValueOfAttributeOrNull("type");
            if (object2 == null) {
                attributeDeclarationComponent.setTypeDefinition(this.getSimpleUrType());
            } else {
                object = internalSchema.findTypeDefinition(schemaElement.asQName((String)object2));
                if (object instanceof SimpleTypeDefinitionComponent) {
                    attributeDeclarationComponent.setTypeDefinition((SimpleTypeDefinitionComponent)object);
                } else {
                    this.failValidation("validation.notSimpleType", attributeDeclarationComponent.getName().getLocalPart());
                }
            }
        }
        attributeDeclarationComponent.setAnnotation(this.buildNonSchemaAttributesAnnotation(schemaElement));
        object2 = schemaElement.getValueOfAttributeOrNull("default");
        object = schemaElement.getValueOfAttributeOrNull("fixed");
        if (object2 != null && object != null) {
            this.fail("validation.exclusiveAttributes", "default", "fixed");
        }
        if (object2 != null) {
            attributeDeclarationComponent.setValue((String)object2);
            attributeDeclarationComponent.setValueKind(Symbol.DEFAULT);
        }
        if (object != null) {
            attributeDeclarationComponent.setValue((String)object2);
            attributeDeclarationComponent.setValueKind(Symbol.FIXED);
        }
        return attributeDeclarationComponent;
    }

    protected void processElementParticle(SchemaElement schemaElement, ParticleComponent particleComponent, ComplexTypeDefinitionComponent complexTypeDefinitionComponent, InternalSchema internalSchema) {
        particleComponent.setTermTag(3);
        ElementDeclarationComponent elementDeclarationComponent = this.internalBuildElementDeclaration(schemaElement, internalSchema);
        String string = schemaElement.getValueOfAttributeOrNull("ref");
        if (string != null) {
            this.failUnimplemented("F004");
        }
        String string2 = schemaElement.getValueOfMandatoryAttribute("name");
        String string3 = schemaElement.getValueOfAttributeOrNull("form");
        if (string3 == null && (string3 = schemaElement.getRoot().getValueOfAttributeOrNull("elementFormDefault")) == null) {
            string3 = "";
        }
        if (string3.equals("qualified")) {
            elementDeclarationComponent.setName(new QName(schemaElement.getSchema().getTargetNamespaceURI(), string2));
        } else {
            elementDeclarationComponent.setName(new QName(string2));
        }
        elementDeclarationComponent.setScope(complexTypeDefinitionComponent);
        particleComponent.setTermTag(3);
        particleComponent.setElementTerm(elementDeclarationComponent);
    }

    protected ElementDeclarationComponent internalBuildElementDeclaration(SchemaElement schemaElement, InternalSchema internalSchema) {
        String string;
        Object object;
        String string2;
        Object object2;
        ElementDeclarationComponent elementDeclarationComponent = new ElementDeclarationComponent();
        boolean bl = false;
        Iterator iterator = schemaElement.children();
        while (iterator.hasNext()) {
            object2 = (SchemaElement)iterator.next();
            if (((SchemaElement)object2).getQName().equals(SchemaConstants.QNAME_SIMPLE_TYPE)) {
                if (bl) {
                    this.failValidation("validation.invalidElement", schemaElement.getLocalName());
                }
                elementDeclarationComponent.setTypeDefinition(this.buildSimpleTypeDefinition((SchemaElement)object2, internalSchema));
                bl = true;
                continue;
            }
            if (!((SchemaElement)object2).getQName().equals(SchemaConstants.QNAME_COMPLEX_TYPE)) continue;
            if (bl) {
                this.failValidation("validation.invalidElement", schemaElement.getLocalName());
            }
            elementDeclarationComponent.setTypeDefinition(this.buildComplexTypeDefinition((SchemaElement)object2, internalSchema));
            bl = true;
        }
        if (bl) {
            this.assertNoAttribute(schemaElement, "type");
            this.assertNoAttribute(schemaElement, "substitutionGroup");
        } else {
            object2 = schemaElement.getValueOfAttributeOrNull("type");
            string2 = schemaElement.getValueOfAttributeOrNull("substitutionGroup");
            if (object2 == null && string2 == null) {
                elementDeclarationComponent.setTypeDefinition(this.getUrType());
            } else if (object2 != null && string2 != null) {
                this.failValidation("validation.exclusiveAttributes", "type", "substitutionGroup");
            } else if (object2 != null) {
                elementDeclarationComponent.setTypeDefinition(internalSchema.findTypeDefinition(schemaElement.asQName((String)object2)));
            } else {
                this.failUnimplemented("F005");
            }
        }
        elementDeclarationComponent.setNillable(schemaElement.getValueOfBooleanAttributeOrDefault("nillable", false));
        object2 = schemaElement.getValueOfAttributeOrNull("default");
        string2 = schemaElement.getValueOfAttributeOrNull("fixed");
        if (object2 != null && string2 != null) {
            this.fail("validation.exclusiveAttributes", "default", "fixed");
        }
        if (object2 != null) {
            elementDeclarationComponent.setValue((String)object2);
            elementDeclarationComponent.setValueKind(Symbol.DEFAULT);
            if (elementDeclarationComponent.getTypeDefinition() instanceof ComplexTypeDefinitionComponent) {
                this.failValidation("validation.notSimpleType", elementDeclarationComponent.getName().getLocalPart());
            }
        }
        if (string2 != null) {
            elementDeclarationComponent.setValue((String)object2);
            elementDeclarationComponent.setValueKind(Symbol.FIXED);
            if (elementDeclarationComponent.getTypeDefinition() instanceof ComplexTypeDefinitionComponent) {
                this.failValidation("validation.notSimpleType", elementDeclarationComponent.getName().getLocalPart());
            }
        }
        Iterator iterator2 = schemaElement.children();
        while (iterator2.hasNext()) {
            object = (SchemaElement)iterator2.next();
            if (!((SchemaElement)object).getQName().equals(SchemaConstants.QNAME_KEY) && !((SchemaElement)object).getQName().equals(SchemaConstants.QNAME_KEYREF) && !((SchemaElement)object).getQName().equals(SchemaConstants.QNAME_UNIQUE)) continue;
            this.failUnimplemented("F006");
        }
        object = schemaElement.getValueOfQNameAttributeOrNull("substitutionGroup");
        if (object != null) {
            this.failUnimplemented("F007");
        }
        if ((string = schemaElement.getValueOfAttributeOrNull("block")) == null && (string = schemaElement.getRoot().getValueOfAttributeOrNull("blockDefault")) == null) {
            string = "";
        }
        if (string.equals("")) {
            elementDeclarationComponent.setDisallowedSubstitutions(_setEmpty);
        } else if (string.equals("#all")) {
            elementDeclarationComponent.setDisallowedSubstitutions(_setExtResSub);
        } else {
            elementDeclarationComponent.setDisallowedSubstitutions(this.parseSymbolSet(string, _setExtResSub));
            this.failUnimplemented("F008");
        }
        String string3 = schemaElement.getValueOfAttributeOrNull("final");
        if (string3 == null && (string3 = schemaElement.getRoot().getValueOfAttributeOrNull("finalDefault")) == null) {
            string3 = "";
        }
        if (string3.equals("")) {
            elementDeclarationComponent.setSubstitutionsGroupExclusions(_setEmpty);
        } else if (string3.equals("#all")) {
            elementDeclarationComponent.setSubstitutionsGroupExclusions(_setExtRes);
        } else {
            elementDeclarationComponent.setSubstitutionsGroupExclusions(this.parseSymbolSet(string3, _setExtRes));
            this.failUnimplemented("F009");
        }
        elementDeclarationComponent.setAbstract(schemaElement.getValueOfBooleanAttributeOrDefault("abstract", false));
        return elementDeclarationComponent;
    }

    protected TypeDefinitionComponent buildTopLevelTypeDefinition(SchemaElement schemaElement, InternalSchema internalSchema) {
        TypeDefinitionComponent typeDefinitionComponent = null;
        if (schemaElement.getQName().equals(SchemaConstants.QNAME_SIMPLE_TYPE)) {
            typeDefinitionComponent = this.buildSimpleTypeDefinition(schemaElement, internalSchema);
        } else if (schemaElement.getQName().equals(SchemaConstants.QNAME_COMPLEX_TYPE)) {
            typeDefinitionComponent = this.buildComplexTypeDefinition(schemaElement, internalSchema);
        } else {
            this.failValidation("validation.invalidElement", schemaElement.getLocalName());
        }
        return typeDefinitionComponent;
    }

    protected SimpleTypeDefinitionComponent buildSimpleTypeDefinition(SchemaElement schemaElement, InternalSchema internalSchema) {
        SimpleTypeDefinitionComponent simpleTypeDefinitionComponent = new SimpleTypeDefinitionComponent();
        String string = schemaElement.getValueOfAttributeOrNull("name");
        if (string != null) {
            simpleTypeDefinitionComponent.setName(new QName(schemaElement.getSchema().getTargetNamespaceURI(), string));
            this._namedTypeComponentsBeingDefined.put(simpleTypeDefinitionComponent.getName(), simpleTypeDefinitionComponent);
        }
        boolean bl = false;
        Iterator iterator = schemaElement.children();
        while (iterator.hasNext()) {
            SchemaElement schemaElement2 = (SchemaElement)iterator.next();
            if (bl) {
                this.failValidation("validation.invalidElement", schemaElement2.getLocalName());
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_RESTRICTION)) {
                this.buildRestrictionSimpleTypeDefinition(simpleTypeDefinitionComponent, schemaElement2, internalSchema);
                bl = true;
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_LIST)) {
                this.buildListSimpleTypeDefinition(simpleTypeDefinitionComponent, schemaElement2, internalSchema);
                bl = true;
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_UNION)) {
                this.failUnimplemented("F011");
                continue;
            }
            this.failValidation("validation.invalidElement", schemaElement2.getLocalName());
        }
        return simpleTypeDefinitionComponent;
    }

    protected void buildRestrictionSimpleTypeDefinition(SimpleTypeDefinitionComponent simpleTypeDefinitionComponent, SchemaElement schemaElement, InternalSchema internalSchema) {
        Object object;
        String string = schemaElement.getValueOfAttributeOrNull("base");
        if (string != null) {
            object = internalSchema.findTypeDefinition(schemaElement.asQName(string));
            if (((TypeDefinitionComponent)object).isSimple()) {
                simpleTypeDefinitionComponent.setBaseTypeDefinition((SimpleTypeDefinitionComponent)object);
            } else {
                this.failValidation("validation.notSimpleType", ((TypeDefinitionComponent)object).getName().getLocalPart());
            }
        } else {
            this.failUnimplemented("F012");
        }
        simpleTypeDefinitionComponent.setVarietyTag(simpleTypeDefinitionComponent.getBaseTypeDefinition().getVarietyTag());
        simpleTypeDefinitionComponent.setPrimitiveTypeDefinition(simpleTypeDefinitionComponent.getBaseTypeDefinition().getPrimitiveTypeDefinition());
        object = schemaElement.getValueOfAttributeOrNull("final");
        if (object == null && (object = schemaElement.getRoot().getValueOfAttributeOrNull("finalDefault")) == null) {
            object = "";
        }
        if (((String)object).equals("")) {
            simpleTypeDefinitionComponent.setFinal(_setEmpty);
        } else if (((String)object).equals("#all")) {
            simpleTypeDefinitionComponent.setFinal(_setExtResListUnion);
        } else {
            simpleTypeDefinitionComponent.setFinal(this.parseSymbolSet((String)object, _setExtResListUnion));
            this.failUnimplemented("F013");
        }
        boolean bl = false;
        EnumerationFacet enumerationFacet = new EnumerationFacet();
        Iterator iterator = schemaElement.children();
        while (iterator.hasNext()) {
            SchemaElement schemaElement2 = (SchemaElement)iterator.next();
            bl = true;
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ENUMERATION)) {
                String string2 = schemaElement2.getValueOfAttributeOrNull("value");
                if (string2 == null) {
                    this.failValidation("validation.missingRequiredAttribute", "value", schemaElement2.getQName().getLocalPart());
                }
                enumerationFacet.addValue(string2);
                continue;
            }
            this.failUnimplemented("F014");
        }
        simpleTypeDefinitionComponent.addFacet(enumerationFacet);
    }

    protected void buildListSimpleTypeDefinition(SimpleTypeDefinitionComponent simpleTypeDefinitionComponent, SchemaElement schemaElement, InternalSchema internalSchema) {
        Object object;
        simpleTypeDefinitionComponent.setBaseTypeDefinition(this.getSimpleUrType());
        String string = schemaElement.getValueOfAttributeOrNull("itemType");
        if (string != null) {
            object = internalSchema.findTypeDefinition(schemaElement.asQName(string));
            if (((TypeDefinitionComponent)object).isSimple()) {
                simpleTypeDefinitionComponent.setItemTypeDefinition((SimpleTypeDefinitionComponent)object);
            } else {
                this.failValidation("validation.notSimpleType", ((TypeDefinitionComponent)object).getName().getLocalPart());
            }
        } else {
            object = this.getOnlyChildIgnoring(schemaElement, SchemaConstants.QNAME_ANNOTATION);
            if (!((SchemaElement)object).getQName().equals(SchemaConstants.QNAME_SIMPLE_TYPE)) {
                this.failValidation("validation.invalidElement", ((SchemaElement)object).getLocalName());
            }
            SimpleTypeDefinitionComponent simpleTypeDefinitionComponent2 = this.buildSimpleTypeDefinition((SchemaElement)object, internalSchema);
            simpleTypeDefinitionComponent.setItemTypeDefinition(simpleTypeDefinitionComponent2);
        }
        simpleTypeDefinitionComponent.setVarietyTag(2);
        object = schemaElement.getValueOfAttributeOrNull("final");
        if (object == null && (object = schemaElement.getRoot().getValueOfAttributeOrNull("finalDefault")) == null) {
            object = "";
        }
        if (((String)object).equals("")) {
            simpleTypeDefinitionComponent.setFinal(_setEmpty);
        } else if (((String)object).equals("#all")) {
            simpleTypeDefinitionComponent.setFinal(_setExtResListUnion);
        } else {
            simpleTypeDefinitionComponent.setFinal(this.parseSymbolSet((String)object, _setExtResListUnion));
            this.failUnimplemented("F013");
        }
    }

    protected ComplexTypeDefinitionComponent buildComplexTypeDefinition(SchemaElement schemaElement, InternalSchema internalSchema) {
        Iterator iterator = schemaElement.children();
        while (iterator.hasNext()) {
            SchemaElement schemaElement2 = (SchemaElement)iterator.next();
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_SIMPLE_CONTENT)) {
                return this.buildSimpleContentComplexTypeDefinition(schemaElement, internalSchema);
            }
            if (!schemaElement2.getQName().equals(SchemaConstants.QNAME_COMPLEX_CONTENT)) continue;
            boolean bl = schemaElement.getValueOfBooleanAttributeOrDefault("mixed", false);
            return this.buildExplicitComplexContentComplexTypeDefinition(schemaElement, bl, internalSchema);
        }
        boolean bl = schemaElement.getValueOfBooleanAttributeOrDefault("mixed", false);
        return this.buildImplicitComplexContentComplexTypeDefinition(schemaElement, bl, internalSchema);
    }

    protected ComplexTypeDefinitionComponent commonBuildComplexTypeDefinition(SchemaElement schemaElement, InternalSchema internalSchema) {
        ComplexTypeDefinitionComponent complexTypeDefinitionComponent = new ComplexTypeDefinitionComponent();
        String string = schemaElement.getValueOfAttributeOrNull("name");
        if (string != null) {
            complexTypeDefinitionComponent.setName(new QName(schemaElement.getSchema().getTargetNamespaceURI(), string));
            this._namedTypeComponentsBeingDefined.put(complexTypeDefinitionComponent.getName(), complexTypeDefinitionComponent);
        }
        complexTypeDefinitionComponent.setAbstract(schemaElement.getValueOfBooleanAttributeOrDefault("abstract", false));
        String string2 = schemaElement.getValueOfAttributeOrNull("block");
        if (string2 == null && (string2 = schemaElement.getRoot().getValueOfAttributeOrNull("blockDefault")) == null) {
            string2 = "";
        }
        if (string2.equals("")) {
            complexTypeDefinitionComponent.setProhibitedSubstitutions(_setEmpty);
        } else if (string2.equals("#all")) {
            complexTypeDefinitionComponent.setProhibitedSubstitutions(_setExtRes);
        } else {
            complexTypeDefinitionComponent.setProhibitedSubstitutions(this.parseSymbolSet(string2, _setExtRes));
            this.failUnimplemented("F015");
        }
        String string3 = schemaElement.getValueOfAttributeOrNull("final");
        if (string3 == null && (string3 = schemaElement.getRoot().getValueOfAttributeOrNull("finalDefault")) == null) {
            string3 = "";
        }
        if (string3.equals("")) {
            complexTypeDefinitionComponent.setFinal(_setEmpty);
        } else if (string3.equals("#all")) {
            complexTypeDefinitionComponent.setFinal(_setExtRes);
        } else {
            complexTypeDefinitionComponent.setFinal(this.parseSymbolSet(string3, _setExtRes));
            this.failUnimplemented("F016");
        }
        return complexTypeDefinitionComponent;
    }

    protected ComplexTypeDefinitionComponent buildSimpleContentComplexTypeDefinition(SchemaElement schemaElement, InternalSchema internalSchema) {
        String string;
        ComplexTypeDefinitionComponent complexTypeDefinitionComponent = this.commonBuildComplexTypeDefinition(schemaElement, internalSchema);
        SchemaElement schemaElement2 = this.getOnlyChildIgnoring(schemaElement, SchemaConstants.QNAME_ANNOTATION);
        if (!schemaElement2.getQName().equals(SchemaConstants.QNAME_SIMPLE_CONTENT)) {
            this.failValidation("validation.invalidElement", schemaElement2.getLocalName());
        }
        complexTypeDefinitionComponent.setContentTag(2);
        SchemaElement schemaElement3 = this.getOnlyChildIgnoring(schemaElement2, SchemaConstants.QNAME_ANNOTATION);
        boolean bl = true;
        if (!schemaElement3.getQName().equals(SchemaConstants.QNAME_RESTRICTION)) {
            if (schemaElement3.getQName().equals(SchemaConstants.QNAME_EXTENSION)) {
                bl = false;
            } else {
                this.failValidation("validation.invalidElement", schemaElement3.getLocalName());
            }
        }
        if ((string = schemaElement3.getValueOfAttributeOrNull("base")) == null) {
            complexTypeDefinitionComponent.setBaseTypeDefinition(this.getUrType());
        } else {
            complexTypeDefinitionComponent.setBaseTypeDefinition(internalSchema.findTypeDefinition(schemaElement.asQName(string)));
        }
        complexTypeDefinitionComponent.setDerivationMethod(bl ? Symbol.RESTRICTION : Symbol.EXTENSION);
        if (bl) {
            this.processRestrictionSimpleTypeDefinition(schemaElement3, complexTypeDefinitionComponent, internalSchema);
        } else {
            this.processExtensionSimpleTypeDefinition(schemaElement3, complexTypeDefinitionComponent, internalSchema);
        }
        return complexTypeDefinitionComponent;
    }

    protected void processRestrictionSimpleTypeDefinition(SchemaElement schemaElement, ComplexTypeDefinitionComponent complexTypeDefinitionComponent, InternalSchema internalSchema) {
        boolean bl = false;
        Iterator iterator = schemaElement.children();
        while (iterator.hasNext()) {
            Object object;
            SchemaElement schemaElement2 = (SchemaElement)iterator.next();
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE)) {
                object = this.buildAttributeUse(schemaElement2, complexTypeDefinitionComponent, internalSchema);
                if (object == null) {
                    this.failUnimplemented("F019");
                    continue;
                }
                complexTypeDefinitionComponent.addAttributeUse((AttributeUseComponent)object);
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE_GROUP)) {
                object = schemaElement2.getValueOfMandatoryAttribute("ref");
                complexTypeDefinitionComponent.addAttributeGroup(internalSchema.findAttributeGroupDefinition(schemaElement2.asQName((String)object)));
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ANY_ATTRIBUTE)) {
                this.failUnimplemented("F020");
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            this.failUnimplemented("F023");
        }
    }

    protected void processExtensionSimpleTypeDefinition(SchemaElement schemaElement, ComplexTypeDefinitionComponent complexTypeDefinitionComponent, InternalSchema internalSchema) {
        boolean bl = false;
        Iterator iterator = schemaElement.children();
        while (iterator.hasNext()) {
            Object object;
            SchemaElement schemaElement2 = (SchemaElement)iterator.next();
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE)) {
                object = this.buildAttributeUse(schemaElement2, complexTypeDefinitionComponent, internalSchema);
                if (object == null) {
                    this.failUnimplemented("F019");
                    continue;
                }
                complexTypeDefinitionComponent.addAttributeUse((AttributeUseComponent)object);
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE_GROUP)) {
                object = schemaElement2.getValueOfMandatoryAttribute("ref");
                complexTypeDefinitionComponent.addAttributeGroup(internalSchema.findAttributeGroupDefinition(schemaElement2.asQName((String)object)));
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ANY_ATTRIBUTE)) {
                this.failUnimplemented("F020");
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            this.failUnimplemented("F023");
        }
    }

    protected ComplexTypeDefinitionComponent buildExplicitComplexContentComplexTypeDefinition(SchemaElement schemaElement, boolean bl, InternalSchema internalSchema) {
        ComplexTypeDefinitionComponent complexTypeDefinitionComponent = this.commonBuildComplexTypeDefinition(schemaElement, internalSchema);
        SchemaElement schemaElement2 = this.getOnlyChildIgnoring(schemaElement, SchemaConstants.QNAME_ANNOTATION);
        if (!schemaElement2.getQName().equals(SchemaConstants.QNAME_COMPLEX_CONTENT)) {
            this.failValidation("validation.invalidElement", schemaElement2.getLocalName());
        }
        boolean bl2 = schemaElement2.getValueOfBooleanAttributeOrDefault("mixed", bl);
        SchemaElement schemaElement3 = this.getOnlyChildIgnoring(schemaElement2, SchemaConstants.QNAME_ANNOTATION);
        boolean bl3 = true;
        if (!schemaElement3.getQName().equals(SchemaConstants.QNAME_RESTRICTION)) {
            if (schemaElement3.getQName().equals(SchemaConstants.QNAME_EXTENSION)) {
                bl3 = false;
            } else {
                this.failValidation("validation.invalidElement", schemaElement3.getLocalName());
            }
        }
        if (bl3) {
            String string = schemaElement3.getValueOfMandatoryAttribute("base");
            TypeDefinitionComponent typeDefinitionComponent = internalSchema.findTypeDefinition(schemaElement3.asQName(string));
            complexTypeDefinitionComponent.setBaseTypeDefinition(typeDefinitionComponent);
            if (bl2) {
                complexTypeDefinitionComponent.setContentTag(3);
            } else {
                complexTypeDefinitionComponent.setContentTag(4);
            }
            this.processRestrictionComplexTypeDefinition(schemaElement3, complexTypeDefinitionComponent, internalSchema);
        } else {
            String string = schemaElement3.getValueOfMandatoryAttribute("base");
            TypeDefinitionComponent typeDefinitionComponent = internalSchema.findTypeDefinition(schemaElement3.asQName(string));
            complexTypeDefinitionComponent.setBaseTypeDefinition(typeDefinitionComponent);
            if (bl2) {
                complexTypeDefinitionComponent.setContentTag(3);
            } else {
                complexTypeDefinitionComponent.setContentTag(4);
            }
            this.processExtensionComplexTypeDefinition(schemaElement3, complexTypeDefinitionComponent, internalSchema);
        }
        complexTypeDefinitionComponent.setDerivationMethod(bl3 ? Symbol.RESTRICTION : Symbol.EXTENSION);
        return complexTypeDefinitionComponent;
    }

    protected ComplexTypeDefinitionComponent buildImplicitComplexContentComplexTypeDefinition(SchemaElement schemaElement, boolean bl, InternalSchema internalSchema) {
        ComplexTypeDefinitionComponent complexTypeDefinitionComponent = this.commonBuildComplexTypeDefinition(schemaElement, internalSchema);
        complexTypeDefinitionComponent.setBaseTypeDefinition(this.getUrType());
        if (bl) {
            complexTypeDefinitionComponent.setContentTag(3);
        } else {
            complexTypeDefinitionComponent.setContentTag(4);
        }
        this.processRestrictionComplexTypeDefinition(schemaElement, complexTypeDefinitionComponent, internalSchema);
        return complexTypeDefinitionComponent;
    }

    protected void processRestrictionComplexTypeDefinition(SchemaElement schemaElement, ComplexTypeDefinitionComponent complexTypeDefinitionComponent, InternalSchema internalSchema) {
        boolean bl = false;
        Iterator iterator = schemaElement.children();
        while (iterator.hasNext()) {
            Object object;
            SchemaElement schemaElement2 = (SchemaElement)iterator.next();
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE)) {
                object = this.buildAttributeUse(schemaElement2, complexTypeDefinitionComponent, internalSchema);
                if (object == null) {
                    this.failUnimplemented("F019");
                    continue;
                }
                complexTypeDefinitionComponent.addAttributeUse((AttributeUseComponent)object);
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE_GROUP)) {
                object = schemaElement2.getValueOfMandatoryAttribute("ref");
                complexTypeDefinitionComponent.addAttributeGroup(internalSchema.findAttributeGroupDefinition(schemaElement2.asQName((String)object)));
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ANY_ATTRIBUTE)) {
                this.failUnimplemented("F020");
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            if (bl) {
                this.failValidation("validation.invalidElement", schemaElement2.getLocalName());
            }
            bl = true;
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_GROUP)) {
                this.failUnimplemented("F021");
                continue;
            }
            complexTypeDefinitionComponent.setParticleContent(this.buildParticle(schemaElement2, complexTypeDefinitionComponent, internalSchema));
        }
        if (!bl) {
            complexTypeDefinitionComponent.setContentTag(1);
        }
    }

    protected void processExtensionComplexTypeDefinition(SchemaElement schemaElement, ComplexTypeDefinitionComponent complexTypeDefinitionComponent, InternalSchema internalSchema) {
        boolean bl = false;
        Iterator iterator = schemaElement.children();
        while (iterator.hasNext()) {
            Object object;
            SchemaElement schemaElement2 = (SchemaElement)iterator.next();
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE)) {
                object = this.buildAttributeUse(schemaElement2, complexTypeDefinitionComponent, internalSchema);
                if (object == null) {
                    this.failUnimplemented("F019");
                    continue;
                }
                complexTypeDefinitionComponent.addAttributeUse((AttributeUseComponent)object);
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE_GROUP)) {
                object = schemaElement2.getValueOfMandatoryAttribute("ref");
                complexTypeDefinitionComponent.addAttributeGroup(internalSchema.findAttributeGroupDefinition(schemaElement2.asQName((String)object)));
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ANY_ATTRIBUTE)) {
                this.failUnimplemented("F020");
                continue;
            }
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            if (bl) {
                this.failValidation("validation.invalidElement", schemaElement2.getLocalName());
            }
            bl = true;
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_GROUP)) {
                this.failUnimplemented("F021");
                continue;
            }
            complexTypeDefinitionComponent.setParticleContent(this.buildParticle(schemaElement2, complexTypeDefinitionComponent, internalSchema));
        }
        if (!bl) {
            complexTypeDefinitionComponent.setContentTag(1);
        }
    }

    protected AttributeUseComponent buildAttributeUse(SchemaElement schemaElement, ComplexTypeDefinitionComponent complexTypeDefinitionComponent, InternalSchema internalSchema) {
        String string;
        Object object;
        String string2;
        AttributeUseComponent attributeUseComponent = new AttributeUseComponent();
        String string3 = schemaElement.getValueOfAttributeOrNull("use");
        if (string3 != null) {
            if (string3.equals("required")) {
                attributeUseComponent.setRequired(true);
            } else if (string3.equals("prohibited")) {
                return null;
            }
        }
        if ((string2 = schemaElement.getValueOfAttributeOrNull("ref")) != null) {
            this.assertNoAttribute(schemaElement, "name");
            this.assertNoAttribute(schemaElement, "type");
            attributeUseComponent.setAttributeDeclaration(internalSchema.findAttributeDeclaration(schemaElement.asQName(string2)));
            attributeUseComponent.setAnnotation(this.buildNonSchemaAttributesAnnotation(schemaElement));
        } else {
            Object object2;
            object = new AttributeDeclarationComponent();
            string = schemaElement.getValueOfMandatoryAttribute("name");
            String string4 = schemaElement.getValueOfAttributeOrNull("form");
            if (string4 == null && (string4 = schemaElement.getRoot().getValueOfAttributeOrNull("attributeFormDefault")) == null) {
                string4 = "";
            }
            if (string4.equals("qualified")) {
                ((AttributeDeclarationComponent)object).setName(new QName(schemaElement.getSchema().getTargetNamespaceURI(), string));
            } else {
                ((AttributeDeclarationComponent)object).setName(new QName(string));
            }
            ((AttributeDeclarationComponent)object).setScope(complexTypeDefinitionComponent);
            boolean bl = false;
            Iterator iterator = schemaElement.children();
            while (iterator.hasNext()) {
                object2 = (SchemaElement)iterator.next();
                if (((SchemaElement)object2).getQName().equals(SchemaConstants.QNAME_SIMPLE_TYPE)) {
                    if (bl) {
                        this.failValidation("validation.invalidElement", schemaElement.getLocalName());
                    }
                    ((AttributeDeclarationComponent)object).setTypeDefinition(this.buildSimpleTypeDefinition((SchemaElement)object2, internalSchema));
                    bl = true;
                    continue;
                }
                if (((SchemaElement)object2).getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
                this.failValidation("validation.invalidElement", ((SchemaElement)object2).getLocalName());
            }
            if (bl) {
                this.assertNoAttribute(schemaElement, "type");
            } else {
                object2 = schemaElement.getValueOfAttributeOrNull("type");
                if (object2 == null) {
                    ((AttributeDeclarationComponent)object).setTypeDefinition(this.getSimpleUrType());
                } else {
                    TypeDefinitionComponent typeDefinitionComponent = internalSchema.findTypeDefinition(schemaElement.asQName((String)object2));
                    if (typeDefinitionComponent instanceof SimpleTypeDefinitionComponent) {
                        ((AttributeDeclarationComponent)object).setTypeDefinition((SimpleTypeDefinitionComponent)typeDefinitionComponent);
                    } else {
                        this.failValidation("validation.notSimpleType", ((AttributeDeclarationComponent)object).getName().getLocalPart());
                    }
                }
            }
            ((AttributeDeclarationComponent)object).setAnnotation(this.buildNonSchemaAttributesAnnotation(schemaElement));
            attributeUseComponent.setAttributeDeclaration((AttributeDeclarationComponent)object);
        }
        object = schemaElement.getValueOfAttributeOrNull("default");
        string = schemaElement.getValueOfAttributeOrNull("fixed");
        if (object != null && string != null) {
            this.fail("validation.exclusiveAttributes", "default", "fixed");
        }
        if (object != null) {
            attributeUseComponent.setValue((String)object);
            attributeUseComponent.setValueKind(Symbol.DEFAULT);
        }
        if (string != null) {
            attributeUseComponent.setValue((String)object);
            attributeUseComponent.setValueKind(Symbol.FIXED);
        }
        return attributeUseComponent;
    }

    protected ParticleComponent buildParticle(SchemaElement schemaElement, ComplexTypeDefinitionComponent complexTypeDefinitionComponent, InternalSchema internalSchema) {
        ParticleComponent particleComponent = new ParticleComponent();
        int n = schemaElement.getValueOfIntegerAttributeOrDefault("minOccurs", 1);
        particleComponent.setMinOccurs(n);
        String string = schemaElement.getValueOfAttributeOrNull("maxOccurs");
        if (string == null) {
            particleComponent.setMaxOccurs(1);
        } else if (string.equals("unbounded")) {
            particleComponent.setMaxOccursUnbounded();
        } else {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 < 0 || n2 < n) {
                    this.failValidation("validation.invalidAttributeValue", "maxOccurs", string);
                }
                particleComponent.setMaxOccurs(n2);
            }
            catch (NumberFormatException numberFormatException) {
                this.failValidation("validation.invalidAttributeValue", "maxOccurs", string);
            }
        }
        if (schemaElement.getQName().equals(SchemaConstants.QNAME_ELEMENT)) {
            this.processElementParticle(schemaElement, particleComponent, complexTypeDefinitionComponent, internalSchema);
        } else if (schemaElement.getQName().equals(SchemaConstants.QNAME_ALL) || schemaElement.getQName().equals(SchemaConstants.QNAME_CHOICE) || schemaElement.getQName().equals(SchemaConstants.QNAME_SEQUENCE)) {
            particleComponent.setTermTag(1);
            particleComponent.setModelGroupTerm(this.buildModelGroup(schemaElement, complexTypeDefinitionComponent, internalSchema));
        } else if (schemaElement.getQName().equals(SchemaConstants.QNAME_ANY)) {
            particleComponent.setTermTag(2);
            particleComponent.setWildcardTerm(this.buildAnyWildcard(schemaElement, complexTypeDefinitionComponent, internalSchema));
        } else {
            this.failValidation("validation.invalidElement", schemaElement.getLocalName());
        }
        return particleComponent;
    }

    protected ModelGroupComponent buildModelGroup(SchemaElement schemaElement, ComplexTypeDefinitionComponent complexTypeDefinitionComponent, InternalSchema internalSchema) {
        ModelGroupComponent modelGroupComponent = new ModelGroupComponent();
        if (schemaElement.getQName().equals(SchemaConstants.QNAME_ALL)) {
            modelGroupComponent.setCompositor(Symbol.ALL);
        } else if (schemaElement.getQName().equals(SchemaConstants.QNAME_CHOICE)) {
            modelGroupComponent.setCompositor(Symbol.CHOICE);
        } else if (schemaElement.getQName().equals(SchemaConstants.QNAME_SEQUENCE)) {
            modelGroupComponent.setCompositor(Symbol.SEQUENCE);
        } else {
            this.failValidation("validation.invalidElement", schemaElement.getLocalName());
        }
        Iterator iterator = schemaElement.children();
        while (iterator.hasNext()) {
            SchemaElement schemaElement2 = (SchemaElement)iterator.next();
            if (schemaElement2.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            ParticleComponent particleComponent = this.buildParticle(schemaElement2, complexTypeDefinitionComponent, internalSchema);
            modelGroupComponent.addParticle(particleComponent);
        }
        return modelGroupComponent;
    }

    protected WildcardComponent buildAnyWildcard(SchemaElement schemaElement, ComplexTypeDefinitionComponent complexTypeDefinitionComponent, InternalSchema internalSchema) {
        Object object;
        WildcardComponent wildcardComponent = new WildcardComponent();
        String string = schemaElement.getValueOfAttributeOrNull("processContents");
        if (string != null) {
            object = this.parseSymbolInSet(string, _setLaxSkipStrict);
            if (object == null) {
                this.failValidation("validation.invalidAttribute", "processContents", schemaElement.getLocalName());
            }
            wildcardComponent.setProcessContents((Symbol)object);
        } else {
            wildcardComponent.setProcessContents(Symbol.STRICT);
        }
        object = schemaElement.getValueOfAttributeOrNull("namespace");
        if (object != null) {
            if (((String)object).equals("##any")) {
                wildcardComponent.setNamespaceConstraintTag(1);
            } else if (((String)object).equals("##other")) {
                String string2 = schemaElement.getSchema().getTargetNamespaceURI();
                if (string2 == null || string2.equals("")) {
                    wildcardComponent.setNamespaceConstraintTag(3);
                } else {
                    wildcardComponent.setNamespaceConstraintTag(2);
                    wildcardComponent.setNamespaceName(string2);
                }
            } else {
                this.failUnimplemented("F022");
            }
        } else {
            wildcardComponent.setNamespaceConstraintTag(1);
        }
        return wildcardComponent;
    }

    protected AnnotationComponent buildNonSchemaAttributesAnnotation(SchemaElement schemaElement) {
        AnnotationComponent annotationComponent = null;
        Iterator iterator = schemaElement.attributes();
        while (iterator.hasNext()) {
            SchemaAttribute schemaAttribute = (SchemaAttribute)iterator.next();
            if (schemaAttribute.getNamespaceURI() == null || schemaAttribute.getNamespaceURI().equals("") || schemaAttribute.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) continue;
            if (annotationComponent == null) {
                annotationComponent = new AnnotationComponent();
            }
            annotationComponent.addAttribute(schemaAttribute);
        }
        return annotationComponent;
    }

    public TypeDefinitionComponent getTypeDefinitionComponentBeingDefined(QName qName) {
        if (this._namedTypeComponentsBeingDefined != null) {
            return (TypeDefinitionComponent)this._namedTypeComponentsBeingDefined.get(qName);
        }
        return null;
    }

    protected void createWellKnownTypes() {
        Component component;
        Object object;
        ComplexTypeDefinitionComponent complexTypeDefinitionComponent;
        Object object2;
        Object object3;
        this._wellKnownTypes = new HashMap();
        this._urType = new ComplexTypeDefinitionComponent();
        this._urType.setName(InternalSchemaConstants.QNAME_TYPE_URTYPE);
        this._urType.setBaseTypeDefinition(this._urType);
        this._urType.setFinal(_setEmpty);
        this._urType.setProhibitedSubstitutions(_setEmpty);
        this._urType.setDerivationMethod(Symbol.RESTRICTION);
        this._urType.setContentTag(3);
        ParticleComponent particleComponent = new ParticleComponent();
        particleComponent.setMinOccurs(1);
        particleComponent.setMaxOccurs(1);
        ModelGroupComponent modelGroupComponent = new ModelGroupComponent();
        modelGroupComponent.setCompositor(Symbol.SEQUENCE);
        ParticleComponent particleComponent2 = new ParticleComponent();
        particleComponent2.setMinOccurs(0);
        particleComponent2.setMaxOccursUnbounded();
        WildcardComponent wildcardComponent = new WildcardComponent();
        wildcardComponent.setNamespaceConstraintTag(1);
        particleComponent2.setTermTag(2);
        particleComponent2.setWildcardTerm(wildcardComponent);
        modelGroupComponent.addParticle(particleComponent2);
        particleComponent.setTermTag(1);
        particleComponent.setModelGroupTerm(modelGroupComponent);
        this._urType.setParticleContent(particleComponent);
        this._wellKnownTypes.put(this._urType.getName(), this._urType);
        this._simpleUrType = new SimpleTypeDefinitionComponent();
        this._simpleUrType.setName(InternalSchemaConstants.QNAME_TYPE_SIMPLE_URTYPE);
        this._simpleUrType.setBaseTypeDefinition(this._simpleUrType);
        this._simpleUrType.setFinal(_setEmpty);
        this._wellKnownTypes.put(this._simpleUrType.getName(), this._simpleUrType);
        Iterator iterator = _primitiveTypeNames.iterator();
        while (iterator.hasNext()) {
            object3 = (QName)iterator.next();
            object2 = new SimpleTypeDefinitionComponent();
            ((TypeDefinitionComponent)object2).setName((QName)object3);
            ((SimpleTypeDefinitionComponent)object2).setVarietyTag(1);
            ((SimpleTypeDefinitionComponent)object2).setFinal(_setEmpty);
            ((SimpleTypeDefinitionComponent)object2).setBaseTypeDefinition(this._simpleUrType);
            ((SimpleTypeDefinitionComponent)object2).setPrimitiveTypeDefinition((SimpleTypeDefinitionComponent)object2);
            this._wellKnownTypes.put(((TypeDefinitionComponent)object2).getName(), object2);
        }
        object3 = _soapTypeNames.iterator();
        while (object3.hasNext()) {
            object2 = (QName)object3.next();
            complexTypeDefinitionComponent = new ComplexTypeDefinitionComponent();
            complexTypeDefinitionComponent.setName((QName)object2);
            complexTypeDefinitionComponent.setBaseTypeDefinition(this._urType);
            complexTypeDefinitionComponent.setContentTag(2);
            object = new QName("http://www.w3.org/2001/XMLSchema", ((QName)object2).getLocalPart());
            component = (SimpleTypeDefinitionComponent)this._wellKnownTypes.get(object);
            if (component == null) continue;
            complexTypeDefinitionComponent.setSimpleTypeContent((SimpleTypeDefinitionComponent)component);
            this._wellKnownTypes.put(complexTypeDefinitionComponent.getName(), complexTypeDefinitionComponent);
        }
        object2 = new SimpleTypeDefinitionComponent();
        ((TypeDefinitionComponent)object2).setName(SOAPConstants.QNAME_TYPE_BASE64);
        ((SimpleTypeDefinitionComponent)object2).setVarietyTag(1);
        ((SimpleTypeDefinitionComponent)object2).setFinal(_setEmpty);
        ((SimpleTypeDefinitionComponent)object2).setBaseTypeDefinition(this._simpleUrType);
        ((SimpleTypeDefinitionComponent)object2).setPrimitiveTypeDefinition((SimpleTypeDefinitionComponent)object2);
        this._wellKnownTypes.put(((TypeDefinitionComponent)object2).getName(), object2);
        complexTypeDefinitionComponent = new ComplexTypeDefinitionComponent();
        complexTypeDefinitionComponent.setName(SOAPConstants.QNAME_TYPE_ARRAY);
        complexTypeDefinitionComponent.setBaseTypeDefinition(this._urType);
        complexTypeDefinitionComponent.setDerivationMethod(Symbol.RESTRICTION);
        complexTypeDefinitionComponent.setContentTag(4);
        object = new ParticleComponent();
        ((ParticleComponent)object).setMinOccurs(1);
        ((ParticleComponent)object).setMaxOccurs(1);
        component = new ModelGroupComponent();
        ((ModelGroupComponent)component).setCompositor(Symbol.SEQUENCE);
        ParticleComponent particleComponent3 = new ParticleComponent();
        particleComponent3.setMinOccurs(0);
        particleComponent3.setMaxOccursUnbounded();
        WildcardComponent wildcardComponent2 = new WildcardComponent();
        wildcardComponent2.setNamespaceConstraintTag(1);
        particleComponent3.setTermTag(2);
        particleComponent3.setWildcardTerm(wildcardComponent2);
        ((ModelGroupComponent)component).addParticle(particleComponent3);
        ((ParticleComponent)object).setTermTag(1);
        ((ParticleComponent)object).setModelGroupTerm((ModelGroupComponent)component);
        complexTypeDefinitionComponent.setParticleContent((ParticleComponent)object);
        this._wellKnownTypes.put(complexTypeDefinitionComponent.getName(), complexTypeDefinitionComponent);
    }

    protected void createWellKnownAttributes() {
        this._wellKnownAttributes = new HashMap();
        AttributeDeclarationComponent attributeDeclarationComponent = new AttributeDeclarationComponent();
        attributeDeclarationComponent.setName(SOAPConstants.QNAME_ATTR_ARRAY_TYPE);
        attributeDeclarationComponent.setTypeDefinition((SimpleTypeDefinitionComponent)this._wellKnownTypes.get(SchemaConstants.QNAME_TYPE_STRING));
        this._wellKnownAttributes.put(attributeDeclarationComponent.getName(), attributeDeclarationComponent);
        AttributeDeclarationComponent attributeDeclarationComponent2 = new AttributeDeclarationComponent();
        attributeDeclarationComponent2.setName(SOAPConstants.QNAME_ATTR_OFFSET);
        attributeDeclarationComponent2.setTypeDefinition((SimpleTypeDefinitionComponent)this._wellKnownTypes.get(SchemaConstants.QNAME_TYPE_STRING));
        this._wellKnownAttributes.put(attributeDeclarationComponent2.getName(), attributeDeclarationComponent2);
        AttributeDeclarationComponent attributeDeclarationComponent3 = new AttributeDeclarationComponent();
        attributeDeclarationComponent3.setName(new QName("http://www.w3.org/XML/1998/namespace", "lang"));
        attributeDeclarationComponent3.setTypeDefinition((SimpleTypeDefinitionComponent)this._wellKnownTypes.get(SchemaConstants.QNAME_TYPE_STRING));
        this._wellKnownAttributes.put(attributeDeclarationComponent3.getName(), attributeDeclarationComponent3);
    }

    protected void createWellKnownAttributeGroups() {
        this._wellKnownAttributeGroups = new HashMap();
        AttributeGroupDefinitionComponent attributeGroupDefinitionComponent = new AttributeGroupDefinitionComponent();
        attributeGroupDefinitionComponent.setName(SOAPConstants.QNAME_ATTR_GROUP_COMMON_ATTRIBUTES);
        AttributeDeclarationComponent attributeDeclarationComponent = new AttributeDeclarationComponent();
        attributeDeclarationComponent.setName(SOAPConstants.QNAME_ATTR_ID);
        attributeDeclarationComponent.setTypeDefinition((SimpleTypeDefinitionComponent)this._wellKnownTypes.get(SchemaConstants.QNAME_TYPE_ID));
        AttributeUseComponent attributeUseComponent = new AttributeUseComponent();
        attributeUseComponent.setAttributeDeclaration(attributeDeclarationComponent);
        attributeGroupDefinitionComponent.addAttributeUse(attributeUseComponent);
        AttributeDeclarationComponent attributeDeclarationComponent2 = new AttributeDeclarationComponent();
        attributeDeclarationComponent2.setName(SOAPConstants.QNAME_ATTR_HREF);
        attributeDeclarationComponent2.setTypeDefinition((SimpleTypeDefinitionComponent)this._wellKnownTypes.get(SchemaConstants.QNAME_TYPE_ANY_URI));
        AttributeUseComponent attributeUseComponent2 = new AttributeUseComponent();
        attributeUseComponent2.setAttributeDeclaration(attributeDeclarationComponent2);
        attributeGroupDefinitionComponent.addAttributeUse(attributeUseComponent2);
        this._wellKnownAttributeGroups.put(attributeGroupDefinitionComponent.getName(), attributeGroupDefinitionComponent);
    }

    protected void createWellKnownElements() {
        this._wellKnownElements = new HashMap();
    }

    private Set parseSymbolSet(String string, Set set) {
        if (string.equals("#all")) {
            return set;
        }
        HashSet<Symbol> hashSet = new HashSet<Symbol>();
        List list = XmlUtil.parseTokenList(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Symbol symbol = Symbol.named(string2);
            if (symbol == null || !set.contains(symbol)) continue;
            hashSet.add(symbol);
        }
        return hashSet;
    }

    private Symbol parseSymbolInSet(String string, Set set) {
        Symbol symbol = Symbol.named(string);
        if (symbol != null && set.contains(symbol)) {
            return symbol;
        }
        return null;
    }

    private SchemaElement getOnlyChildIgnoring(SchemaElement schemaElement, QName qName) {
        SchemaElement schemaElement2 = null;
        Iterator iterator = schemaElement.children();
        while (iterator.hasNext()) {
            SchemaElement schemaElement3 = (SchemaElement)iterator.next();
            if (schemaElement3.getQName().equals(qName)) continue;
            if (schemaElement2 != null) {
                this.failValidation("validation.invalidElement", schemaElement3.getLocalName());
            }
            schemaElement2 = schemaElement3;
        }
        if (schemaElement2 == null) {
            this.failValidation("validation.invalidElement", schemaElement.getLocalName());
        }
        return schemaElement2;
    }

    private void assertNoAttribute(SchemaElement schemaElement, String string) {
        String string2 = schemaElement.getValueOfAttributeOrNull(string);
        if (string2 != null) {
            this.failValidation("validation.invalidAttribute", string);
        }
    }

    private void fail(String string) {
        throw new ModelException(string);
    }

    private void fail(String string, QName qName) {
        this.fail(string, this.toString(qName));
    }

    private void fail(String string, String string2) {
        throw new ModelException(string, string2);
    }

    private void fail(String string, String string2, String string3) {
        throw new ModelException(string, new Object[]{string2, string3});
    }

    private void failUnimplemented(String string) {
        throw new UnimplementedFeatureException(string);
    }

    private void failValidation(String string) {
        throw new ValidationException(string);
    }

    private void failValidation(String string, String string2) {
        throw new ValidationException(string, string2);
    }

    private void failValidation(String string, String string2, String string3) {
        throw new ValidationException(string, new Object[]{string2, string3});
    }

    private String toString(QName qName) {
        return qName.getLocalPart() + " (" + qName.getNamespaceURI() + ")";
    }

    static {
        _setEmpty = new HashSet();
        _setExtRes = new HashSet();
        _setExtRes.add(Symbol.EXTENSION);
        _setExtRes.add(Symbol.RESTRICTION);
        _setExtResSub = new HashSet();
        _setExtResSub.add(Symbol.EXTENSION);
        _setExtResSub.add(Symbol.RESTRICTION);
        _setExtResSub.add(Symbol.SUBSTITUTION);
        _setExtResListUnion = new HashSet();
        _setExtResListUnion.add(Symbol.EXTENSION);
        _setExtResListUnion.add(Symbol.RESTRICTION);
        _setExtResListUnion.add(Symbol.LIST);
        _setExtResListUnion.add(Symbol.UNION);
        _setLaxSkipStrict = new HashSet();
        _setLaxSkipStrict.add(Symbol.LAX);
        _setLaxSkipStrict.add(Symbol.SKIP);
        _setLaxSkipStrict.add(Symbol.STRICT);
        _primitiveTypeNames = new HashSet();
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_STRING);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NORMALIZED_STRING);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_TOKEN);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_BYTE);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_UNSIGNED_BYTE);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_BASE64_BINARY);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_HEX_BINARY);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_INTEGER);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_POSITIVE_INTEGER);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NEGATIVE_INTEGER);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NON_NEGATIVE_INTEGER);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NON_POSITIVE_INTEGER);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_INT);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_UNSIGNED_INT);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_LONG);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_UNSIGNED_LONG);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_SHORT);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_UNSIGNED_SHORT);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_DECIMAL);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_FLOAT);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_DOUBLE);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_BOOLEAN);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_TIME);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_DATE_TIME);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_DURATION);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_DATE);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_G_MONTH);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_G_YEAR);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_G_YEAR_MONTH);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_G_DAY);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_G_MONTH_DAY);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NAME);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_QNAME);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NCNAME);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_ANY_URI);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_ID);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_IDREF);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_IDREFS);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_ENTITY);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_ENTITIES);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NOTATION);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NMTOKEN);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NMTOKENS);
        _soapTypeNames = new HashSet();
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_STRING);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NORMALIZED_STRING);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_TOKEN);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_BYTE);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_UNSIGNED_BYTE);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_BASE64_BINARY);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_HEX_BINARY);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_INTEGER);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_POSITIVE_INTEGER);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NEGATIVE_INTEGER);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NON_NEGATIVE_INTEGER);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NON_POSITIVE_INTEGER);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_INT);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_UNSIGNED_INT);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_LONG);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_UNSIGNED_LONG);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_SHORT);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_UNSIGNED_SHORT);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_DECIMAL);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_FLOAT);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_DOUBLE);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_BOOLEAN);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_TIME);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_DATE_TIME);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_DURATION);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_DATE);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_G_MONTH);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_G_YEAR);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_G_YEAR_MONTH);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_G_DAY);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_G_MONTH_DAY);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NAME);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_QNAME);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NCNAME);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_ANY_URI);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_ID);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_IDREF);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_IDREFS);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_ENTITY);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_ENTITIES);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NOTATION);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NMTOKEN);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NMTOKENS);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_BASE64);
    }
}

