/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model;

import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.ModelObject;
import com.sun.xml.rpc.processor.model.ModelVisitor;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;

public class Operation
extends ModelObject {
    private QName _name;
    private String _uniqueName;
    private Request _request;
    private Response _response;
    private JavaMethod _javaMethod;
    private String _soapAction;
    private SOAPStyle _style;
    private Set _faultNames;
    private Set _faults;

    public Operation() {
    }

    public Operation(QName qName) {
        this._name = qName;
        this._uniqueName = qName.getLocalPart();
        this._faultNames = new HashSet();
        this._faults = new HashSet();
    }

    public QName getName() {
        return this._name;
    }

    public void setName(QName qName) {
        this._name = qName;
    }

    public String getUniqueName() {
        return this._uniqueName;
    }

    public void setUniqueName(String string) {
        this._uniqueName = string;
    }

    public Request getRequest() {
        return this._request;
    }

    public void setRequest(Request request) {
        this._request = request;
    }

    public Response getResponse() {
        return this._response;
    }

    public void setResponse(Response response) {
        this._response = response;
    }

    public boolean isOverloaded() {
        return !this._name.getLocalPart().equals(this._uniqueName);
    }

    public void addFault(Fault fault) {
        if (this._faultNames.contains(fault.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this._faultNames.add(fault.getName());
        this._faults.add(fault);
    }

    public Iterator getFaults() {
        return this._faults.iterator();
    }

    public Set getFaultsSet() {
        return this._faults;
    }

    public void setFaultsSet(Set set) {
        this._faults = set;
        this.initializeFaultNames();
    }

    private void initializeFaultNames() {
        this._faultNames = new HashSet();
        if (this._faults != null) {
            Iterator iterator = this._faults.iterator();
            while (iterator.hasNext()) {
                Fault fault = (Fault)iterator.next();
                if (fault.getName() != null && this._faultNames.contains(fault.getName())) {
                    throw new ModelException("model.uniqueness");
                }
                this._faultNames.add(fault.getName());
            }
        }
    }

    public Iterator getAllFaults() {
        Set set = this.getAllFaultsSet();
        if (set.size() == 0) {
            return null;
        }
        return set.iterator();
    }

    public Set getAllFaultsSet() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this._faults);
        Iterator iterator = this._faults.iterator();
        while (iterator.hasNext()) {
            Set set = ((Fault)iterator.next()).getAllFaultsSet();
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public int getFaultCount() {
        return this._faults.size();
    }

    public JavaMethod getJavaMethod() {
        return this._javaMethod;
    }

    public void setJavaMethod(JavaMethod javaMethod) {
        this._javaMethod = javaMethod;
    }

    public String getSOAPAction() {
        return this._soapAction;
    }

    public void setSOAPAction(String string) {
        this._soapAction = string;
    }

    public SOAPStyle getStyle() {
        return this._style;
    }

    public void setStyle(SOAPStyle sOAPStyle) {
        this._style = sOAPStyle;
    }

    public void accept(ModelVisitor modelVisitor) throws Exception {
        modelVisitor.visit(this);
    }
}

