/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.ArraySerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.CollectionSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.CustomSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.DynamicSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.EnumerationSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.InterfaceSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.LiteralFragmentSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.LiteralSequenceSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.LiteralSimpleSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SOAPObjectSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterFactory;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class SerializerWriterFactoryImpl
implements SerializerWriterFactory {
    private Map writerMap = new HashMap();
    private Names names;

    public SerializerWriterFactoryImpl(Names names) {
        this.names = names;
    }

    public SerializerWriter createWriter(AbstractType abstractType) {
        SerializerWriter serializerWriter = this.getTypeSerializerWriter(abstractType);
        if (serializerWriter == null) {
            if (abstractType instanceof SOAPAnyType) {
                serializerWriter = new DynamicSerializerWriter((SOAPType)abstractType, this.names);
            } else if (abstractType instanceof SOAPSimpleType) {
                serializerWriter = CollectionSerializerWriter.handlesType(abstractType) ? new CollectionSerializerWriter((SOAPType)abstractType, this.names) : new SimpleTypeSerializerWriter((SOAPType)abstractType, this.names);
            } else if (abstractType instanceof SOAPStructureType) {
                serializerWriter = ((SOAPStructureType)abstractType).getSubtypes() != null ? new InterfaceSerializerWriter((SOAPType)abstractType, this.names) : new SOAPObjectSerializerWriter((SOAPType)abstractType, this.names);
            } else if (abstractType instanceof SOAPArrayType) {
                serializerWriter = new ArraySerializerWriter((SOAPType)abstractType, this.names);
            } else if (abstractType instanceof SOAPEnumerationType) {
                serializerWriter = new EnumerationSerializerWriter((SOAPType)abstractType, this.names);
            } else if (abstractType instanceof SOAPCustomType) {
                serializerWriter = new CustomSerializerWriter((SOAPType)abstractType, this.names);
            } else if (abstractType instanceof LiteralFragmentType) {
                serializerWriter = new LiteralFragmentSerializerWriter((LiteralFragmentType)abstractType, this.names);
            } else if (abstractType instanceof LiteralSimpleType) {
                serializerWriter = new LiteralSimpleSerializerWriter((LiteralSimpleType)abstractType, this.names);
            } else if (abstractType instanceof LiteralSequenceType) {
                serializerWriter = new LiteralSequenceSerializerWriter((LiteralSequenceType)abstractType, this.names);
            } else if (abstractType instanceof LiteralAllType) {
                serializerWriter = new LiteralSequenceSerializerWriter((LiteralAllType)abstractType, this.names);
            }
            if (serializerWriter == null) {
                throw new GeneratorException("generator.unsupported.type.encountered", new Object[]{abstractType.getName().getLocalPart(), abstractType.getName().getNamespaceURI()});
            }
            this.setTypeSerializerWriter(abstractType, serializerWriter);
        }
        return serializerWriter;
    }

    private SerializerWriter getTypeSerializerWriter(AbstractType abstractType) {
        String string = SerializerWriterFactoryImpl.genKey(abstractType.getName(), abstractType.getJavaType().getName());
        SerializerWriter serializerWriter = (SerializerWriter)this.writerMap.get(string);
        return serializerWriter;
    }

    private void setTypeSerializerWriter(AbstractType abstractType, SerializerWriter serializerWriter) {
        String string = SerializerWriterFactoryImpl.genKey(abstractType.getName(), abstractType.getJavaType().getName());
        this.writerMap.put(string, serializerWriter);
    }

    protected static String genKey(QName qName, String string) {
        return qName + ";" + string;
    }
}

