/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.LiteralSerializerWriterBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.wsdl.document.schema.BuiltInTypes;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class LiteralSimpleSerializerWriter
extends LiteralSerializerWriterBase
implements GeneratorConstants {
    private String encoder = null;
    private String serializerMemberName;
    private static Map encoderMap = null;

    public LiteralSimpleSerializerWriter(LiteralType literalType, Names names) {
        super(literalType, names);
        this.encoder = LiteralSimpleSerializerWriter.getTypeEncoder(literalType);
        if (this.encoder == null) {
            throw new GeneratorException("generator.simpleTypeSerializerWriter.no.encoder.for.type", new Object[]{literalType.getName().toString(), literalType.getJavaType().getName()});
        }
        String string = this.encoder.substring(3, this.encoder.lastIndexOf("Encoder"));
        String string2 = string + "_Serializer";
        this.serializerMemberName = names.getClassMemberName(string, literalType, "_Serializer");
    }

    public void createSerializer(IndentingWriter indentingWriter, StringBuffer stringBuffer, String string, boolean bl, boolean bl2, String string2) throws IOException {
        LiteralType literalType = (LiteralType)this.type;
        this.declareType(indentingWriter, stringBuffer, literalType.getName(), false, false);
        QName qName = literalType.getName();
        indentingWriter.plnI(this.serializerName() + " " + string + " = new " + GeneratorConstants.LITERAL_SIMPLE_TYPE_SERIALIZER_NAME + "(" + stringBuffer + ",");
        indentingWriter.pln("\"\", " + this.encoder + ".getInstance());");
        indentingWriter.pO();
    }

    public void declareSerializer(IndentingWriter indentingWriter, boolean bl, boolean bl2) throws IOException {
        String string = this.getPrivateModifier(bl, bl2);
        indentingWriter.pln(string + this.serializerName() + " " + this.serializerMemberName + ";");
    }

    public String serializerMemberName() {
        return this.serializerMemberName;
    }

    public String deserializerMemberName() {
        return this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean bl, boolean bl2) {
        return "private " + super.getModifier(bl, bl2);
    }

    public static String getTypeEncoder(AbstractType abstractType) {
        QName qName = abstractType.getName();
        String string = (String)encoderMap.get(qName);
        if (string == null) {
            String string2 = abstractType.getJavaType().getName();
            if (qName.equals(BuiltInTypes.DATE_TIME) || qName.equals(SOAPConstants.QNAME_TYPE_DATE_TIME)) {
                if (string2.equals(ModelerConstants.DATE_CLASSNAME)) {
                    string = GeneratorConstants.XSD_DATE_TIME_DATE_ENCODER_NAME;
                } else if (string2.equals(ModelerConstants.CALENDAR_CLASSNAME)) {
                    string = GeneratorConstants.XSD_DATE_TIME_CALENDAR_ENCODER_NAME;
                }
            } else if (qName.equals(BuiltInTypes.BASE64_BINARY) || qName.equals(SOAPConstants.QNAME_TYPE_BASE64_BINARY) || qName.equals(SOAPConstants.QNAME_TYPE_BASE64)) {
                if (string2.equals(ModelerConstants.BYTE_ARRAY_CLASSNAME)) {
                    string = GeneratorConstants.XSD_BASE64_BINARY_ENCODER_NAME;
                }
            } else if (qName.equals(BuiltInTypes.HEX_BINARY) || qName.equals(SOAPConstants.QNAME_TYPE_HEX_BINARY)) {
                if (string2.equals(ModelerConstants.BYTE_ARRAY_CLASSNAME)) {
                    string = GeneratorConstants.XSD_HEX_BINARY_ENCODER_NAME;
                }
            } else if (string2.equals(ModelerConstants.STRING_CLASSNAME)) {
                string = GeneratorConstants.XSD_STRING_ENCODER_NAME;
            }
        }
        return string;
    }

    protected String getEncoder() {
        return LiteralSimpleSerializerWriter.getTypeEncoder(this.type);
    }

    static {
        encoderMap = new HashMap();
        encoderMap.put(BuiltInTypes.BOOLEAN, GeneratorConstants.XSD_BOOLEAN_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.BYTE, GeneratorConstants.XSD_BYTE_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.BASE64_BINARY, null);
        encoderMap.put(BuiltInTypes.HEX_BINARY, null);
        encoderMap.put(BuiltInTypes.DOUBLE, GeneratorConstants.XSD_DOUBLE_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.FLOAT, GeneratorConstants.XSD_FLOAT_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.INT, GeneratorConstants.XSD_INT_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.INTEGER, GeneratorConstants.XSD_INTEGER_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.LONG, GeneratorConstants.XSD_LONG_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.SHORT, GeneratorConstants.XSD_SHORT_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.DECIMAL, GeneratorConstants.XSD_DECIMAL_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.DATE_TIME, null);
        encoderMap.put(BuiltInTypes.STRING, GeneratorConstants.XSD_STRING_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.QNAME, GeneratorConstants.XSD_QNAME_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_BOOLEAN, GeneratorConstants.XSD_BOOLEAN_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_BYTE, GeneratorConstants.XSD_BYTE_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_BASE64_BINARY, null);
        encoderMap.put(SOAPConstants.QNAME_TYPE_DOUBLE, GeneratorConstants.XSD_DOUBLE_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_FLOAT, GeneratorConstants.XSD_FLOAT_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_INT, GeneratorConstants.XSD_INT_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_LONG, GeneratorConstants.XSD_LONG_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_SHORT, GeneratorConstants.XSD_SHORT_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_DECIMAL, GeneratorConstants.XSD_DECIMAL_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_DATE_TIME, null);
        encoderMap.put(SOAPConstants.QNAME_TYPE_STRING, GeneratorConstants.XSD_STRING_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_QNAME, GeneratorConstants.XSD_QNAME_ENCODER_NAME);
    }
}

