/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.DirectoryUtil;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.streaming.PrefixFactory;
import com.sun.xml.rpc.streaming.PrefixFactoryImpl;
import com.sun.xml.rpc.util.ClassNameInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class Names
implements GeneratorConstants {
    private String serializerNameInfix = null;
    private PrefixFactory prefixFactory = new PrefixFactoryImpl("ns");
    private static Map reservedWords = new HashMap();
    private static Map holderClassNames;

    public String stubFor(JavaInterface javaInterface) {
        String string = ClassNameInfo.replaceInnerClassSym(javaInterface.getRealName());
        return string + "_Stub";
    }

    public String skeletonFor(JavaInterface javaInterface) {
        String string = ClassNameInfo.replaceInnerClassSym(javaInterface.getRealName());
        return string + "_Skeleton";
    }

    public String tieFor(JavaInterface javaInterface) {
        String string = ClassNameInfo.replaceInnerClassSym(javaInterface.getRealName());
        return string + "_Tie";
    }

    public String getPortName(Port port) {
        QName qName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
        if (qName != null) {
            return qName.getLocalPart();
        }
        String string = Names.stripQualifier(port.getJavaInterface().getRealName());
        return ClassNameInfo.replaceInnerClassSym(string);
    }

    public static String stripQualifier(Class clazz) {
        String string = clazz.getName();
        return Names.stripQualifier(string);
    }

    public static String stripQualifier(String string) {
        return ClassNameInfo.getName(string);
    }

    public String getPackageName(String string) {
        String string2 = ClassNameInfo.getQualifier(string);
        return string2 != null ? string2 : "";
    }

    public static String getUnqualifiedClassName(String string) {
        return ClassNameInfo.getName(string).replace('$', '.');
    }

    public File sourceFileForClass(String string, String string2, File file, ProcessorEnvironment processorEnvironment) throws GeneratorException {
        File file2 = DirectoryUtil.getOutputDirectoryFor(string, file, processorEnvironment);
        String string3 = Names.stripQualifier(string2);
        String string4 = string3 + ".java";
        return new File(file2, string4);
    }

    public String typeClassName(SOAPType sOAPType) {
        return this.typeClassName(sOAPType.getJavaType());
    }

    public String typeClassName(JavaType javaType) {
        String string = javaType.getName();
        return string;
    }

    public String typeObjectSerializerClassName(SOAPType sOAPType) {
        return this.typeObjectSerializerClassName(sOAPType.getJavaType(), "_SOAPSerializer");
    }

    public String typeObjectArraySerializerClassName(SOAPType sOAPType) {
        return this.typeObjectArraySerializerClassName(sOAPType.getJavaType(), "Array_SOAPSerializer");
    }

    public String typeObjectSerializerClassName(LiteralType literalType) {
        return this.typeObjectSerializerClassName(literalType.getJavaType(), "_LiteralSerializer");
    }

    public String typeObjectArraySerializerClassName(LiteralType literalType) {
        return this.typeObjectArraySerializerClassName(literalType.getJavaType(), "Array_LiteralSerializer");
    }

    public String typeObjectSerializerClassName(JavaType javaType, String string) {
        String string2 = javaType.getRealName();
        return this.serializerClassName(string2, string);
    }

    public String typeInterfaceSerializerClassName(SOAPType sOAPType) {
        return this.typeInterfaceSerializerClassName(sOAPType.getJavaType(), "_InterfaceSOAPSerializer");
    }

    public String typeInterfaceSerializerClassName(JavaType javaType, String string) {
        String string2 = javaType.getRealName();
        return this.serializerClassName(string2, string);
    }

    private String serializerClassName(String string, String string2) {
        if (this.serializerNameInfix != null) {
            string = string + this.serializerNameInfix;
        }
        return (string + string2).replace('$', '_');
    }

    public String typeObjectArraySerializerClassName(JavaType javaType, String string) {
        String string2 = javaType.getRealName();
        int n = string2.indexOf("[]");
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        return this.serializerClassName(string2, string);
    }

    public String typeObjectBuilderClassName(SOAPType sOAPType) {
        return this.typeObjectBuilderClassName(sOAPType.getJavaType());
    }

    public String typeObjectBuilderClassName(JavaType javaType) {
        return this.builderClassName(javaType.getRealName(), "_SOAPBuilder");
    }

    private String builderClassName(String string, String string2) {
        if (this.serializerNameInfix != null) {
            string = string + this.serializerNameInfix;
        }
        return (string + string2).replace('$', '_');
    }

    public String faultBuilderClassName(Port port, Operation operation) {
        String string = port.getJavaInterface().getName() + "_" + operation.getUniqueName();
        return this.builderClassName(string, "_Fault_SOAPBuilder");
    }

    public String faultSerializerClassName(Port port, Operation operation) {
        String string = port.getJavaInterface().getName() + "_" + operation.getUniqueName();
        return this.serializerClassName(string, "_Fault_SOAPSerializer");
    }

    public String customJavaTypeClassName(JavaInterface javaInterface) {
        String string = javaInterface.getName();
        return string;
    }

    public String customJavaTypeClassName(AbstractType abstractType) {
        String string = abstractType.getJavaType().getName();
        return string;
    }

    private String customJavaTypeClassName(String string) {
        return string;
    }

    public String customExceptionClassName(Fault fault) {
        String string = fault.getJavaException().getName();
        return string;
    }

    public String interfaceImplClassName(JavaInterface javaInterface) {
        String string = javaInterface.getName() + "_Impl";
        return string;
    }

    public String serializerRegistryClassName(JavaInterface javaInterface) {
        String string = javaInterface.getName() + "_SerializerRegistry";
        return string;
    }

    public String holderClassName(Port port, AbstractType abstractType) {
        return this.holderClassName(port, abstractType.getJavaType());
    }

    public String holderClassName(Port port, JavaType javaType) {
        if (javaType.getHolderName() != null) {
            return javaType.getHolderName();
        }
        return this.holderClassName(port, javaType.getName());
    }

    private String holderClassName(Port port, String string) {
        String string2 = (String)holderClassNames.get(string);
        if (string2 == null) {
            String string3 = port.getJavaInterface().getName();
            String string4 = this.getPackageName(string3);
            string4 = string4.length() > 0 ? string4 + ".holders." : "holders.";
            if (!this.isInJavaOrJavaxPackage(string)) {
                string = Names.stripQualifier(string);
            }
            int n = string.indexOf("[]");
            while (n > 0) {
                string = string.substring(0, n) + "Array" + string.substring(n + 2);
                n = string.indexOf("[]");
            }
            string2 = string4 + string + "Holder";
        }
        return string2;
    }

    private boolean isInJavaOrJavaxPackage(String string) {
        return string.startsWith("java.") || string.startsWith("javax.");
    }

    public String memberName(String string) {
        return ("my" + string).replace('.', '$');
    }

    public String getClassMemberName(String string) {
        string = Names.getUnqualifiedClassName(string);
        return this.memberName(string);
    }

    public String getClassMemberName(String string, AbstractType abstractType, String string2) {
        string = Names.getUnqualifiedClassName(string);
        String string3 = abstractType.getJavaType().getName().replace('.', '_');
        int n = string3.indexOf(91);
        if (n > 0) {
            string3 = string3.substring(0, n);
        }
        return this.memberName(this.getPrefix(abstractType.getName()) + "_" + this.validJavaName(abstractType.getName().getLocalPart()) + "__" + string3 + "_" + string + string2);
    }

    public String getClassMemberName(String string, AbstractType abstractType) {
        string = Names.getUnqualifiedClassName(string);
        return this.getClassMemberName(this.getPrefix(abstractType.getName()) + "_" + this.validJavaName(abstractType.getName().getLocalPart()) + "__" + string);
    }

    public String getTypeMemberName(AbstractType abstractType) {
        return this.getTypeMemberName(abstractType.getJavaType());
    }

    public String getTypeMemberName(JavaType javaType) {
        String string = javaType.getRealName();
        return this.getTypeMemberName(string);
    }

    public String getTypeMemberName(String string) {
        if ((string = Names.getUnqualifiedClassName(string)).endsWith("[]")) {
            string = string.substring(0, string.length() - 2) + "Array";
        }
        return this.memberName(string);
    }

    public String getCustomTypeSerializerMemberName(SOAPCustomType sOAPCustomType) {
        return this.getTypeQName(sOAPCustomType.getName()) + "_Serializer";
    }

    public String getCustomTypeDeserializerMemberName(SOAPCustomType sOAPCustomType) {
        return this.getTypeQName(sOAPCustomType.getName()) + "_Deserializer";
    }

    public String getLiteralFragmentTypeSerializerMemberName(LiteralFragmentType literalFragmentType) {
        return this.getTypeQName(literalFragmentType.getName()) + "_Serializer";
    }

    public String getOPCodeName(String string) {
        String string2 = string + "_OPCODE";
        string2 = string2.replace('-', '_');
        return string2.replace('.', '_');
    }

    public String getQNameName(QName qName) {
        String string = this.getPrefix(qName) + "_" + qName.getLocalPart() + "_QNAME";
        string = string.replace('-', '_');
        return string.replace('.', '_');
    }

    public String getBlockQNameName(Operation operation, Block block) {
        QName qName = block.getName();
        String string = this.getPrefix(qName);
        if (operation != null) {
            string = string + "_" + operation.getUniqueName();
        }
        string = string + "_" + qName.getLocalPart() + "_QNAME";
        string = string.replace('-', '_');
        return string.replace('.', '_');
    }

    public String getBlockUniqueName(Operation operation, Block block) {
        QName qName = block.getName();
        String string = this.getPrefix(qName);
        if (operation != null) {
            string = string + "_" + operation.getUniqueName();
        }
        string = string + "_" + qName.getLocalPart();
        string = string.replace('-', '_');
        return string.replace('.', '_');
    }

    public String getTypeQName(QName qName) {
        String string = this.getPrefix(qName) + "_" + qName.getLocalPart() + "_TYPE_QNAME";
        string = string.replace('-', '_');
        return string.replace('.', '_');
    }

    public String validJavaClassName(String string) {
        return StringUtils.capitalize(this.validJavaName(string));
    }

    public String validJavaMemberName(String string) {
        return StringUtils.decapitalize(this.validJavaName(string));
    }

    public String validJavaPackageName(String string) {
        return StringUtils.decapitalize(this.validJavaName(string));
    }

    public String validJavaName(String string) {
        string = this.wordBreakString(string);
        String string2 = (String)reservedWords.get(string = this.removeWhiteSpace(string));
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    public boolean isJavaReservedWord(String string) {
        return reservedWords.get(string) != null;
    }

    public String getJavaMemberReadMethod(JavaStructureMember javaStructureMember) {
        String string = null;
        string = javaStructureMember.getType().getRealName() == "boolean" ? "is" + StringUtils.capitalize(javaStructureMember.getName()) : "get" + StringUtils.capitalize(javaStructureMember.getName());
        return string;
    }

    public String getJavaMemberWriteMethod(JavaStructureMember javaStructureMember) {
        return "set" + StringUtils.capitalize(javaStructureMember.getName());
    }

    public String getResponseName(String string) {
        return string + "Response";
    }

    public String removeWhiteSpace(String string) {
        String string2 = this.removeCharacter(32, string);
        return string2;
    }

    public String wordBreakString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (Character.isDigit(c)) {
                if (n + 1 < stringBuffer.length() && !Character.isDigit(stringBuffer.charAt(n + 1))) {
                    stringBuffer.insert(1 + n++, ' ');
                }
            } else if (!Character.isSpaceChar(c) && c != '_') {
                if (!Character.isJavaIdentifierPart(c)) {
                    stringBuffer.setCharAt(n, ' ');
                } else if (!Character.isLetter(c)) {
                    stringBuffer.setCharAt(n, ' ');
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String removeCharacter(int n, String string) {
        int n2 = string.indexOf(n);
        while (n2 >= 0) {
            string = string.substring(0, n2) + StringUtils.capitalize(string.substring(n2 + 1).trim());
            n2 = string.indexOf(32);
        }
        return string;
    }

    public String getPrefix(QName qName) {
        return this.getPrefix(qName.getNamespaceURI());
    }

    public String getPrefix(String string) {
        return this.prefixFactory.getPrefix(string);
    }

    public void resetPrefixFactory() {
        this.prefixFactory = new PrefixFactoryImpl("ns");
    }

    public void setSerializerNameInfix(String string) {
        if (string != null && string.length() > 0) {
            this.serializerNameInfix = "_" + string;
        }
    }

    static {
        reservedWords.put("abstract", "_abstract");
        reservedWords.put("boolean", "_boolean");
        reservedWords.put("break", "_break");
        reservedWords.put("byte", "_byte");
        reservedWords.put("case", "_case");
        reservedWords.put("catch", "_catch");
        reservedWords.put("char", "_char");
        reservedWords.put("class", "_class");
        reservedWords.put("const", "_const");
        reservedWords.put("continue", "_continue");
        reservedWords.put("default", "_default");
        reservedWords.put("do", "_do");
        reservedWords.put("double", "_double");
        reservedWords.put("else", "_else");
        reservedWords.put("extends", "_extends");
        reservedWords.put("false", "_false");
        reservedWords.put("final", "_final");
        reservedWords.put("finally", "_finally");
        reservedWords.put("float", "_float");
        reservedWords.put("for", "_for");
        reservedWords.put("goto", "_goto");
        reservedWords.put("if", "_if");
        reservedWords.put("implements", "_implements");
        reservedWords.put("import", "_import");
        reservedWords.put("instanceof", "_instanceof");
        reservedWords.put("int", "_int");
        reservedWords.put("interface", "_interface");
        reservedWords.put("long", "_long");
        reservedWords.put("native", "_native");
        reservedWords.put("new", "_new");
        reservedWords.put("null", "_null");
        reservedWords.put("package", "_package");
        reservedWords.put("private", "_private");
        reservedWords.put("protected", "_protected");
        reservedWords.put("public", "_public");
        reservedWords.put("return", "_return");
        reservedWords.put("short", "_short");
        reservedWords.put("static", "_static");
        reservedWords.put("strictfp", "_strictfp");
        reservedWords.put("super", "_super");
        reservedWords.put("switch", "_switch");
        reservedWords.put("synchronized", "_synchronized");
        reservedWords.put("this", "_this");
        reservedWords.put("throw", "_throw");
        reservedWords.put("throws", "_throws");
        reservedWords.put("transient", "_transient");
        reservedWords.put("true", "_true");
        reservedWords.put("try", "_try");
        reservedWords.put("void", "_void");
        reservedWords.put("volatile", "_volatile");
        reservedWords.put("while", "_while");
        holderClassNames = new HashMap();
        holderClassNames.put("int", "javax.xml.rpc.holders.IntHolder");
        holderClassNames.put("long", "javax.xml.rpc.holders.LongHolder");
        holderClassNames.put("short", "javax.xml.rpc.holders.ShortHolder");
        holderClassNames.put("float", "javax.xml.rpc.holders.FloatHolder");
        holderClassNames.put("double", "javax.xml.rpc.holders.DoubleHolder");
        holderClassNames.put("boolean", "javax.xml.rpc.holders.BooleanHolder");
        holderClassNames.put("byte", "javax.xml.rpc.holders.ByteHolder");
        holderClassNames.put("java.lang.Integer", "javax.xml.rpc.holders.IntegerWrapperHolder");
        holderClassNames.put("java.lang.Long", "javax.xml.rpc.holders.LongWrapperHolder");
        holderClassNames.put("java.lang.Short", "javax.xml.rpc.holders.ShortWrapperHolder");
        holderClassNames.put("java.lang.Float", "javax.xml.rpc.holders.FloatWrapperHolder");
        holderClassNames.put("java.lang.Double", "javax.xml.rpc.holders.DoubleWrapperHolder");
        holderClassNames.put("java.lang.Boolean", "javax.xml.rpc.holders.BooleanWrapperHolder");
        holderClassNames.put("java.lang.Byte", "javax.xml.rpc.holders.ByteWrapperHolder");
        holderClassNames.put("java.lang.String", "javax.xml.rpc.holders.StringHolder");
        holderClassNames.put("java.math.BigDecimal", "javax.xml.rpc.holders.BigDecimalHolder");
        holderClassNames.put("java.math.BigInteger", "javax.xml.rpc.holders.BigIntegerHolder");
        holderClassNames.put("java.util.Calendar", "javax.xml.rpc.holders.CalendarHolder");
        holderClassNames.put("javax.xml.namespace.QName", "javax.xml.rpc.holders.QNameHolder");
        holderClassNames.put("java.lang.Object", "javax.xml.rpc.holders.ObjectHolder");
        holderClassNames.put("byte[]", "javax.xml.rpc.holders.ByteArrayHolder");
    }
}

