/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SOAPEncoding;
import com.sun.xml.rpc.processor.generator.writer.SOAPObjectSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class InterfaceSerializerGenerator
extends GeneratorBase {
    private Set visitedTypes;
    private static final String OBJECT_SERIALIZER_BASE = "ObjectSerializerBase";
    private static final String INTERFACE_SERIALIZER_BASE = "InterfaceSerializerBase";

    public InterfaceSerializerGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new InterfaceSerializerGenerator(model, configuration, properties);
    }

    private InterfaceSerializerGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.visitedTypes = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        Iterator iterator = model.getExtraTypes();
        while (iterator.hasNext()) {
            AbstractType abstractType = (AbstractType)iterator.next();
            if (!abstractType.isSOAPType()) continue;
            ((SOAPType)abstractType).accept(this);
        }
        this.visitedTypes = null;
    }

    protected void preVisitFault(Fault fault) throws Exception {
        if (fault.getBlock().getType().isSOAPType()) {
            ((SOAPType)fault.getBlock().getType()).accept(this);
        }
    }

    protected void preVisitSOAPSimpleType(SOAPSimpleType sOAPSimpleType) throws Exception {
        if (this.haveVisited(sOAPSimpleType)) {
            return;
        }
        this.typeVisited(sOAPSimpleType);
    }

    protected void preVisitSOAPAnyType(SOAPAnyType sOAPAnyType) throws Exception {
        if (this.haveVisited(sOAPAnyType)) {
            return;
        }
        this.typeVisited(sOAPAnyType);
    }

    protected void preVisitSOAPEnumerationType(SOAPEnumerationType sOAPEnumerationType) throws Exception {
        if (this.haveVisited(sOAPEnumerationType)) {
            return;
        }
        this.typeVisited(sOAPEnumerationType);
    }

    protected void preVisitSOAPArrayType(SOAPArrayType sOAPArrayType) throws Exception {
        if (this.haveVisited(sOAPArrayType)) {
            return;
        }
        this.typeVisited(sOAPArrayType);
    }

    public void preVisitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
        if (this.haveVisited(sOAPStructureType)) {
            return;
        }
        this.typeVisited(sOAPStructureType);
        try {
            this.writeObjectSerializerForType(sOAPStructureType);
        }
        catch (IOException iOException) {
            GeneratorBase.fail("generator.cant.write", sOAPStructureType.getName().getLocalPart());
        }
    }

    private boolean haveVisited(SOAPType sOAPType) {
        return this.visitedTypes.contains(sOAPType);
    }

    private void typeVisited(SOAPType sOAPType) {
        this.visitedTypes.add(sOAPType);
    }

    private void writeObjectSerializerForType(SOAPStructureType sOAPStructureType) throws IOException {
        boolean bl;
        boolean bl2 = bl = ((JavaStructureType)sOAPStructureType.getJavaType()).getAllSubclasses() != null;
        if (!bl) {
            return;
        }
        JavaType javaType = sOAPStructureType.getJavaType();
        String string = this.env.getNames().typeInterfaceSerializerClassName(sOAPStructureType);
        File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
        try {
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            this.writeObjectSerializerCode(indentingWriter, sOAPStructureType);
            indentingWriter.close();
            this.log("wrote file: " + file.getPath());
        }
        catch (IOException iOException) {
            GeneratorBase.fail("generator.cant.write", file.toString());
        }
    }

    private void writeObjectSerializerCode(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        this.log("writing  serializer/deserializer for: " + sOAPStructureType.getName().getLocalPart());
        String string = this.env.getNames().typeInterfaceSerializerClassName(sOAPStructureType);
        GeneratorBase.writePackage(indentingWriter, string);
        this.writeImports(indentingWriter);
        indentingWriter.pln();
        this.writeClassDecl(indentingWriter, string);
        this.writeMembers(indentingWriter, sOAPStructureType);
        indentingWriter.pln();
        this.writeConstructor(indentingWriter, string);
        indentingWriter.pln();
        this.writeInitialize(indentingWriter, sOAPStructureType);
        indentingWriter.pln();
        this.writeDoDeserializeMethod(indentingWriter, sOAPStructureType);
        indentingWriter.pln();
        this.writeDoSerializeInstanceMethod(indentingWriter, sOAPStructureType);
        if (sOAPStructureType instanceof RPCResponseStructureType) {
            this.writeVerifyNameOverrideMethod(indentingWriter, sOAPStructureType);
        }
        indentingWriter.pOln("}");
    }

    private void writeImports(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("import com.sun.xml.rpc.encoding.*;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.literal.DetailFragmentDeserializer;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        indentingWriter.pln("import com.sun.xml.rpc.streaming.*;");
        indentingWriter.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        indentingWriter.pln("import javax.xml.namespace.QName;");
    }

    private void writeClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        String string2 = INTERFACE_SERIALIZER_BASE;
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" extends ").append(string2).append(" implements Initializable {").toString());
    }

    private void writeMembers(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        HashSet hashSet = new HashSet();
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        TreeSet treeSet = new TreeSet(new GeneratorUtil.SubclassComparator());
        treeSet.addAll(javaStructureType.getAllSubclassesSet());
        Iterator iterator = treeSet.iterator();
        while (iterator != null && iterator.hasNext()) {
            SOAPEncoding.writeStaticSerializer(indentingWriter, (SOAPType)((JavaStructureType)iterator.next()).getOwner(), hashSet, this.writerFactory, this.env.getNames());
        }
        SOAPObjectSerializerWriter sOAPObjectSerializerWriter = new SOAPObjectSerializerWriter(sOAPStructureType, this.env.getNames());
        indentingWriter.pln("private CombinedSerializer " + sOAPObjectSerializerWriter.serializerMemberName() + ";");
    }

    private void writeConstructor(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append("(QName type, boolean encodeType, ").append("boolean isNullable, String encodingStyle) {").toString());
        indentingWriter.pln("super(type, encodeType, isNullable, encodingStyle);");
        indentingWriter.pOln("}");
    }

    private void writeInitialize(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        SerializerWriter serializerWriter;
        indentingWriter.plnI("public void initialize(InternalTypeMappingRegistry registry) throws Exception {");
        HashSet hashSet = new HashSet();
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        TreeSet treeSet = new TreeSet(new GeneratorUtil.SubclassComparator());
        treeSet.addAll(javaStructureType.getAllSubclassesSet());
        Iterator iterator = treeSet.iterator();
        while (iterator != null && iterator.hasNext()) {
            SOAPType sOAPType = (SOAPType)((JavaStructureType)iterator.next()).getOwner();
            serializerWriter = this.writerFactory.createWriter(sOAPType);
            serializerWriter.initializeSerializer(indentingWriter, this.env.getNames().getTypeQName(sOAPType.getName()), "registry");
            indentingWriter.pln(serializerWriter.serializerMemberName() + " = " + serializerWriter.serializerMemberName() + ".getInnermostSerializer();");
        }
        serializerWriter = new SOAPObjectSerializerWriter(sOAPStructureType, this.env.getNames());
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("type");
        serializerWriter.createSerializer(indentingWriter, stringBuffer, "interfaceSerializer", this.encodeTypes, false, null);
        indentingWriter.pln(serializerWriter.serializerMemberName() + " = interfaceSerializer.getInnermostSerializer();");
        indentingWriter.plnI("if (" + serializerWriter.serializerMemberName() + " instanceof Initializable) {");
        indentingWriter.pln("((Initializable)" + serializerWriter.serializerMemberName() + ").initialize(registry);");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    private void writeDoDeserializeMethod(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        String string;
        SerializerWriter serializerWriter;
        indentingWriter.plnI("public Object doDeserialize(QName name, XMLReader reader,");
        indentingWriter.pln("SOAPDeserializationContext context) throws Exception {");
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        TreeSet treeSet = new TreeSet(new GeneratorUtil.SubclassComparator());
        treeSet.addAll(javaStructureType.getAllSubclassesSet());
        Iterator iterator = treeSet.iterator();
        indentingWriter.pln("QName elementType = getType(reader);");
        int n = 0;
        while (iterator != null && iterator.hasNext()) {
            JavaStructureType javaStructureType2 = (JavaStructureType)iterator.next();
            SOAPStructureType sOAPStructureType2 = (SOAPStructureType)javaStructureType2.getOwner();
            serializerWriter = this.writerFactory.createWriter(sOAPStructureType2);
            string = serializerWriter.deserializerMemberName();
            if (n > 0) {
                indentingWriter.p(" else ");
            }
            indentingWriter.plnI("if (elementType.equals(" + string + ".getXmlType())) {");
            indentingWriter.pln("return " + string + ".deserialize(name, reader, context);");
            indentingWriter.pO("}");
            ++n;
        }
        if (n > 0) {
            indentingWriter.p(" else ");
        }
        serializerWriter = new SOAPObjectSerializerWriter(sOAPStructureType, this.env.getNames());
        string = serializerWriter.deserializerMemberName();
        indentingWriter.plnI("if (elementType.equals(" + string + ".getXmlType())) {");
        indentingWriter.pln("return " + string + ".deserialize(name, reader, context);");
        indentingWriter.pO("}");
        indentingWriter.pln();
        indentingWriter.pln("throw new DeserializationException(\"soap.unexpectedElementType\", new Object[] {\"\", elementType.toString()});");
        indentingWriter.pOln("}");
    }

    private void writeDoSerializeInstanceMethod(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        String string;
        SerializerWriter serializerWriter;
        indentingWriter.plnI("public void doSerializeInstance(Object obj, QName name, SerializerCallback callback,");
        indentingWriter.pln("XMLWriter writer, SOAPSerializationContext context) throws Exception {");
        indentingWriter.pln(sOAPStructureType.getJavaType().getRealName() + " instance = (" + sOAPStructureType.getJavaType().getRealName() + ")obj;");
        indentingWriter.pln();
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        TreeSet treeSet = new TreeSet(new GeneratorUtil.SubclassComparator());
        treeSet.addAll(javaStructureType.getAllSubclassesSet());
        Iterator iterator = treeSet.iterator();
        Iterator iterator2 = javaStructureType.getMembers();
        if (iterator != null) {
            int n = 0;
            while (iterator.hasNext()) {
                JavaStructureType javaStructureType2 = (JavaStructureType)iterator.next();
                SOAPStructureType sOAPStructureType2 = (SOAPStructureType)javaStructureType2.getOwner();
                serializerWriter = this.writerFactory.createWriter(sOAPStructureType2);
                string = serializerWriter.deserializerMemberName();
                if (n > 0) {
                    indentingWriter.p(" else ");
                }
                indentingWriter.plnI("if (obj instanceof " + javaStructureType2.getRealName() + ") {");
                indentingWriter.pln(string + ".serialize(obj, name, callback, writer, context);");
                indentingWriter.pO("}");
                ++n;
            }
            indentingWriter.plnI(" else {");
        }
        serializerWriter = new SOAPObjectSerializerWriter(sOAPStructureType, this.env.getNames());
        string = serializerWriter.deserializerMemberName();
        indentingWriter.pln(string + ".serialize(obj, name, callback, writer, context);");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    private void writeVerifyNameOverrideMethod(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        indentingWriter.plnI("protected void verifyName(XMLReader reader, QName expectedName) throws Exception {");
        indentingWriter.pOln("}");
    }
}

