/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

public class FaultExceptionBuilderGenerator
extends GeneratorBase {
    private Set operations;
    private Port port;

    public FaultExceptionBuilderGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new FaultExceptionBuilderGenerator(model, configuration, properties);
    }

    private FaultExceptionBuilderGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    public void preVisitModel(Model model) {
        this.operations = new HashSet();
    }

    public void postVisitModel(Model model) {
        this.operations = null;
    }

    public void preVisitPort(Port port) {
        this.port = port;
    }

    public void postVistPort(Port port) {
        this.port = null;
    }

    public void preVisitOperation(Operation operation) throws Exception {
        if (!this.isRegistered(operation)) {
            this.registerFault(operation);
        }
    }

    private boolean isRegistered(Operation operation) {
        return this.operations.contains(this.getInputMessageName(operation));
    }

    private String getInputMessageName(Operation operation) {
        QName qName = (QName)operation.getRequest().getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
        if (qName != null) {
            return qName.getLocalPart();
        }
        return operation.getName().getLocalPart();
    }

    private void registerFault(Operation operation) throws Exception {
        this.operations.add(this.getInputMessageName(operation));
        this.generateBuilderForOperation(operation);
    }

    private void generateBuilderForOperation(Operation operation) throws IOException, GeneratorException {
        if (FaultExceptionBuilderGenerator.needsBuilder(operation)) {
            this.writeBuilderForOperation(operation);
        }
    }

    public static boolean needsBuilder(Operation operation) {
        Iterator iterator = operation.getAllFaults();
        return iterator != null ? iterator.hasNext() : false;
    }

    private void writeBuilderForOperation(Operation operation) throws IOException, GeneratorException {
        String string = this.env.getNames().faultBuilderClassName(this.port, operation);
        File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
        try {
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            this.writeObjectBuilderCode(indentingWriter, operation, string);
            indentingWriter.close();
            this.log("wrote file: " + file.getPath());
        }
        catch (IOException iOException) {
            GeneratorBase.fail("generator.cant.write", file.toString());
        }
    }

    private void writeObjectBuilderCode(IndentingWriter indentingWriter, Operation operation, String string) throws IOException, GeneratorException {
        this.log("writing object builder for: " + operation.getName());
        GeneratorBase.writePackage(indentingWriter, string);
        this.writeImports(indentingWriter);
        indentingWriter.pln();
        this.writeObjectClassDecl(indentingWriter, string);
        this.writeMembers(indentingWriter, operation);
        indentingWriter.pln();
        this.writeMemberGateTypeMethod(indentingWriter);
        indentingWriter.pln();
        this.writeConstructMethod(indentingWriter);
        indentingWriter.pln();
        this.writeSetMemberMethod(indentingWriter, operation);
        indentingWriter.pln();
        this.writeInitializeMethod(indentingWriter, operation);
        indentingWriter.pln();
        this.writeGetSetInstanceMethods(indentingWriter);
        indentingWriter.pOln("}");
    }

    private void writeImports(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("import com.sun.xml.rpc.encoding.*;");
        indentingWriter.pln("import com.sun.xml.rpc.soap.message.SOAPFaultInfo;");
        indentingWriter.pln("import java.lang.IllegalArgumentException;");
    }

    private void writeObjectClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public final class ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" implements SOAPInstanceBuilder {").toString());
    }

    private void writeMembers(IndentingWriter indentingWriter, Operation operation) throws IOException {
        indentingWriter.pln("private SOAPFaultInfo instance = null;");
        indentingWriter.pln("private Object detail;");
        indentingWriter.pln("// this is the index of the fault deserialized");
        indentingWriter.pln("private int index = -1;");
        Iterator iterator = operation.getAllFaults();
        int n = 0;
        while (iterator.hasNext()) {
            Fault fault = (Fault)iterator.next();
            indentingWriter.pln("private static final int " + fault.getJavaException().getRealName().toUpperCase().replace('.', '_') + "_INDEX = " + n + ";");
            ++n;
        }
    }

    private void writeMemberGateTypeMethod(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.plnI("public int memberGateType(int memberIndex) {");
        indentingWriter.pln("return GATES_INITIALIZATION + REQUIRES_COMPLETION;");
        indentingWriter.pOln("}");
    }

    private void writeConstructMethod(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.plnI("public void construct() {");
        indentingWriter.pOln("}");
    }

    private void writeSetMemberMethod(IndentingWriter indentingWriter, Operation operation) throws IOException {
        indentingWriter.plnI("public void setMember(int index, Object memberValue) {");
        indentingWriter.pln("this.index = index;");
        indentingWriter.pln("detail = memberValue;");
        indentingWriter.pOln("}");
    }

    private void writeInitializeMethod(IndentingWriter indentingWriter, Operation operation) throws IOException {
        indentingWriter.plnI("public void initialize() {");
        indentingWriter.plnI("switch (index) {");
        Iterator iterator = operation.getAllFaults();
        boolean bl = false;
        while (iterator.hasNext()) {
            Fault fault = (Fault)iterator.next();
            JavaException javaException = fault.getJavaException();
            SOAPType sOAPType = (SOAPType)fault.getBlock().getType();
            indentingWriter.plnI("case " + fault.getJavaException().getRealName().toUpperCase().replace('.', '_') + "_INDEX" + ":");
            if (javaException.getMembersCount() == 1) {
                Iterator iterator2 = fault.getJavaException().getMembers();
                JavaStructureMember javaStructureMember = (JavaStructureMember)iterator2.next();
                String string = "detail";
                String string2 = javaStructureMember.getType().getRealName();
                if (SimpleToBoxedUtil.isPrimitive(string2)) {
                    string = "(" + SimpleToBoxedUtil.getBoxedClassName(string2) + ")" + string;
                    string = SimpleToBoxedUtil.getUnboxedExpressionOfType(string, string2);
                } else {
                    string = "(" + javaStructureMember.getType().getRealName() + ")" + string;
                }
                indentingWriter.pln("instance.setDetail(new " + this.env.getNames().customExceptionClassName(fault) + "(" + string + "));");
            } else {
                indentingWriter.pln("instance.setDetail(detail);");
            }
            indentingWriter.pln("break;");
            indentingWriter.pO();
        }
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    private void writeGetSetInstanceMethods(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.plnI("public void setInstance(Object instance) {");
        indentingWriter.pln("this.instance = (SOAPFaultInfo)instance;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public Object getInstance() {");
        indentingWriter.pln("return instance;");
        indentingWriter.pOln("}");
    }
}

