/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationEntry;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class EnumerationGenerator
extends GeneratorBase {
    private Set types;

    public EnumerationGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new EnumerationGenerator(model, configuration, properties);
    }

    private EnumerationGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    public void visit(SOAPCustomType sOAPCustomType) throws Exception {
        if (this.isRegistered(sOAPCustomType)) {
            return;
        }
        this.registerType(sOAPCustomType);
    }

    public void visit(SOAPSimpleType sOAPSimpleType) throws Exception {
        if (this.isRegistered(sOAPSimpleType)) {
            return;
        }
        this.registerType(sOAPSimpleType);
    }

    public void visit(SOAPAnyType sOAPAnyType) throws Exception {
        if (this.isRegistered(sOAPAnyType)) {
            return;
        }
        this.registerType(sOAPAnyType);
    }

    public void visit(SOAPEnumerationType sOAPEnumerationType) throws Exception {
        if (this.isRegistered(sOAPEnumerationType)) {
            return;
        }
        this.registerType(sOAPEnumerationType);
        this.generateEnumeration(sOAPEnumerationType);
    }

    protected void visitSOAPArrayType(SOAPArrayType sOAPArrayType) throws Exception {
        if (this.isRegistered(sOAPArrayType)) {
            return;
        }
        this.registerType(sOAPArrayType);
        super.visitSOAPArrayType(sOAPArrayType);
    }

    protected void visitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
        if (this.isRegistered(sOAPStructureType)) {
            return;
        }
        this.registerType(sOAPStructureType);
        super.visitSOAPStructureType(sOAPStructureType);
    }

    private boolean isRegistered(SOAPType sOAPType) {
        return this.types.contains(sOAPType);
    }

    private void registerType(SOAPType sOAPType) {
        this.types.add(sOAPType);
    }

    private void generateEnumeration(SOAPEnumerationType sOAPEnumerationType) {
        this.log("generating Enumeration for: " + sOAPEnumerationType.getJavaType().getRealName());
        try {
            String string = sOAPEnumerationType.getJavaType().getRealName();
            File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            GeneratorBase.writePackage(indentingWriter, string);
            indentingWriter.pln();
            this.writeClassDecl(indentingWriter, string);
            this.writeMembers(indentingWriter, sOAPEnumerationType);
            indentingWriter.pln();
            this.writeClassConstructor(indentingWriter, string, sOAPEnumerationType);
            indentingWriter.pln();
            this.writeGetValue(indentingWriter, sOAPEnumerationType);
            indentingWriter.pln();
            this.writeFromValue(indentingWriter, sOAPEnumerationType);
            indentingWriter.pln();
            this.writeFromString(indentingWriter, sOAPEnumerationType);
            indentingWriter.pln();
            this.writeToString(indentingWriter, sOAPEnumerationType);
            indentingWriter.pln();
            this.writeEquals(indentingWriter, sOAPEnumerationType);
            indentingWriter.pln();
            this.writeHashCode(indentingWriter, sOAPEnumerationType);
            indentingWriter.pOln("}");
            indentingWriter.close();
            this.log("wrote file: " + file.getPath());
        }
        catch (Exception exception) {
            GeneratorBase.fail(exception);
        }
    }

    private void writeClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" implements java.io.Serializable {").toString());
    }

    private void writeMembers(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType) throws IOException {
        JavaEnumerationEntry javaEnumerationEntry;
        JavaEnumerationType javaEnumerationType = (JavaEnumerationType)sOAPEnumerationType.getJavaType();
        String string = javaEnumerationType.getBaseType().getRealName();
        this.env.getNames();
        String string2 = Names.stripQualifier(sOAPEnumerationType.getJavaType().getRealName());
        indentingWriter.pln("private " + string + " value;");
        Iterator iterator = javaEnumerationType.getEntries();
        if (!SimpleToBoxedUtil.isPrimitive(string)) {
            iterator = javaEnumerationType.getEntries();
            while (iterator.hasNext()) {
                javaEnumerationEntry = (JavaEnumerationEntry)iterator.next();
                indentingWriter.pln("public static final String _" + javaEnumerationEntry.getName() + "String = \"" + javaEnumerationEntry.getLiteralValue() + "\";");
            }
            indentingWriter.pln();
        }
        iterator = javaEnumerationType.getEntries();
        while (iterator.hasNext()) {
            javaEnumerationEntry = (JavaEnumerationEntry)iterator.next();
            if (SimpleToBoxedUtil.isPrimitive(string)) {
                if (string.equals("long")) {
                    indentingWriter.pln("public static final " + string + " _" + javaEnumerationEntry.getName() + " = " + javaEnumerationEntry.getLiteralValue() + "L;");
                    continue;
                }
                indentingWriter.pln("public static final " + string + " _" + javaEnumerationEntry.getName() + " = (" + string + ")" + javaEnumerationEntry.getLiteralValue() + ";");
                continue;
            }
            indentingWriter.pln("public static final " + string + " _" + javaEnumerationEntry.getName() + " = new " + string + "(_" + javaEnumerationEntry.getName() + "String);");
        }
        indentingWriter.pln();
        iterator = javaEnumerationType.getEntries();
        while (iterator.hasNext()) {
            javaEnumerationEntry = (JavaEnumerationEntry)iterator.next();
            indentingWriter.pln("public static final " + string2 + " " + javaEnumerationEntry.getName() + " = new " + string2 + "(_" + javaEnumerationEntry.getName() + ");");
        }
    }

    private void writeClassConstructor(IndentingWriter indentingWriter, String string, SOAPType sOAPType) throws IOException {
        JavaEnumerationType javaEnumerationType = (JavaEnumerationType)sOAPType.getJavaType();
        String string2 = javaEnumerationType.getBaseType().getRealName();
        StringBuffer stringBuffer = new StringBuffer().append("protected ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append("(").append(string2).append(" value) {").toString());
        indentingWriter.pln("this.value = value;");
        indentingWriter.pOln("}");
    }

    private void writeGetValue(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType) throws IOException {
        JavaEnumerationType javaEnumerationType = (JavaEnumerationType)sOAPEnumerationType.getJavaType();
        String string = javaEnumerationType.getBaseType().getRealName();
        indentingWriter.plnI("public " + string + " getValue() {");
        indentingWriter.pln("return value;");
        indentingWriter.pOln("}");
    }

    private void writeFromValue(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType) throws IOException {
        JavaEnumerationType javaEnumerationType = (JavaEnumerationType)sOAPEnumerationType.getJavaType();
        String string = javaEnumerationType.getBaseType().getRealName();
        this.env.getNames();
        String string2 = Names.stripQualifier(sOAPEnumerationType.getJavaType().getRealName());
        indentingWriter.plnI("public static " + string2 + " fromValue(" + string + " value)");
        indentingWriter.pln("throws java.lang.IllegalStateException {");
        Iterator iterator = javaEnumerationType.getEntries();
        int n = 0;
        while (iterator.hasNext()) {
            JavaEnumerationEntry javaEnumerationEntry = (JavaEnumerationEntry)iterator.next();
            if (n > 0) {
                indentingWriter.p(" else ");
            }
            if (SimpleToBoxedUtil.isPrimitive(string)) {
                indentingWriter.plnI("if (" + javaEnumerationEntry.getName() + ".value == value) {");
            } else {
                indentingWriter.plnI("if (" + javaEnumerationEntry.getName() + ".value.equals(value)) {");
            }
            indentingWriter.pln("return " + javaEnumerationEntry.getName() + ";");
            indentingWriter.pO("}");
            ++n;
        }
        indentingWriter.pln();
        indentingWriter.pln("throw new IllegalArgumentException();");
        indentingWriter.pOln("}");
    }

    private void writeFromString(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType) throws IOException {
        JavaEnumerationType javaEnumerationType = (JavaEnumerationType)sOAPEnumerationType.getJavaType();
        String string = javaEnumerationType.getBaseType().getRealName();
        this.env.getNames();
        String string2 = Names.stripQualifier(sOAPEnumerationType.getJavaType().getRealName());
        indentingWriter.plnI("public static " + string2 + " fromString(String value)");
        indentingWriter.pln("throws java.lang.IllegalStateException {");
        Iterator iterator = javaEnumerationType.getEntries();
        int n = 0;
        while (iterator.hasNext()) {
            JavaEnumerationEntry javaEnumerationEntry = (JavaEnumerationEntry)iterator.next();
            if (n > 0) {
                indentingWriter.p(" else ");
            }
            if (SimpleToBoxedUtil.isPrimitive(string)) {
                indentingWriter.plnI("if (value.equals(\"" + javaEnumerationEntry.getLiteralValue() + "\")) {");
            } else {
                indentingWriter.plnI("if (value.equals(_" + javaEnumerationEntry.getName() + "String)) {");
            }
            indentingWriter.pln("return " + javaEnumerationEntry.getName() + ";");
            indentingWriter.pO("}");
            ++n;
        }
        indentingWriter.pln();
        indentingWriter.pln("throw new IllegalArgumentException();");
        indentingWriter.pOln("}");
    }

    private void writeToString(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType) throws IOException {
        JavaEnumerationType javaEnumerationType = (JavaEnumerationType)sOAPEnumerationType.getJavaType();
        String string = javaEnumerationType.getBaseType().getRealName();
        this.env.getNames();
        String string2 = Names.stripQualifier(sOAPEnumerationType.getJavaType().getRealName());
        indentingWriter.plnI("public String toString() {");
        String string3 = "value";
        if (SimpleToBoxedUtil.isPrimitive(string)) {
            string3 = SimpleToBoxedUtil.getBoxedExpressionOfType(string3, string);
        }
        indentingWriter.pln("return " + string3 + ".toString();");
        indentingWriter.pOln("}");
    }

    private void writeEquals(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType) throws IOException {
        JavaEnumerationType javaEnumerationType = (JavaEnumerationType)sOAPEnumerationType.getJavaType();
        String string = javaEnumerationType.getBaseType().getRealName();
        this.env.getNames();
        String string2 = Names.stripQualifier(sOAPEnumerationType.getJavaType().getRealName());
        indentingWriter.plnI("public boolean equals(Object obj) {");
        indentingWriter.plnI("if (!(obj instanceof " + string2 + ")) {");
        indentingWriter.pln("return false;");
        indentingWriter.pOln("}");
        if (SimpleToBoxedUtil.isPrimitive(string)) {
            indentingWriter.pln("return ((" + string2 + ")obj).value == value;");
        } else {
            indentingWriter.pln("return ((" + string2 + ")obj).value.equals(value);");
        }
        indentingWriter.pOln("}");
    }

    private void writeHashCode(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType) throws IOException {
        JavaEnumerationType javaEnumerationType = (JavaEnumerationType)sOAPEnumerationType.getJavaType();
        String string = javaEnumerationType.getBaseType().getRealName();
        indentingWriter.plnI("public int hashCode() {");
        if (SimpleToBoxedUtil.isPrimitive(string)) {
            String string2 = SimpleToBoxedUtil.getBoxedExpressionOfType("value", string);
            indentingWriter.pln("return " + string2 + ".toString().hashCode();");
        } else {
            indentingWriter.pln("return value.hashCode();");
        }
        indentingWriter.pOln("}");
    }
}

