/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.ProcessorException;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.ModelInfo;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class Processor {
    private Properties _options;
    private Configuration _configuration;
    private List _actions;
    private Model _model;
    private boolean _printStackTrace;

    public Processor(Configuration configuration, Properties properties) {
        this._configuration = configuration;
        this._options = properties;
        this._actions = new ArrayList();
        this._printStackTrace = Boolean.valueOf(this._options.getProperty("printStackTrace"));
    }

    public void add(ProcessorAction processorAction) {
        this._actions.add(processorAction);
    }

    public Model getModel() {
        return this._model;
    }

    public void run() {
        this.runModeler();
        if (this._model != null) {
            this.runActions();
        }
    }

    public void runModeler() {
        try {
            ModelInfo modelInfo = this._configuration.getModelInfo();
            if (modelInfo == null) {
                throw new ProcessorException("processor.missing.model");
            }
            this._model = modelInfo.buildModel(this._options);
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            if (this._printStackTrace) {
                this._configuration.getEnvironment().printStackTrace((Throwable)((Object)jAXRPCExceptionBase));
            }
            this._configuration.getEnvironment().error(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            if (this._printStackTrace) {
                this._configuration.getEnvironment().printStackTrace(exception);
            }
            this._configuration.getEnvironment().error(new LocalizableExceptionAdapter(exception));
        }
    }

    public void runActions() {
        try {
            if (this._model == null) {
                return;
            }
            Iterator iterator = this._actions.iterator();
            while (iterator.hasNext()) {
                ProcessorAction processorAction = (ProcessorAction)iterator.next();
                processorAction.perform(this._model, this._configuration, this._options);
            }
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            if (this._printStackTrace) {
                this._configuration.getEnvironment().printStackTrace((Throwable)((Object)jAXRPCExceptionBase));
            }
            this._configuration.getEnvironment().error(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            if (this._printStackTrace) {
                this._configuration.getEnvironment().printStackTrace(exception);
            }
            this._configuration.getEnvironment().error(new LocalizableExceptionAdapter(exception));
        }
    }
}

