/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.simpletype.EncoderUtils;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class XSDDateTimeDateEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDDateTimeDateEncoder();
    protected static final SimpleDateFormat timeZoneFormatter = new SimpleDateFormat("HH:mm");
    protected static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    protected static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    protected XSDDateTimeDateEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String objectToString(Object object, XMLWriter xMLWriter) throws Exception {
        if (object == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = dateFormatter;
        synchronized (simpleDateFormat) {
            return dateFormatter.format((Date)object);
        }
    }

    public Object stringToObject(String string, XMLReader xMLReader) throws Exception {
        if (string == null) {
            return null;
        }
        return XSDDateTimeDateEncoder.decodeDateUtil(string, null);
    }

    public static void validateDateStr(String string) throws Exception {
        if (string.length() < 19) {
            throw new DeserializationException("xsd.invalid.date", string);
        }
    }

    protected static String getDateFormatPattern(String string) {
        String string2 = "yyyy";
        int n = string.indexOf(45, 4);
        int n2 = 4;
        while (n2 < n) {
            string2 = string2 + "y";
            ++n2;
        }
        string2 = string2 + "-MM-dd'T'HH:mm:ss";
        int n3 = n = string.indexOf(46);
        while (n3 < string.length() - 1 && n3 < n + 3) {
            if (!Character.isDigit(string.charAt(n3 + 1))) break;
            if (n3 == n) {
                string2 = string2 + ".";
            }
            string2 = string2 + "S";
            ++n3;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Date decodeDateUtil(String string, StringBuffer stringBuffer) throws Exception {
        if (string == null) {
            return null;
        }
        string = EncoderUtils.collapseWhitespace(string);
        XSDDateTimeDateEncoder.validateDateStr(string);
        StringBuffer stringBuffer2 = new StringBuffer(30);
        int n = XSDDateTimeDateEncoder.getDateFormatPattern(string, stringBuffer2);
        String string2 = stringBuffer2.toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        simpleDateFormat.setTimeZone(gmtTimeZone);
        String string3 = string.substring(0, n);
        Date date = simpleDateFormat.parse(string.substring(0, n));
        if (n < string.length()) {
            int n2 = n;
            if (Character.isDigit(string.charAt(n2))) {
                int n3 = n2;
                while (n3 < string.length() && Character.isDigit(string.charAt(n3))) {
                    ++n3;
                }
                String string4 = string.substring(n2, n2 + 1);
                int n4 = Integer.parseInt(string.substring(n2, n2 + 1));
                if (n4 >= 5) {
                    date.setTime(date.getTime() + 1L);
                }
                n2 = n3;
            }
            if (n2 < string.length() && string.charAt(n2) != 'Z') {
                if (stringBuffer != null) {
                    stringBuffer.append(string.substring(n2));
                }
                SimpleDateFormat simpleDateFormat2 = timeZoneFormatter;
                synchronized (simpleDateFormat2) {
                    string3 = string.substring(n2 + 1);
                    Date date2 = timeZoneFormatter.parse(string.substring(n2 + 1));
                    long l = string.charAt(n2) == '+' ? -date2.getTime() : date2.getTime();
                    date.setTime(date.getTime() + l);
                }
            }
        }
        return date;
    }

    protected static int getDateFormatPattern(String string, StringBuffer stringBuffer) {
        String string2 = "yyyy";
        stringBuffer.append(string2);
        int n = string.indexOf(45, 4);
        int n2 = 4;
        while (n2 < n) {
            stringBuffer.append('y');
            ++n2;
        }
        stringBuffer.append("-MM-dd'T'HH:mm:ss");
        int n3 = n = string.indexOf(46);
        while (n > 0 && n3 < string.length() - 1 && n3 < n + 3) {
            if (!Character.isDigit(string.charAt(n3 + 1))) break;
            if (n3 == n) {
                stringBuffer.append('.');
            }
            stringBuffer.append('S');
            ++n3;
        }
        return stringBuffer.length() - 2;
    }

    static {
        dateFormatter.setTimeZone(gmtTimeZone);
        timeZoneFormatter.setTimeZone(gmtTimeZone);
    }
}

