/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDDateTimeDateEncoder;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class XSDDateTimeCalendarEncoder
extends XSDDateTimeDateEncoder {
    private static final SimpleTypeEncoder encoder = new XSDDateTimeCalendarEncoder();
    private static Method getDSTSavingsMethod = null;
    private static final SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final Calendar gmtCalendar = Calendar.getInstance();

    private XSDDateTimeCalendarEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String objectToString(Object object, XMLWriter xMLWriter) throws Exception {
        if (object == null) {
            return null;
        }
        Calendar calendar = (Calendar)object;
        int n = calendar.get(15);
        if (calendar.getTimeZone().inDaylightTime(calendar.getTime())) {
            n += ((Integer)getDSTSavingsMethod.invoke((Object)calendar.getTimeZone(), null)).intValue();
        }
        int n2 = n / 3600000;
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(n < 0 ? (char)'-' : '+');
        int n3 = n2 = n2 < 0 ? -n2 : n2;
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2 + ":00");
        String string = new String(stringBuffer);
        SimpleDateFormat simpleDateFormat = calendarFormatter;
        synchronized (simpleDateFormat) {
            calendarFormatter.setTimeZone(calendar.getTimeZone());
            return calendarFormatter.format(calendar.getTime()) + string;
        }
    }

    public Object stringToObject(String string, XMLReader xMLReader) throws Exception {
        Calendar calendar;
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        Date date = XSDDateTimeDateEncoder.decodeDateUtil(string, stringBuffer);
        String string2 = stringBuffer.toString();
        if (string2.length() == 0) {
            calendar = Calendar.getInstance(XSDDateTimeDateEncoder.gmtTimeZone);
            calendar.setTime(date);
        } else {
            calendar = Calendar.getInstance(XSDDateTimeDateEncoder.gmtTimeZone);
            calendar.setTime(date);
            TimeZone timeZone = TimeZone.getTimeZone("GMT" + string2);
            int n = timeZone.getRawOffset();
            TimeZone timeZone2 = TimeZone.getDefault();
            if (timeZone2.inDaylightTime(date)) {
                n -= ((Integer)getDSTSavingsMethod.invoke((Object)timeZone2, null)).intValue();
            }
            timeZone2.setRawOffset(n);
            timeZone2.setID("Custom");
            calendar.setTimeZone(timeZone2);
        }
        return calendar;
    }

    public void writeAdditionalNamespaceDeclarations(Object object, XMLWriter xMLWriter) throws Exception {
    }

    static {
        gmtCalendar.setTimeZone(XSDDateTimeDateEncoder.gmtTimeZone);
        try {
            getDSTSavingsMethod = TimeZone.getDefault().getClass().getMethod("getDSTSavings", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("FATAL ERROR: no getDSTSavings method defined on TimeZone");
        }
    }
}

