/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.ExtendedTypeMapping;
import com.sun.xml.rpc.encoding.TypeMappingDescriptor;
import com.sun.xml.rpc.encoding.TypeMappingException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;

public class TypeMappingImpl
implements ExtendedTypeMapping {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final boolean UNIQUE_IS_REQUIRED = true;
    protected static final boolean UNIQUE_IS_OPTIONAL = false;
    protected static final Row NULL_ROW = new Row();
    protected static final Entry NULL_ENTRY;
    private Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    protected ExtendedTypeMapping parent = null;
    protected String[] encodingURIs = EMPTY_STRING_ARRAY;
    protected List tuples = new ArrayList();
    static /* synthetic */ Class class$java$lang$Object;

    private int hashToIndex(int n) {
        return (n & Integer.MAX_VALUE) % this.table.length;
    }

    private Entry getHashBucket(int n) {
        return this.table[this.hashToIndex(n)];
    }

    private void put(int n, Row row) {
        if (this.count >= this.threshold) {
            this.rehash();
        }
        int n2 = this.hashToIndex(n);
        this.table[n2] = new Entry(this.table[n2], n, row);
        ++this.count;
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Object[] objectArray = new Entry[n2];
        Arrays.fill(objectArray, NULL_ENTRY);
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = objectArray;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != NULL_ENTRY) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = this.hashToIndex(entry2.hash);
                entry2.next = this.table[n4];
                this.table[n4] = entry2;
            }
        }
    }

    public TypeMappingImpl() {
        this.init();
    }

    private void init() {
        this.loadFactor = 0.75f;
        this.parent = null;
        this.encodingURIs = EMPTY_STRING_ARRAY;
        this.tuples = new ArrayList();
        int n = 57;
        this.table = new Entry[n];
        Arrays.fill(this.table, NULL_ENTRY);
        this.count = 0;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    public TypeMappingImpl(ExtendedTypeMapping extendedTypeMapping) {
        this();
        this.parent = extendedTypeMapping;
    }

    public String[] getSupportedEncodings() {
        return this.encodingURIs;
    }

    public void setSupportedEncodings(String[] stringArray) {
        this.encodingURIs = stringArray != null ? stringArray : EMPTY_STRING_ARRAY;
    }

    public boolean isRegistered(Class clazz, QName qName) {
        boolean bl;
        int n;
        if (qName == null) {
            throw new IllegalArgumentException("XML type may not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Java type may not be null");
        }
        int n2 = clazz.hashCode();
        int n3 = n2 ^ (n = qName.hashCode());
        Entry entry = this.getHashBucket(n3).getEntryMatching(clazz, qName);
        boolean bl2 = bl = entry != NULL_ENTRY;
        if (!bl && this.parent != null) {
            bl = this.parent.isRegistered(clazz, qName);
        }
        return bl;
    }

    public void register(Class clazz, QName qName, SerializerFactory serializerFactory, DeserializerFactory deserializerFactory) {
        if (qName == null) {
            throw new IllegalArgumentException("XML type may not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Java type may not be null");
        }
        try {
            int n = clazz.hashCode();
            int n2 = qName.hashCode();
            int n3 = n ^ n2;
            Row row = this.getHashBucket((int)n3).getEntryMatching((Class)clazz, (QName)qName).row;
            if (row != NULL_ROW) {
                row.serializerFactory = serializerFactory;
                row.deserializerFactory = deserializerFactory;
            } else {
                Row row2 = new Row(clazz, qName, serializerFactory, deserializerFactory);
                this.put(n, row2);
                this.put(n2, row2);
                this.put(n3, row2);
                this.tuples.add(row2);
            }
        }
        catch (Exception exception) {
            throw new TypeMappingException("typemapping.registration.failed.nested.exception", new LocalizableExceptionAdapter(exception));
        }
    }

    protected Entry getEntryMatching(Class clazz) {
        return this.getHashBucket(clazz.hashCode()).getEntryMatching(clazz);
    }

    protected Entry getEntryMatching(QName qName) {
        return this.getHashBucket(qName.hashCode()).getEntryMatching(qName);
    }

    protected Entry getNonPrimitiveEntryMatching(QName qName) {
        return this.getHashBucket(qName.hashCode()).getNonPrimitiveEntryMatching(qName);
    }

    protected Entry getEntryMatching(Class clazz, QName qName) {
        return this.getHashBucket(clazz.hashCode() ^ qName.hashCode()).getEntryMatching(clazz, qName);
    }

    protected Entry getEntryClosestTo(Class clazz, QName qName) {
        Entry entry = this.getEntryMatching(clazz, qName);
        if (entry == NULL_ENTRY) {
            entry = this.getEntryMatching(qName).getEntryMatchingSuperclassOf(clazz, qName);
        }
        return entry;
    }

    protected Entry getEntryCloesestTo(Class clazz) {
        Entry entry = this.getEntryMatching(clazz);
        if (entry != NULL_ENTRY) {
            return entry;
        }
        ArrayList arrayList = new ArrayList();
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && !clazz2.equals(class$java$lang$Object == null ? (class$java$lang$Object = TypeMappingImpl.class$("java.lang.Object")) : class$java$lang$Object)) {
            arrayList.add(clazz2);
        }
        arrayList.addAll(Arrays.asList(clazz.getInterfaces()));
        int n = 0;
        while (n < arrayList.size()) {
            Class clazz3 = (Class)arrayList.get(n);
            if (clazz3 != null) {
                entry = this.getEntryMatching(clazz3);
                if (entry != NULL_ENTRY) break;
                clazz2 = clazz3.getSuperclass();
                if (clazz2 != null && !clazz2.equals(class$java$lang$Object == null ? TypeMappingImpl.class$("java.lang.Object") : class$java$lang$Object)) {
                    arrayList.add(clazz2);
                }
            }
            ++n;
        }
        return entry;
    }

    protected SerializerFactory getSerializer(Class clazz, boolean bl) {
        try {
            Entry entry = this.getEntryCloesestTo(clazz);
            SerializerFactory serializerFactory = entry.row.serializerFactory;
            return serializerFactory;
        }
        catch (Exception exception) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(exception));
        }
    }

    protected SerializerFactory getSerializer(QName qName, boolean bl) {
        try {
            Entry entry = this.getNonPrimitiveEntryMatching(qName);
            SerializerFactory serializerFactory = entry.row.serializerFactory;
            if (bl && entry.next.getNonPrimitiveEntryMatching(qName) != NULL_ENTRY) {
                return null;
            }
            return serializerFactory;
        }
        catch (Exception exception) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(exception));
        }
    }

    protected DeserializerFactory getDeserializer(Class clazz, boolean bl) {
        try {
            Entry entry = this.getEntryMatching(clazz);
            DeserializerFactory deserializerFactory = entry.row.deserializerFactory;
            if (bl && entry.next.getEntryMatching(clazz) != NULL_ENTRY) {
                return null;
            }
            return deserializerFactory;
        }
        catch (Exception exception) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(exception));
        }
    }

    protected DeserializerFactory getDeserializer(QName qName, boolean bl) {
        try {
            Entry entry = this.getNonPrimitiveEntryMatching(qName);
            DeserializerFactory deserializerFactory = entry.row.deserializerFactory;
            if (bl && entry.next.getNonPrimitiveEntryMatching(qName) != NULL_ENTRY) {
                return null;
            }
            return deserializerFactory;
        }
        catch (Exception exception) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(exception));
        }
    }

    protected Class getJavaType(QName qName, boolean bl) {
        try {
            Entry entry = this.getNonPrimitiveEntryMatching(qName);
            Class clazz = entry.row.javaType;
            if (bl && entry.next.getNonPrimitiveEntryMatching(qName) != NULL_ENTRY) {
                return null;
            }
            return clazz;
        }
        catch (Exception exception) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(exception));
        }
    }

    protected QName getXmlType(Class clazz, boolean bl) {
        try {
            Entry entry = this.getEntryMatching(clazz);
            QName qName = entry.row.xmlType;
            if (bl && entry.next.getEntryMatching(clazz) != NULL_ENTRY) {
                return null;
            }
            return qName;
        }
        catch (Exception exception) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(exception));
        }
    }

    public SerializerFactory getSerializer(Class clazz, QName qName) {
        SerializerFactory serializerFactory;
        if (clazz == null) {
            if (qName == null) {
                throw new IllegalArgumentException("getSerializer requires a Java type and/or an XML type");
            }
            serializerFactory = this.getSerializer(qName, false);
        } else if (qName == null) {
            serializerFactory = this.getSerializer(clazz, false);
        } else {
            try {
                serializerFactory = this.getEntryClosestTo((Class)clazz, (QName)qName).row.serializerFactory;
            }
            catch (Exception exception) {
                throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(exception));
            }
        }
        if (serializerFactory == null && this.parent != null) {
            serializerFactory = this.parent.getSerializer(clazz, qName);
        }
        return serializerFactory;
    }

    public DeserializerFactory getDeserializer(Class clazz, QName qName) {
        DeserializerFactory deserializerFactory = null;
        if (clazz == null) {
            if (qName == null) {
                throw new IllegalArgumentException("getDeserializer requires a Java type and/or an XML type");
            }
            deserializerFactory = this.getDeserializer(qName, false);
        } else if (qName == null) {
            deserializerFactory = this.getDeserializer(clazz, false);
        } else {
            try {
                deserializerFactory = this.getEntryClosestTo((Class)clazz, (QName)qName).row.deserializerFactory;
            }
            catch (Exception exception) {
                throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(exception));
            }
        }
        if (deserializerFactory == null && this.parent != null) {
            deserializerFactory = this.parent.getDeserializer(clazz, qName);
        }
        return deserializerFactory;
    }

    public void removeSerializer(Class clazz, QName qName) {
        if (clazz == null || qName == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.getEntryMatching((Class)clazz, (QName)qName).row.serializerFactory = null;
        }
        catch (Exception exception) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(exception));
        }
    }

    public void removeDeserializer(Class clazz, QName qName) {
        if (clazz == null || qName == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.getEntryMatching((Class)clazz, (QName)qName).row.deserializerFactory = null;
        }
        catch (Exception exception) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(exception));
        }
    }

    public Class getJavaType(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException("non null xmlType required");
        }
        Class clazz = this.getJavaType(qName, false);
        if (clazz == null && this.parent != null) {
            clazz = this.parent.getJavaType(qName);
        }
        return clazz;
    }

    public QName getXmlType(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("non null xmjavaType required");
        }
        QName qName = this.getXmlType(clazz, false);
        if (qName == null && this.parent != null) {
            qName = this.parent.getXmlType(clazz);
        }
        return qName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        TypeMappingImpl.NULL_ENTRY.next = NULL_ENTRY = new Entry(null, 0, NULL_ROW);
    }

    protected static class Entry {
        Entry next;
        int hash;
        Row row;

        Entry(Entry entry, int n, Row row) {
            if (row == null) {
                throw new IllegalArgumentException("row may not be null");
            }
            this.next = entry;
            this.hash = n;
            this.row = row;
        }

        Entry getEntryMatching(Class clazz) {
            Entry entry = this;
            while (entry != NULL_ENTRY && !entry.row.javaType.equals(clazz)) {
                entry = entry.next;
            }
            return entry;
        }

        Entry getEntryMatchingSuperclassOf(Class clazz) {
            Entry entry = NULL_ENTRY;
            Entry entry2 = this;
            while (entry2 != NULL_ENTRY) {
                if (entry2.matchesSuperclassOf(clazz) && (entry == NULL_ENTRY || entry2.matchesSubclassOf(entry.row.javaType))) {
                    entry = entry2;
                }
                entry2 = entry2.next;
            }
            return entry;
        }

        boolean matchesSubclassOf(Class clazz) {
            Class clazz2 = this.row.javaType;
            return clazz.equals(clazz2) || clazz.isAssignableFrom(clazz2) && clazz != (class$java$lang$Object == null ? (class$java$lang$Object = TypeMappingImpl.class$("java.lang.Object")) : class$java$lang$Object);
        }

        boolean matchesSuperclassOf(Class clazz) {
            Class clazz2 = this.row.javaType;
            return clazz2.equals(clazz) || clazz2.isAssignableFrom(clazz) && clazz2 != (class$java$lang$Object == null ? (class$java$lang$Object = TypeMappingImpl.class$("java.lang.Object")) : class$java$lang$Object);
        }

        Entry getEntryMatching(QName qName) {
            Entry entry = this;
            while (entry != NULL_ENTRY && !entry.row.xmlType.equals(qName)) {
                entry = entry.next;
            }
            return entry;
        }

        Entry getNonPrimitiveEntryMatching(QName qName) {
            Entry entry = this;
            while (entry != NULL_ENTRY && (!entry.row.xmlType.equals(qName) || entry.row.javaType.isPrimitive())) {
                entry = entry.next;
            }
            return entry;
        }

        Entry getEntryMatching(Class clazz, QName qName) {
            Entry entry = this;
            while (!(entry == NULL_ENTRY || entry.row.javaType.equals(clazz) && entry.row.xmlType.equals(qName))) {
                entry = entry.next;
            }
            return entry;
        }

        Entry getEntryMatchingSuperclassOf(Class clazz, QName qName) {
            Entry entry = NULL_ENTRY;
            Entry entry2 = this;
            while (entry2 != NULL_ENTRY) {
                if (entry2.matchesSuperclassOf(clazz) && entry2.row.xmlType.equals(qName) && (entry == NULL_ENTRY || entry2.matchesSubclassOf(entry.row.javaType))) {
                    entry = entry2;
                }
                entry2 = entry2.next;
            }
            return entry;
        }
    }

    public static class Row
    implements TypeMappingDescriptor {
        Class javaType;
        QName xmlType;
        SerializerFactory serializerFactory;
        DeserializerFactory deserializerFactory;

        Row(Class clazz, QName qName, SerializerFactory serializerFactory, DeserializerFactory deserializerFactory) {
            if (clazz == null) {
                throw new IllegalArgumentException("javaType may not be null");
            }
            if (qName == null) {
                throw new IllegalArgumentException("xmlType may not be null");
            }
            if (serializerFactory == null) {
                throw new IllegalArgumentException("serializerFactory may not be null");
            }
            if (deserializerFactory == null) {
                throw new IllegalArgumentException("deserializerFactory may not be null");
            }
            this.javaType = clazz;
            this.xmlType = qName;
            this.serializerFactory = serializerFactory;
            this.deserializerFactory = deserializerFactory;
        }

        Row() {
            this.javaType = null;
            this.xmlType = null;
            this.serializerFactory = null;
            this.deserializerFactory = null;
        }

        public Class getJavaType() {
            return this.javaType;
        }

        public QName getXMLType() {
            return this.xmlType;
        }

        public SerializerFactory getSerializer() {
            return this.serializerFactory;
        }

        public DeserializerFactory getDeserializer() {
            return this.deserializerFactory;
        }
    }
}

