/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.util.IntegerArrayList;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;

public class SOAPDeserializationState {
    private static final boolean writeDebug = false;
    private static final int CREATION_GATES_CONSTRUCTION = 5;
    private static final int INITIALIZATION_GATES_CONSTRUCTION = 17;
    private static final int COMPLETION_GATES_CONSTRUCTION = 9;
    private static final int CREATION_GATES_INITIALIZATION = 6;
    private static final int INITIALIZATION_GATES_INITIALIZATION = 10;
    private static final int COMPLETION_GATES_INITIALIZATION = 18;
    private static final int NO_STATE = 0;
    private static final int CREATED_STATE = 4;
    private static final int INITIALIZED_STATE = 8;
    private static final int COMPLETE_STATE = 16;
    private static final int CREATION_EVENT = 4;
    private static final int INITIALIZATION_EVENT = 8;
    private static final int COMPLETION_EVENT = 16;
    private static final int EVENT_BIT_MASK = 28;
    private static final int CREATION_GATE = 1;
    private static final int INITIALIZATION_GATE = 2;
    private static final int GATE_BIT_MASK = 3;
    private JAXRPCDeserializer deserializer = null;
    private SOAPInstanceBuilder builder = null;
    private List listeners = new ArrayList();
    private IntegerArrayList listenerMembers = new IntegerArrayList();
    private int constructionGates = 0;
    private int initializationGates = 0;
    private int completionGates = 0;
    private boolean hasBeenRead = false;
    private int state = 0;
    private Object instance = null;
    private XMLReader recordedElement = null;
    private QName recordedElementExpectedName = null;
    private SOAPDeserializationContext recordedElementDeserialzationContext;

    public boolean isCompleteForKnownMembers() {
        return this.completionGates == 0;
    }

    public boolean isComplete() {
        return this.state == 16;
    }

    public void promoteToCompleteOrFail() {
        switch (this.state) {
            case 16: {
                return;
            }
            case 8: {
                this.state = 16;
                return;
            }
        }
        throw new DeserializationException("soap.incompleteObject");
    }

    public void registerListener(SOAPDeserializationState sOAPDeserializationState, int n) {
        if (this.deserializer == null) {
            throw new DeserializationException("soap.state.wont.notify.without.deserializer");
        }
        this.listeners.add(sOAPDeserializationState);
        this.listenerMembers.add(n);
        sOAPDeserializationState.waitFor(n);
        this.sendPastEventsTo(sOAPDeserializationState, n);
    }

    public void sendPastEventsTo(SOAPDeserializationState sOAPDeserializationState, int n) {
        int n2 = 0;
        while (n2 != this.state) {
            switch (n2) {
                case 0: {
                    sOAPDeserializationState.setMember(n, this.getInstance());
                    n2 = 4;
                    break;
                }
                case 4: {
                    n2 = 8;
                    break;
                }
                case 8: {
                    n2 = 16;
                }
            }
            sOAPDeserializationState.beNotified(n, n2);
        }
    }

    private void waitFor(int n) {
        switch (this.memberGateType(n)) {
            case 5: 
            case 9: 
            case 17: {
                ++this.constructionGates;
                break;
            }
            case 6: 
            case 10: 
            case 18: {
                ++this.initializationGates;
            }
        }
        ++this.completionGates;
    }

    public void beNotified(int n, int n2) {
        int n3 = this.memberGateType(n);
        int n4 = n3 & 0x1C;
        if (n2 == n4) {
            int n5 = n3 & 3;
            switch (n5) {
                case 1: {
                    --this.constructionGates;
                    break;
                }
                case 2: {
                    --this.initializationGates;
                }
            }
        }
        if (n2 == 16) {
            --this.completionGates;
        }
        this.updateState();
    }

    private void updateState() {
        switch (this.state) {
            case 0: {
                if (this.constructionGates > 0) {
                    return;
                }
                if (this.instance == null && this.builder != null) {
                    this.builder.construct();
                }
                this.changeStateTo(4);
            }
            case 4: {
                if (this.initializationGates > 0 || !this.hasBeenRead) {
                    return;
                }
                if (this.builder != null) {
                    this.builder.initialize();
                }
                this.changeStateTo(8);
            }
            case 8: {
                if (this.completionGates > 0) {
                    return;
                }
                this.changeStateTo(16);
            }
        }
    }

    private void changeStateTo(int n) {
        this.state = n;
        this.notifyListeners();
    }

    private void notifyListeners() {
        int n = 0;
        while (n < this.listeners.size()) {
            SOAPDeserializationState sOAPDeserializationState = (SOAPDeserializationState)this.listeners.get(n);
            int n2 = this.listenerMembers.get(n);
            if (this.state == 4) {
                sOAPDeserializationState.setMember(n2, this.getInstance());
            }
            sOAPDeserializationState.beNotified(n2, this.state);
            ++n;
        }
    }

    public int memberGateType(int n) {
        if (this.builder == null) {
            throw new IllegalStateException();
        }
        return this.builder.memberGateType(n);
    }

    public void setInstance(Object object) {
        this.instance = object;
        if (this.builder != null) {
            this.builder.setInstance(object);
        }
    }

    protected void setMember(int n, Object object) {
        if (this.builder == null) {
            throw new IllegalStateException();
        }
        this.builder.setMember(n, object);
    }

    public void setBuilder(SOAPInstanceBuilder sOAPInstanceBuilder) {
        if (sOAPInstanceBuilder == null) {
            throw new IllegalArgumentException();
        }
        if (this.builder != null && this.builder != sOAPInstanceBuilder) {
            throw new IllegalStateException();
        }
        this.builder = sOAPInstanceBuilder;
        this.builder.setInstance(this.instance);
    }

    public SOAPInstanceBuilder getBuilder() {
        return this.builder;
    }

    public void setDeserializer(JAXRPCDeserializer jAXRPCDeserializer) {
        try {
            if (jAXRPCDeserializer == null) {
                return;
            }
            if (this.deserializer != null) {
                return;
            }
            this.deserializer = jAXRPCDeserializer;
            if (this.recordedElement != null) {
                this.deserialize(this.recordedElementExpectedName, this.recordedElement, this.recordedElementDeserialzationContext);
            }
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new DeserializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new DeserializationException(new LocalizableExceptionAdapter(exception));
        }
    }

    public void doneReading() {
        this.hasBeenRead = true;
        this.updateState();
    }

    public Object getInstance() {
        if (this.builder == null) {
            return this.instance;
        }
        return this.builder.getInstance();
    }

    public void deserialize(QName qName, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) {
        try {
            if (this.deserializer == null) {
                this.recordedElementExpectedName = qName;
                this.recordedElement = xMLReader.recordElement();
                this.recordedElementDeserialzationContext = sOAPDeserializationContext;
                return;
            }
            this.deserializer.deserialize(qName, xMLReader, sOAPDeserializationContext);
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new DeserializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new DeserializationException(new LocalizableExceptionAdapter(exception));
        }
    }

    public void deserialize(DataHandler dataHandler, SOAPDeserializationContext sOAPDeserializationContext) throws DeserializationException {
        try {
            if (this.deserializer == null) {
                throw new DeserializationException("deserializationstate.deserialize.no.deserializer");
            }
            this.deserializer.deserialize(dataHandler, sOAPDeserializationContext);
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new DeserializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new DeserializationException(new LocalizableExceptionAdapter(exception));
        }
    }

    private String stringRep() {
        int n;
        String string;
        StringBuffer stringBuffer = new StringBuffer("" + this.hashCode() + ":");
        if (this.getInstance() != null) {
            string = this.getInstance().getClass().getName();
            n = string.lastIndexOf(46);
            stringBuffer.append(string.substring(n));
        }
        stringBuffer.append(":");
        if (this.deserializer != null) {
            string = this.deserializer.getClass().getName();
            n = string.lastIndexOf(46);
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }
}

