/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.xml.namespace.QName;

public abstract class InterfaceSerializerBase
extends SerializerBase {
    protected InterfaceSerializerBase(QName qName, boolean bl, boolean bl2, String string) {
        super(qName, bl, bl2, string);
    }

    protected abstract Object doDeserialize(QName var1, XMLReader var2, SOAPDeserializationContext var3) throws Exception;

    protected abstract void doSerializeInstance(Object var1, QName var2, SerializerCallback var3, XMLWriter var4, SOAPSerializationContext var5) throws Exception;

    public void serialize(Object object, QName qName, SerializerCallback serializerCallback, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) {
        try {
            if (object == null) {
                if (!this.isNullable) {
                    throw new SerializationException("soap.unexpectedNull");
                }
                this.serializeNull(qName, xMLWriter, sOAPSerializationContext);
            } else {
                this.doSerializeInstance(object, qName, serializerCallback, xMLWriter, sOAPSerializationContext);
            }
        }
        catch (SerializationException serializationException) {
            throw serializationException;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new SerializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new SerializationException(new LocalizableExceptionAdapter(exception));
        }
    }

    protected void serializeNull(QName qName, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        xMLWriter.startElement(qName != null ? qName : this.type);
        boolean bl = false;
        if (this.encodingStyle != null) {
            bl = sOAPSerializationContext.pushEncodingStyle(this.encodingStyle, xMLWriter);
        }
        if (this.encodeType) {
            String string = XMLWriterUtil.encodeQName(xMLWriter, this.type);
            xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, string);
        }
        xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
        xMLWriter.endElement();
        if (bl) {
            sOAPSerializationContext.popEncodingStyle();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object deserialize(QName qName, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) {
        SOAPDeserializationState sOAPDeserializationState;
        boolean bl = false;
        try {
            try {
                boolean bl2 = SerializerBase.getNullStatus(xMLReader);
                if (!bl2) {
                    Object object = this.doDeserialize(qName, xMLReader, sOAPDeserializationContext);
                    Object var9_10 = null;
                    if (!bl) return object;
                    sOAPDeserializationContext.popEncodingStyle();
                    return object;
                }
                if (!this.isNullable) {
                    throw new DeserializationException("soap.unexpectedNull");
                }
                String string = this.getID(xMLReader);
                this.skipEmptyContent(xMLReader);
                if (string != null) {
                    sOAPDeserializationState = sOAPDeserializationContext.getStateFor(string);
                    sOAPDeserializationState.setDeserializer(this);
                    sOAPDeserializationState.setInstance(null);
                    sOAPDeserializationState.doneReading();
                }
                sOAPDeserializationState = null;
            }
            catch (DeserializationException deserializationException) {
                throw deserializationException;
            }
            catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
                throw new DeserializationException(jAXRPCExceptionBase);
            }
            catch (Exception exception) {
                throw new DeserializationException(new LocalizableExceptionAdapter(exception));
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!bl) throw throwable;
            sOAPDeserializationContext.popEncodingStyle();
            throw throwable;
        }
        Object var9_11 = null;
        if (!bl) return sOAPDeserializationState;
        sOAPDeserializationContext.popEncodingStyle();
        return sOAPDeserializationState;
    }
}

