/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.dii.BasicCall;
import com.sun.xml.rpc.client.dii.DynamicInvocationException;
import com.sun.xml.rpc.client.dii.MethodInfo;
import com.sun.xml.rpc.client.dii.OperationInfo;
import com.sun.xml.rpc.client.dii.PortInfo;
import com.sun.xml.rpc.client.dii.ServiceInfo;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.util.Holders;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.handler.HandlerRegistry;

public class ConfiguredCall
extends BasicCall {
    ServiceInfo configuration;
    Method operationMethod = null;
    String methodName = null;
    QName portTypeName = BasicCall.EMPTY_QNAME;

    public ConfiguredCall(InternalTypeMappingRegistry internalTypeMappingRegistry, HandlerRegistry handlerRegistry, ServiceInfo serviceInfo) {
        super(internalTypeMappingRegistry, handlerRegistry);
        if (serviceInfo == null) {
            throw new IllegalArgumentException("configuration not allowed to be null");
        }
        this.configuration = serviceInfo;
    }

    public boolean isParameterAndReturnSpecRequired(QName qName) {
        return false;
    }

    public void setMethodName(String string) {
        this.methodName = string;
        this.configureCall();
    }

    public void setOperationName(QName qName) {
        super.setOperationName(qName);
        this.methodName = qName.getLocalPart();
        this.configureCall();
    }

    public void setPortName(QName qName) {
        super.setPortName(qName);
        this.configureCall();
    }

    public void setOperationMethod(Method method) {
        this.operationMethod = method;
    }

    protected void configureCall() {
        this.configureCall(this.operationMethod);
    }

    protected void configureCall(Method method) {
        if (this.readyToConfigure()) {
            PortInfo portInfo = this.configuration.getPortInfo(this.getPortName());
            this.setPortTypeName(portInfo.getPortTypeName());
            MethodInfo methodInfo = new MethodInfo(method);
            Iterator iterator = portInfo.getOperations();
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                OperationInfo operationInfo = (OperationInfo)iterator.next();
                if (!methodInfo.matches(this.methodName, operationInfo)) continue;
                bl = true;
                this.doConfigureCall(methodInfo, operationInfo);
            }
            if (!bl) {
                throw new DynamicInvocationException("dii.port.does.not.contain.operation", new Object[]{this.getPortName(), this.methodName});
            }
        }
    }

    protected void doConfigureCall(MethodInfo methodInfo, OperationInfo operationInfo) {
        Object object;
        Object object2;
        PortInfo portInfo = this.configuration.getPortInfo(this.getPortName());
        super.setOperationName(operationInfo.getName());
        this.setTargetEndpointAddress(portInfo.getTargetEndpoint());
        String[] stringArray = operationInfo.getParameterNames();
        QName[] qNameArray = operationInfo.getParameterXmlTypes();
        Class[] classArray = methodInfo.getParameterTypes(qNameArray.length);
        ParameterMode[] parameterModeArray = operationInfo.getParameterModes();
        int n = 0;
        while (n < stringArray.length) {
            object2 = stringArray[n];
            object = qNameArray != null ? qNameArray[n] : null;
            Class clazz = Holders.stripHolderClass(classArray[n]);
            ParameterMode parameterMode = parameterModeArray[n];
            this.doAddParameter((String)object2, (QName)object, clazz, parameterMode);
            ++n;
        }
        this.doSetReturnType(operationInfo.getReturnXmlType(), methodInfo.getReturnType());
        object2 = operationInfo.getPropertyKeys();
        while (object2.hasNext()) {
            object = (String)object2.next();
            this.setProperty((String)object, operationInfo.getProperty((String)object));
        }
    }

    protected boolean readyToConfigure() {
        return this.getPortName() != null && !this.getPortName().equals(BasicCall.EMPTY_QNAME) && this.methodName != null && !this.methodName.equals("");
    }
}

