/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.dii.DynamicInvocationException;
import com.sun.xml.rpc.util.Holders;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.Call;
import javax.xml.rpc.Stub;
import javax.xml.rpc.holders.Holder;

public class CallInvocationHandler
implements InvocationHandler,
Stub {
    private static final Set recognizedProperties;
    private Map callMap = new HashMap();
    private Map properties = new HashMap();
    private Class portInterface;

    CallInvocationHandler(Class clazz) {
        this.portInterface = clazz;
    }

    public void addCall(Method method, Call call) {
        this.callMap.put(method, call);
    }

    public Call getCall(Method method) {
        return (Call)this.callMap.get(method);
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Exception {
        if (this.portInterface.equals(method.getDeclaringClass())) {
            Call call = this.getCall(method);
            if (call == null) {
                String string = "";
                Iterator iterator = this.callMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Method method2 = (Method)iterator.next();
                    string = string + "\n" + method2.getName();
                }
                throw new DynamicInvocationException("dii.dynamicproxy.method.unrecognized", new Object[]{method != null ? method.getName() : null, string});
            }
            return this.doCall(call, objectArray);
        }
        return this.doNonPort(method, objectArray);
    }

    protected Object doCall(Call call, Object[] objectArray) throws RemoteException {
        List list;
        Object object;
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Holder[] holderArray = new Holder[objectArray.length];
        int[] nArray = new int[objectArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            object = objectArray[n2];
            if (object instanceof Holder) {
                list = (Holder)object;
                nArray[n] = n2;
                holderArray[n] = list;
                objectArray[n2] = Holders.getValue((Holder)list);
                ++n;
            }
            ++n2;
        }
        object = call.invoke(objectArray);
        if (n > 0) {
            list = call.getOutputValues();
            Iterator iterator = list.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                int n4 = nArray[n3];
                Holder holder = holderArray[n3];
                Holders.setValue(holder, e);
                objectArray[n4] = holder;
                ++n3;
            }
        }
        return object;
    }

    protected Object doNonPort(Method method, Object[] objectArray) {
        try {
            return method.invoke((Object)this, objectArray);
        }
        catch (Exception exception) {
            throw new DynamicInvocationException("dii.exception.nested", new LocalizableExceptionAdapter(exception));
        }
    }

    public void _setProperty(String string, Object object) {
        if (!recognizedProperties.contains(string)) {
            throw new IllegalArgumentException("Call object does not recognize property: " + string);
        }
        this.properties.put(string, object);
        this.setPropertyOnCallObjects(string, object);
    }

    public Object _getProperty(String string) {
        return this.properties.get(string);
    }

    public Iterator _getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    private void setPropertyOnCallObjects(String string, Object object) {
        Iterator iterator = this.callMap.values().iterator();
        while (iterator.hasNext()) {
            Call call = (Call)iterator.next();
            if ("javax.xml.rpc.service.endpoint.address".equals(string)) {
                call.setTargetEndpointAddress((String)object);
                continue;
            }
            call.setProperty(string, object);
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("javax.xml.rpc.security.auth.username");
        hashSet.add("javax.xml.rpc.security.auth.password");
        hashSet.add("javax.xml.rpc.service.endpoint.address");
        hashSet.add("javax.xml.rpc.session.maintain");
        recognizedProperties = Collections.unmodifiableSet(hashSet);
    }
}

