/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.HandlerChainImpl;
import com.sun.xml.rpc.client.dii.CallEx;
import com.sun.xml.rpc.client.dii.CallInvoker;
import com.sun.xml.rpc.client.dii.CallInvokerImpl;
import com.sun.xml.rpc.client.dii.CallRequest;
import com.sun.xml.rpc.client.dii.DynamicInvocationException;
import com.sun.xml.rpc.encoding.DynamicInternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ReferenceableSerializerImpl;
import com.sun.xml.rpc.encoding.SOAPFaultInfoSerializer;
import com.sun.xml.rpc.encoding.literal.LiteralFragmentSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPRequestSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPResponseSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPResponseStructure;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerRegistry;
import javax.xml.soap.SOAPMessage;

public class BasicCall
implements CallEx {
    protected static final QName EMPTY_QNAME = new QName("");
    protected static final QName RESULT_QNAME = null;
    protected static final int RETURN_VALUE_INDEX = 0;
    protected static final JAXRPCDeserializer faultDeserializer = new ReferenceableSerializerImpl(false, new SOAPFaultInfoSerializer(false, false));
    protected static final Set recognizedProperties;
    protected JAXRPCSerializer requestSerializer = null;
    protected JAXRPCDeserializer responseDeserializer = null;
    protected List inParameterNames = new ArrayList();
    protected List outParameterNames = new ArrayList();
    protected List inParameterXmlTypes = new ArrayList();
    protected List outParameterXmlTypes = new ArrayList();
    protected List inParameterClasses = new ArrayList();
    protected List outParameterClasses = new ArrayList();
    protected SOAPResponseStructure response = null;
    protected QName returnXmlType = null;
    protected Class returnClass = null;
    protected QName operationName = EMPTY_QNAME;
    protected QName portName = EMPTY_QNAME;
    protected QName portTypeName = EMPTY_QNAME;
    protected String targetEndpointAddress = null;
    protected Map properties = new HashMap();
    protected InternalTypeMappingRegistry typeRegistry;
    protected CallInvoker invoker = new CallInvokerImpl();
    protected HandlerRegistry handlerRegistry;

    public BasicCall(InternalTypeMappingRegistry internalTypeMappingRegistry, HandlerRegistry handlerRegistry) {
        if (internalTypeMappingRegistry == null) {
            throw new DynamicInvocationException("dii.typeregistry.missing.in.call");
        }
        this.typeRegistry = new DynamicInternalTypeMappingRegistry(internalTypeMappingRegistry);
        this.handlerRegistry = handlerRegistry;
        this.setProperty("javax.xml.rpc.soap.http.soapaction.use", new Boolean(false));
    }

    public boolean isParameterAndReturnSpecRequired(QName qName) {
        return true;
    }

    public HandlerChain getHandlerChain() {
        if (this.handlerRegistry.getHandlerChain(this.portName) == null) {
            return null;
        }
        return new HandlerChainImpl(this.handlerRegistry.getHandlerChain(this.portName));
    }

    public void addParameter(String string, QName qName, ParameterMode parameterMode) {
        this.checkIsParameterAndReturnTypeSpecAllowed();
        this.doAddParameter(string, qName, parameterMode);
    }

    protected void doAddParameter(String string, QName qName, ParameterMode parameterMode) {
        this.doAddParameter(string, qName, null, parameterMode);
    }

    public void addParameter(String string, QName qName, Class clazz, ParameterMode parameterMode) {
        this.checkIsParameterAndReturnTypeSpecAllowed();
        this.doAddParameter(string, qName, clazz, parameterMode);
    }

    protected void doAddParameter(String string, QName qName, Class clazz, ParameterMode parameterMode) {
        this.resetSerializers();
        if (parameterMode == ParameterMode.OUT) {
            this.outParameterNames.add(new QName(string));
            this.outParameterXmlTypes.add(qName);
            this.outParameterClasses.add(clazz);
        } else if (parameterMode == ParameterMode.IN) {
            this.inParameterNames.add(new QName(string));
            this.inParameterXmlTypes.add(qName);
            this.inParameterClasses.add(clazz);
        } else if (parameterMode == ParameterMode.INOUT) {
            this.inParameterNames.add(new QName(string));
            this.inParameterXmlTypes.add(qName);
            this.inParameterClasses.add(clazz);
            this.outParameterNames.add(new QName(string));
            this.outParameterXmlTypes.add(qName);
            this.outParameterClasses.add(clazz);
        }
    }

    public QName getParameterTypeByName(String string) {
        String string2;
        ListIterator listIterator = this.inParameterNames.listIterator();
        while (listIterator.hasNext()) {
            string2 = ((QName)listIterator.next()).getLocalPart();
            if (!string2.equals(string)) continue;
            return (QName)this.inParameterXmlTypes.get(listIterator.previousIndex());
        }
        listIterator = this.outParameterNames.listIterator();
        while (listIterator.hasNext()) {
            string2 = ((QName)listIterator.next()).getLocalPart();
            if (!string2.equals(string)) continue;
            return (QName)this.outParameterXmlTypes.get(listIterator.previousIndex());
        }
        return null;
    }

    public void setReturnType(QName qName) {
        this.checkIsParameterAndReturnTypeSpecAllowed();
        this.doSetReturnType(qName);
    }

    protected void doSetReturnType(QName qName) {
        this.setReturnType(qName, null);
    }

    public void setReturnType(QName qName, Class clazz) {
        this.checkIsParameterAndReturnTypeSpecAllowed();
        this.doSetReturnType(qName, clazz);
    }

    protected void doSetReturnType(QName qName, Class clazz) {
        this.resetSerializers();
        this.returnXmlType = qName;
        this.returnClass = clazz;
    }

    public QName getReturnType() {
        return this.returnXmlType;
    }

    public void removeAllParameters() {
        this.checkIsParameterAndReturnTypeSpecAllowed();
        this.doRemoveAllParameters();
    }

    protected void doRemoveAllParameters() {
        this.resetSerializers();
        this.inParameterNames.clear();
        this.inParameterXmlTypes.clear();
        this.inParameterClasses.clear();
        this.outParameterNames.clear();
        this.outParameterXmlTypes.clear();
        this.outParameterClasses.clear();
    }

    protected void resetSerializers() {
        this.requestSerializer = null;
        this.responseDeserializer = null;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(QName qName) {
        this.portTypeName = qName;
    }

    public QName getPortName() {
        return this.portName;
    }

    public void setPortName(QName qName) {
        this.portName = qName;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName qName) {
        this.operationName = qName;
    }

    public void setTargetEndpointAddress(String string) {
        this.targetEndpointAddress = string;
        this.invoker = new CallInvokerImpl();
    }

    public String getTargetEndpointAddress() {
        return this.targetEndpointAddress;
    }

    public void setProperty(String string, Object object) {
        if (!recognizedProperties.contains(string)) {
            throw new DynamicInvocationException("dii.call.property.set.unrecognized", new Object[]{string});
        }
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        if (!recognizedProperties.contains(string)) {
            throw new DynamicInvocationException("dii.call.property.get.unrecognized", new Object[]{string});
        }
        return this.properties.get(string);
    }

    public void removeProperty(String string) {
        this.properties.remove(string);
    }

    public Iterator getPropertyNames() {
        return recognizedProperties.iterator();
    }

    public Object invoke(Object[] objectArray) throws RemoteException {
        block7: {
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            try {
                String string = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
                if ("document".equals(string)) {
                    this.response = this.getInvoker().doInvoke(new CallRequest(this, (SOAPMessage)objectArray[0]), this.getRequestSerializer(), this.getResponseDeserializer(), this.getFaultDeserializer());
                    break block7;
                }
                if ("rpc".equals(string)) {
                    this.response = this.getInvoker().doInvoke(new CallRequest(this, objectArray), this.getRequestSerializer(), this.getResponseDeserializer(), this.getFaultDeserializer());
                    break block7;
                }
                throw this.unsupportedOperationStyleException(string);
            }
            catch (RemoteException remoteException) {
                throw remoteException;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RemoteException("", (Throwable)((Object)new DynamicInvocationException(new LocalizableExceptionAdapter(exception))));
            }
        }
        return this.response.returnValue;
    }

    public Object invoke(QName qName, Object[] objectArray) throws RemoteException {
        this.setOperationName(qName);
        Object object = this.invoke(objectArray);
        return object;
    }

    public void invokeOneWay(Object[] objectArray) {
        block6: {
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            try {
                String string = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
                if ("document".equals(string)) {
                    this.getInvoker().doInvokeOneWay(new CallRequest(this, (SOAPMessage)objectArray[0]), this.getRequestSerializer());
                    break block6;
                }
                if ("rpc".equals(string)) {
                    this.getInvoker().doInvokeOneWay(new CallRequest(this, objectArray), this.getRequestSerializer());
                    break block6;
                }
                throw this.unsupportedOperationStyleException(string);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new DynamicInvocationException(new LocalizableExceptionAdapter(exception));
            }
        }
    }

    protected DynamicInvocationException unsupportedOperationStyleException(String string) {
        return new DynamicInvocationException("dii.operation.style.unsupported", new Object[]{string});
    }

    public Map getOutputParams() {
        if (this.response == null) {
            throw new DynamicInvocationException("dii.outparameters.not.available");
        }
        return Collections.unmodifiableMap(this.response.outParameters);
    }

    public List getOutputValues() {
        return Collections.unmodifiableList((List)this.response.outParameters.values());
    }

    Object getRequiredProperty(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            throw this.propertyNotFoundException(string);
        }
        return object;
    }

    protected void checkIsParameterAndReturnTypeSpecAllowed() {
        if (!this.isParameterAndReturnSpecRequired(this.operationName)) {
            throw new DynamicInvocationException("dii.parameterandreturntypespec.not.allowed");
        }
    }

    protected CallInvoker getInvoker() {
        return this.invoker;
    }

    protected JAXRPCSerializer getRequestSerializer() throws Exception {
        if (this.requestSerializer == null) {
            String string = this.getEncodingStyle();
            if ("http://schemas.xmlsoap.org/soap/encoding/".equals(string)) {
                this.createRpcRequestSerializer();
            } else if ("".equals(string)) {
                this.createLiteralRequestSerializer();
            } else {
                throw new DynamicInvocationException("dii.encoding.style.unsupported", new Object[]{string});
            }
        }
        return this.requestSerializer;
    }

    protected void createRpcRequestSerializer() throws Exception {
        int n = this.inParameterNames.size();
        this.requestSerializer = new SOAPRequestSerializer(EMPTY_QNAME, this.inParameterNames.toArray(new QName[n]), this.inParameterXmlTypes.toArray(new QName[n]), this.inParameterClasses.toArray(new Class[n]));
        ((Initializable)((Object)this.requestSerializer)).initialize(this.typeRegistry);
    }

    protected void createLiteralRequestSerializer() throws Exception {
        this.requestSerializer = new LiteralFragmentSerializer((QName)this.inParameterXmlTypes.get(0), true, "");
    }

    protected JAXRPCDeserializer getResponseDeserializer() throws Exception {
        if (this.responseDeserializer == null) {
            String string = this.getEncodingStyle();
            if ("http://schemas.xmlsoap.org/soap/encoding/".equals(string)) {
                this.createRpcResponseSerializer();
            } else if ("".equals(string)) {
                this.createLiteralResponseSerializer();
            } else {
                throw new DynamicInvocationException("dii.encoding.style.unsupported", new Object[]{string});
            }
        }
        return this.responseDeserializer;
    }

    protected void createRpcResponseSerializer() throws Exception {
        int n = this.outParameterNames.size();
        this.responseDeserializer = new ReferenceableSerializerImpl(false, new SOAPResponseSerializer(EMPTY_QNAME, this.outParameterNames.toArray(new QName[n]), this.outParameterXmlTypes.toArray(new QName[n]), this.outParameterClasses.toArray(new Class[n]), this.returnXmlType, this.returnClass));
        ((Initializable)((Object)this.responseDeserializer)).initialize(this.typeRegistry);
    }

    protected void createLiteralResponseSerializer() throws Exception {
        this.requestSerializer = new ReferenceableSerializerImpl(false, new LiteralFragmentSerializer(this.returnXmlType, true, ""));
    }

    protected JAXRPCDeserializer getFaultDeserializer() {
        return faultDeserializer;
    }

    protected String getEncodingStyle() {
        return (String)this.getRequiredProperty("javax.xml.rpc.encodingstyle.namespace.uri");
    }

    protected DynamicInvocationException serializerNotFoundException(int n, QName qName, Class clazz, QName qName2) {
        Integer n2 = new Integer(n);
        if (clazz == null) {
            if (qName2 == null) {
                return new DynamicInvocationException("dii.parameter.type.underspecified", new Object[]{n2, qName});
            }
            return new DynamicInvocationException("dii.parameter.type.ambiguous.no.class", new Object[]{n2, qName, qName2});
        }
        if (qName2 == null) {
            return new DynamicInvocationException("dii.parameter.type.ambiguous.no.typename", new Object[]{n2, qName, clazz});
        }
        return new DynamicInvocationException("dii.parameter.type.unknown", new Object[]{n2, qName, clazz, qName2});
    }

    protected DynamicInvocationException propertyNotFoundException(String string) {
        return new DynamicInvocationException("dii.required.property.not.set", new Object[]{string});
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("javax.xml.rpc.security.auth.username");
        hashSet.add("javax.xml.rpc.security.auth.password");
        hashSet.add("javax.xml.rpc.endpoint");
        hashSet.add("javax.xml.rpc.soap.operation.style");
        hashSet.add("javax.xml.rpc.soap.http.soapaction.use");
        hashSet.add("javax.xml.rpc.soap.http.soapaction.uri");
        hashSet.add("javax.xml.rpc.session.maintain");
        hashSet.add("javax.xml.rpc.encodingstyle.namespace.uri");
        recognizedProperties = Collections.unmodifiableSet(hashSet);
    }
}

