/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import java.math.BigDecimal;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;

public class DecimalValidator
implements TypeValidator {
    private boolean _isFixed = false;
    private BigDecimal _fixed = null;
    private boolean useMin = false;
    private boolean useMax = false;
    private BigDecimal min = null;
    private BigDecimal max = null;
    private int _totalDigits = -1;
    private int _fractionDigits = -1;

    public void clearMax() {
        this.useMax = false;
    }

    public void clearMin() {
        this.useMin = false;
    }

    public void setMinExclusive(BigDecimal bigDecimal) {
        this.useMin = true;
        this.min = bigDecimal.add(new BigDecimal(1.0));
    }

    public void setMinInclusive(BigDecimal bigDecimal) {
        this.useMin = true;
        this.min = bigDecimal;
    }

    public void setMaxExclusive(BigDecimal bigDecimal) {
        this.useMax = true;
        this.max = bigDecimal.subtract(new BigDecimal(1.0));
    }

    public void setMaxInclusive(BigDecimal bigDecimal) {
        this.useMax = true;
        this.max = bigDecimal;
    }

    public void setTotalDigits(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("DecimalValidator: the totalDigits facet must be positive");
        }
        this._totalDigits = n;
    }

    public void setFractionDigits(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("DecimalValidator: the fractionDigits facet must be positive");
        }
        this._fractionDigits = n;
    }

    public void setFixed(BigDecimal bigDecimal) {
        this._fixed = bigDecimal;
        this._isFixed = true;
    }

    public void validate(BigDecimal bigDecimal) throws ValidationException {
        String string;
        if (this._isFixed && !bigDecimal.equals(this._fixed)) {
            String string2 = bigDecimal + " is not equal to the fixed value of ";
            string2 = string2 + this._fixed;
            throw new ValidationException(string2);
        }
        if (this.useMin && bigDecimal.compareTo(this.min) == -1) {
            String string3 = bigDecimal + " is less than the minimum allowable ";
            string3 = string3 + "value of " + this.min;
            throw new ValidationException(string3);
        }
        if (this.useMax && bigDecimal.compareTo(this.max) == 1) {
            String string4 = bigDecimal + " is greater than the maximum allowable ";
            string4 = string4 + "value of " + this.max;
            throw new ValidationException(string4);
        }
        if (this._totalDigits != -1) {
            int n;
            string = bigDecimal.toString();
            int n2 = n = string.indexOf(46) == -1 ? string.length() : string.length() - 1;
            if (n > this._totalDigits) {
                String string5 = bigDecimal + " doesn't have the correct number of digits, it must be less than or equal to " + this._totalDigits;
                throw new ValidationException(string5);
            }
            string = null;
        }
        if (this._fractionDigits != -1 && bigDecimal.scale() > this._fractionDigits) {
            string = bigDecimal + " doesn't have the correct number of digits in the fraction part: , it must be less than or equal to " + this._fractionDigits;
            throw new ValidationException(string);
        }
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "decimalValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(object.toString());
        }
        catch (Exception exception) {
            String string = "Expecting a decimal, received instead: ";
            string = string + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(bigDecimal);
    }
}

