/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xml.serialize.Serializer;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.BlockList;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.FinalList;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.IdentityConstraint;
import org.exolab.castor.xml.schema.IdentityField;
import org.exolab.castor.xml.schema.IdentitySelector;
import org.exolab.castor.xml.schema.KeyRef;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Union;
import org.exolab.castor.xml.schema.XMLType;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class SchemaWriter {
    private static final String ANNOTATION = "annotation";
    private static final String ATTRIBUTE = "attribute";
    private static final String COMPLEX_TYPE = "complexType";
    private static final String DOCUMENTATION = "documentation";
    private static final String ELEMENT = "element";
    private static final String GROUP = "group";
    private static final String RESTRICTION = "restriction";
    private static final String SCHEMA = "schema";
    private static final String SIMPLE_TYPE = "simpleType";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VALUE = "value";
    private static final String VALUE_FALSE = "false";
    private static final String VALUE_TRUE = "true";
    private static final String CDATA = "CDATA";
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final String XMLNS_DEFAULT = "xmlns";
    private static final String DEFAULT_PREFIX = "xsd";
    private DocumentHandler _handler = null;
    private AttributeListImpl _atts = new AttributeListImpl();
    public static boolean enable = false;

    public SchemaWriter(Writer writer) throws IOException {
        Serializer serializer;
        if (!enable) {
            SchemaWriter.unsupported();
        }
        if ((serializer = Configuration.getSerializer()) == null) {
            throw new IOException("Unable to obtain serailizer");
        }
        serializer.setOutputCharStream(writer);
        DocumentHandler documentHandler = serializer.asDocumentHandler();
        if (documentHandler == null) {
            String string = "The following serializer is not SAX capable: ";
            string = string + serializer.getClass().getName();
            string = string + "; cannot proceed.";
            throw new IOException(string);
        }
        this._handler = documentHandler;
    }

    public SchemaWriter(DocumentHandler documentHandler) {
        if (!enable) {
            SchemaWriter.unsupported();
        }
        if (documentHandler == null) {
            throw new IllegalArgumentException("DocumentHandler must not be null.");
        }
        this._handler = documentHandler;
    }

    private static final void unsupported() {
        String string = "This class is not yet supported.  If you really wish to use it, and you promise not to  complain about unsupported features, then set  SchemaWriter.enable to true, before you attempt to construct  this class.";
        throw new IllegalStateException(string);
    }

    public void write(Schema schema) throws SAXException {
        if (schema == null) {
            throw new IllegalArgumentException("Schema must not be null.");
        }
        this.processSchema(schema);
    }

    private void processAnnotated(Annotated annotated, String string) throws SAXException {
        Enumeration enumeration = annotated.getAnnotations();
        while (enumeration.hasMoreElements()) {
            this.processAnnotation((Annotation)enumeration.nextElement(), string);
        }
    }

    private void processAnnotation(Annotation annotation, String string) throws SAXException {
        this._atts.clear();
        String string2 = string + ANNOTATION;
        this._handler.startElement(string2, this._atts);
        Enumeration enumeration = annotation.getDocumentation();
        String string3 = string + DOCUMENTATION;
        while (enumeration.hasMoreElements()) {
            Documentation documentation = (Documentation)enumeration.nextElement();
            String string4 = documentation.getContent();
            if (string4 == null || string4.length() <= 0) continue;
            char[] cArray = string4.toCharArray();
            this._handler.startElement(string3, this._atts);
            this._handler.characters(cArray, 0, cArray.length);
            this._handler.endElement(string3);
        }
        this._handler.endElement(string2);
    }

    private void processAttribute(AttributeDecl attributeDecl, String string) throws SAXException {
        String string2 = string + ATTRIBUTE;
        this._atts.clear();
        boolean bl = attributeDecl.isReference();
        if (!bl) {
            this._atts.addAttribute(ATTR_NAME, CDATA, attributeDecl.getName());
        } else {
            this._atts.addAttribute("ref", CDATA, attributeDecl.getName(false));
        }
        boolean bl2 = false;
        SimpleType simpleType = attributeDecl.getSimpleType();
        if (!bl) {
            if (simpleType.getName() != null) {
                String string3 = simpleType.getName();
                if (string3.indexOf(58) < 0 && simpleType.isBuiltInType()) {
                    string3 = string + string3;
                }
                this._atts.addAttribute(ATTR_TYPE, CDATA, string3);
            } else {
                bl2 = true;
            }
        }
        if (attributeDecl.isDefault()) {
            this._atts.addAttribute("default", CDATA, attributeDecl.getValue());
        } else if (attributeDecl.isFixed()) {
            this._atts.addAttribute("fixed", CDATA, attributeDecl.getValue());
        }
        if (attributeDecl.getForm() != null) {
            this._atts.addAttribute("form", CDATA, attributeDecl.getForm().toString());
        }
        if (attributeDecl.getId() != null) {
            this._atts.addAttribute("id", CDATA, attributeDecl.getId());
        }
        if (attributeDecl.isRequired()) {
            this._atts.addAttribute("use", CDATA, "required");
        } else if (attributeDecl.isProhibited()) {
            this._atts.addAttribute("use", CDATA, "prohibited");
        }
        this._handler.startElement(string2, this._atts);
        this.processAnnotated(attributeDecl, string);
        if (bl2) {
            this.processSimpleType(simpleType, string);
        }
        this._handler.endElement(string2);
    }

    private void processComplexType(ComplexType complexType, String string) throws SAXException {
        String string2 = string + COMPLEX_TYPE;
        this._atts.clear();
        if (complexType.isTopLevel()) {
            this._atts.addAttribute(ATTR_NAME, CDATA, complexType.getName());
            if (complexType.isAbstract()) {
                this._atts.addAttribute("abstract", CDATA, VALUE_TRUE);
            }
            if (complexType.getBlock() != null) {
                this._atts.addAttribute("block", CDATA, complexType.getBlock().toString());
            }
            if (complexType.getFinal() != null) {
                this._atts.addAttribute("final", CDATA, complexType.getFinal().toString());
            }
        }
        if (complexType.getId() != null) {
            this._atts.addAttribute("id", CDATA, complexType.getId());
        }
        if (complexType.getContentType() == ContentType.mixed) {
            this._atts.addAttribute("mixed", CDATA, VALUE_TRUE);
        }
        this._handler.startElement(string2, this._atts);
        this.processAnnotated(complexType, string);
        String string3 = null;
        String string4 = null;
        XMLType xMLType = complexType.getBaseType();
        if (xMLType != null) {
            string3 = complexType.isSimpleContent() ? string + "simpleContent" : string + "complexContent";
            this._atts.clear();
            if (complexType.isComplexContent() && complexType.getContentType() == ContentType.mixed) {
                this._atts.addAttribute("mixed", CDATA, VALUE_TRUE);
            }
            this._handler.startElement(string3, this._atts);
            string4 = string + complexType.getDerivationMethod();
            this._atts.clear();
            this._atts.addAttribute("base", CDATA, xMLType.getName());
            this._handler.startElement(string4, this._atts);
        }
        this.processContentModelGroup(complexType, string);
        Enumeration enumeration = complexType.getAttributeDecls();
        while (enumeration.hasMoreElements()) {
            this.processAttribute((AttributeDecl)enumeration.nextElement(), string);
        }
        if (xMLType != null) {
            this._handler.endElement(string4);
            this._handler.endElement(string3);
        }
        this._handler.endElement(string2);
    }

    private void processContentModelGroup(ContentModelGroup contentModelGroup, String string) throws SAXException {
        Enumeration enumeration = contentModelGroup.enumerate();
        while (enumeration.hasMoreElements()) {
            Structure structure = (Structure)enumeration.nextElement();
            switch (structure.getStructureType()) {
                case 7: {
                    this.processElement((ElementDecl)structure, string);
                    break;
                }
                case 9: 
                case 14: {
                    this.processGroup((Group)structure, string);
                    break;
                }
            }
        }
    }

    private void processElement(ElementDecl elementDecl, String string) throws SAXException {
        Object object;
        Object object2;
        String string2 = string + ELEMENT;
        this._atts.clear();
        String string3 = elementDecl.getName();
        if (string3 != null) {
            if (elementDecl.isReference()) {
                this._atts.addAttribute("ref", CDATA, string3);
            } else {
                this._atts.addAttribute(ATTR_NAME, CDATA, string3);
            }
        }
        int n = elementDecl.getMaxOccurs();
        int n2 = elementDecl.getMinOccurs();
        if (n2 != 1) {
            this._atts.addAttribute("minOccurs", CDATA, Integer.toString(n2));
        }
        if (n < 0) {
            this._atts.addAttribute("maxOccurs", CDATA, "unbounded");
        } else if (n > 1) {
            this._atts.addAttribute("maxOccurs", CDATA, Integer.toString(n));
        }
        boolean bl = false;
        if (!elementDecl.isReference() && (object2 = elementDecl.getType()) != null) {
            if (((XMLType)object2).getName() == null) {
                bl = true;
            } else if (object2 instanceof SimpleType && ((SimpleType)object2).isBuiltInType()) {
                this._atts.addAttribute(ATTR_TYPE, CDATA, string + ((XMLType)object2).getName());
            } else if (this.isImportedType((XMLType)object2, elementDecl)) {
                object = ((XMLType)object2).getSchema().getTargetNamespace();
                String string4 = this.getNSPrefix(elementDecl.getSchema(), (String)object);
                if (string4 == null) {
                    string4 = string + '2';
                    this._atts.addAttribute(XMLNS_PREFIX + string4, CDATA, (String)object);
                }
                this._atts.addAttribute(ATTR_TYPE, CDATA, string4 + ':' + ((XMLType)object2).getName());
            } else {
                this._atts.addAttribute(ATTR_TYPE, CDATA, ((XMLType)object2).getName());
            }
        }
        if (elementDecl.isAbstract()) {
            this._atts.addAttribute("abstract", CDATA, VALUE_TRUE);
        }
        if (elementDecl.getBlock() != null) {
            this._atts.addAttribute("block", CDATA, elementDecl.getBlock().toString());
        }
        if (elementDecl.getDefaultValue() != null) {
            this._atts.addAttribute("default", CDATA, elementDecl.getDefaultValue());
        }
        if (elementDecl.getFixedValue() != null) {
            this._atts.addAttribute("fixed", CDATA, elementDecl.getFixedValue());
        }
        if (elementDecl.getFinal() != null) {
            this._atts.addAttribute("final", CDATA, elementDecl.getFinal().toString());
        }
        if ((object2 = elementDecl.getForm()) != null) {
            this._atts.addAttribute("form", CDATA, ((Form)object2).toString());
        }
        if (elementDecl.getId() != null) {
            this._atts.addAttribute("id", CDATA, elementDecl.getId());
        }
        if (elementDecl.isNillable()) {
            this._atts.addAttribute("nillable", CDATA, VALUE_TRUE);
        }
        if (elementDecl.getSubstitutionGroup() != null) {
            this._atts.addAttribute("substitutionGroup", CDATA, elementDecl.getSubstitutionGroup());
        }
        this._handler.startElement(string2, this._atts);
        this.processAnnotated(elementDecl, string);
        if (bl && ((XMLType)(object = elementDecl.getType())).isComplexType()) {
            this.processComplexType((ComplexType)object, string);
        }
        object = elementDecl.getIdentityConstraints();
        while (object.hasMoreElements()) {
            this.processIdentityConstraint((IdentityConstraint)object.nextElement(), string);
        }
        this._handler.endElement(string2);
    }

    private void processGroup(Group group, String string) throws SAXException {
        Object object;
        String string2 = string;
        String string3 = null;
        if (group instanceof ModelGroup) {
            ModelGroup modelGroup;
            string2 = string2 + GROUP;
            object = (ModelGroup)group;
            if (((ModelGroup)object).hasReference() && (modelGroup = ((ModelGroup)object).getReference()) != null) {
                string3 = modelGroup.getName();
            }
        } else {
            string2 = string2 + group.getOrder().toString();
        }
        this._atts.clear();
        object = group.getName();
        if (object != null) {
            this._atts.addAttribute(ATTR_NAME, CDATA, (String)object);
        } else if (string3 != null) {
            this._atts.addAttribute("ref", CDATA, string3);
        }
        this._handler.startElement(string2, this._atts);
        this.processAnnotated(group, string);
        this.processContentModelGroup(group, string);
        this._handler.endElement(string2);
    }

    private void processIdentityConstraint(IdentityConstraint identityConstraint, String string) throws SAXException {
        if (identityConstraint == null) {
            return;
        }
        String string2 = string;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        switch (identityConstraint.getStructureType()) {
            case 13: {
                string2 = string2 + "keyref";
                string5 = ((KeyRef)identityConstraint).getRefer();
                break;
            }
            case 21: {
                string2 = string2 + "unique";
                break;
            }
            default: {
                string2 = string2 + "key";
            }
        }
        string3 = identityConstraint.getName();
        string4 = identityConstraint.getId();
        this._atts.clear();
        this._atts.addAttribute(ATTR_NAME, CDATA, identityConstraint.getName());
        if (string4 != null) {
            this._atts.addAttribute("id", CDATA, string4);
        }
        if (string5 != null) {
            this._atts.addAttribute("refer", CDATA, string5);
        }
        this._handler.startElement(string2, this._atts);
        this.processAnnotated(identityConstraint, string);
        String string6 = string + "selector";
        String string7 = null;
        IdentitySelector identitySelector = identityConstraint.getSelector();
        string7 = identitySelector.getXPath();
        string4 = identitySelector.getId();
        this._atts.clear();
        this._atts.addAttribute("xpath", CDATA, string7);
        if (string4 != null) {
            this._atts.addAttribute("id", CDATA, string4);
        }
        this._handler.startElement(string6, this._atts);
        this.processAnnotated(identitySelector, string);
        this._handler.endElement(string6);
        String string8 = string + "field";
        Enumeration enumeration = identityConstraint.getFields();
        while (enumeration.hasMoreElements()) {
            IdentityField identityField = (IdentityField)enumeration.nextElement();
            this._atts.clear();
            string4 = identityField.getId();
            string7 = identityField.getXPath();
            this._atts.addAttribute("xpath", CDATA, string7);
            if (string4 != null) {
                this._atts.addAttribute("id", CDATA, string4);
            }
            this._handler.startElement(string8, this._atts);
            this.processAnnotated(identityField, string);
            this._handler.endElement(string8);
        }
        this._handler.endElement(string2);
    }

    private void processSchema(Schema schema) throws SAXException {
        FinalList finalList;
        BlockList blockList;
        Object object;
        String string;
        String string2 = this.getNSPrefix(schema, schema.getSchemaNamespace());
        if (string2 == null) {
            string2 = DEFAULT_PREFIX;
        }
        this._atts.clear();
        if (string2.length() == 0) {
            this._atts.addAttribute(XMLNS_DEFAULT, CDATA, schema.getSchemaNamespace());
        } else {
            this._atts.addAttribute(XMLNS_PREFIX + string2, CDATA, schema.getSchemaNamespace());
        }
        Enumeration enumeration = schema.getNamespaces().keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.equals(string2)) continue;
            object = (String)schema.getNamespaces().get(string);
            if (string.length() > 0) {
                this._atts.addAttribute(XMLNS_PREFIX + string, CDATA, (String)object);
                continue;
            }
            this._atts.addAttribute(XMLNS_DEFAULT, CDATA, (String)object);
        }
        string = schema.getTargetNamespace();
        if (string != null) {
            this._atts.addAttribute("targetNamespace", CDATA, string);
        }
        if ((object = schema.getAttributeFormDefault()) != null) {
            this._atts.addAttribute("attributeFormDefault", CDATA, ((Form)object).toString());
        }
        if ((object = schema.getElementFormDefault()) != null) {
            this._atts.addAttribute("elementFormDefault", CDATA, ((Form)object).toString());
        }
        if ((blockList = schema.getBlockDefault()) != null) {
            this._atts.addAttribute("blockDefault", CDATA, blockList.toString());
        }
        if ((finalList = schema.getFinalDefault()) != null) {
            this._atts.addAttribute("finalDefault", CDATA, finalList.toString());
        }
        if (string2.length() > 0) {
            string2 = string2 + ':';
        }
        this._handler.startDocument();
        String string3 = string2 + SCHEMA;
        this._handler.startElement(string3, this._atts);
        this.processAnnotated(schema, string2);
        Enumeration enumeration2 = null;
        enumeration2 = schema.getImportedSchema();
        while (enumeration2.hasMoreElements()) {
            this.processImport((Schema)enumeration2.nextElement(), string2);
        }
        enumeration2 = schema.getAttributes();
        while (enumeration2.hasMoreElements()) {
            this.processAttribute((AttributeDecl)enumeration2.nextElement(), string2);
        }
        enumeration2 = schema.getElementDecls();
        while (enumeration2.hasMoreElements()) {
            this.processElement((ElementDecl)enumeration2.nextElement(), string2);
        }
        enumeration2 = schema.getComplexTypes();
        while (enumeration2.hasMoreElements()) {
            this.processComplexType((ComplexType)enumeration2.nextElement(), string2);
        }
        enumeration2 = schema.getModelGroups();
        while (enumeration2.hasMoreElements()) {
            this.processGroup((Group)enumeration2.nextElement(), string2);
        }
        enumeration2 = schema.getSimpleTypes();
        while (enumeration2.hasMoreElements()) {
            this.processSimpleType((SimpleType)enumeration2.nextElement(), string2);
        }
        this._handler.endElement(string3);
        this._handler.endDocument();
    }

    private void processImport(Schema schema, String string) throws SAXException {
        String string2 = string + "import";
        this._atts.clear();
        String string3 = schema.getTargetNamespace();
        String string4 = schema.getSchemaLocation();
        this._atts.addAttribute("namespace", null, string3);
        this._atts.addAttribute("schemaLocation", null, string4);
        this._handler.startElement(string2, this._atts);
        this._handler.endElement(string2);
    }

    private void processSimpleType(SimpleType simpleType, String string) throws SAXException {
        if (simpleType.isBuiltInType()) {
            return;
        }
        String string2 = string + SIMPLE_TYPE;
        this._atts.clear();
        String string3 = simpleType.getName();
        if (string3 != null) {
            this._atts.addAttribute(ATTR_NAME, CDATA, string3);
        }
        this._handler.startElement(string2, this._atts);
        SimpleType simpleType2 = (SimpleType)simpleType.getBaseType();
        if (simpleType2 != null) {
            String string4 = string + RESTRICTION;
            this._atts.clear();
            String string5 = simpleType2.getName();
            if (string5.indexOf(58) < 0 && simpleType2.isBuiltInType()) {
                string5 = string + string5;
            }
            this._atts.addAttribute("base", CDATA, string5);
            this._handler.startElement(string4, this._atts);
            Enumeration enumeration = simpleType.getFacets();
            while (enumeration.hasMoreElements()) {
                Facet facet = (Facet)enumeration.nextElement();
                this._atts.clear();
                this._atts.addAttribute(ATTR_VALUE, CDATA, facet.getValue());
                String string6 = string + facet.getName();
                this._handler.startElement(string6, this._atts);
                this._handler.endElement(string6);
            }
            this._handler.endElement(string4);
        } else if (simpleType instanceof Union) {
            this.processUnion((Union)simpleType, string);
        }
        this._handler.endElement(string2);
    }

    private void processUnion(Union union, String string) throws SAXException {
        Structure structure;
        String string2 = string + "union";
        this._atts.clear();
        if (union.getId() != null) {
            this._atts.addAttribute("id", CDATA, union.getId());
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = union.getMemberTypes();
        while (enumeration.hasMoreElements()) {
            structure = (SimpleType)enumeration.nextElement();
            if (((SimpleType)structure).getParent() != union.getSchema()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(((XMLType)structure).getName());
        }
        if (stringBuffer.length() > 0) {
            this._atts.addAttribute("memberTypes", CDATA, stringBuffer.toString());
        }
        this._handler.startElement(string2, this._atts);
        structure = union.getLocalAnnotation();
        if (structure != null) {
            this.processAnnotation((Annotation)structure, string);
        }
        enumeration = union.getMemberTypes();
        while (enumeration.hasMoreElements()) {
            SimpleType simpleType = (SimpleType)enumeration.nextElement();
            if (simpleType.getParent() == union.getSchema()) continue;
            this.processSimpleType(simpleType, string);
        }
        this._handler.endElement(string2);
    }

    private boolean isImportedType(XMLType xMLType, ElementDecl elementDecl) {
        String string = xMLType.getSchema().getTargetNamespace();
        return elementDecl.getSchema().getImportedSchema(string) != null;
    }

    private String getNSPrefix(Schema schema, String string) {
        Hashtable hashtable = schema.getNamespaces();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            if (string3 == null || !string3.equals(string)) continue;
            return string2;
        }
        return null;
    }
}

