/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class AttributeUnmarshaller
extends SaxUnmarshaller {
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    private AttributeDecl _attribute = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;

    public AttributeUnmarshaller(Schema schema, AttributeList attributeList, Resolver resolver) {
        this._schema = schema;
        this.setResolver(resolver);
        this._attribute = new AttributeDecl(schema);
        String string = attributeList.getValue("ref");
        if (string != null) {
            this._attribute.setReference(string);
        }
        if ((string = attributeList.getValue("name")) != null) {
            if (this._attribute.isReference()) {
                String string2 = "An attribute cannot have a 'name' attribute and a 'ref' attribute at the same time.";
                throw new IllegalStateException(string2);
            }
            this._attribute.setName(string);
        }
        if ((string = attributeList.getValue("default")) != null) {
            this._attribute.setValue(string);
            this._attribute.setDefault();
        }
        this._attribute.setId(attributeList.getValue("id"));
        string = attributeList.getValue("fixed");
        if (string != null) {
            if (this._attribute.isDefault()) {
                throw new IllegalArgumentException("'default' and 'fixed' must not both be present.");
            }
            this._attribute.setValue(string);
            this._attribute.setFixed();
        }
        if ((string = attributeList.getValue("form")) != null) {
            this._attribute.setForm(Form.valueOf(string));
        }
        if ((string = attributeList.getValue("type")) != null) {
            this._attribute.setSimpleTypeReference(string);
        }
        if ((string = attributeList.getValue("use")) != null) {
            if (this._attribute.isDefault() && !string.equals("optional")) {
                throw new IllegalArgumentException("When 'default' is present, the 'use' attribute must have the value 'optional'.");
            }
            this._attribute.setUse(string);
        }
    }

    public String elementName() {
        return "attribute";
    }

    public AttributeDecl getAttribute() {
        return this._attribute;
    }

    public Object getObject() {
        return this.getAttribute();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if ("annotation".equals(string)) {
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation is allowed as a child of an attribute declaration.");
            }
            if (this.foundSimpleType) {
                this.error("An annotation may only appear as the first child of an attribute declaration.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else if ("simpleType".equals(string)) {
            if (this.foundSimpleType) {
                this.error("Only one (1) simpleType is allowed as a child of an attribute declaration.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this._schema, attributeList);
        } else {
            this.illegalElement(string);
        }
    }

    public void endElement(String string) throws SAXException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = (Annotation)this.unmarshaller.getObject();
            this._attribute.addAnnotation(annotation);
        } else if ("simpleType".equals(string)) {
            SimpleType simpleType = ((SimpleTypeUnmarshaller)this.unmarshaller).getSimpleType();
            this._attribute.setSimpleType(simpleType);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

