/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class AttributeGroupUnmarshaller
extends SaxUnmarshaller {
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    private AttributeGroup _attributeGroup = null;
    private boolean allowAnnotations = true;
    private boolean isRef = false;
    private boolean requireName = false;
    private Schema _schema = null;

    /*
     * Enabled aggressive block sorting
     */
    public AttributeGroupUnmarshaller(Schema schema, AttributeList attributeList) throws SAXException {
        this._schema = schema;
        String string = attributeList.getValue("ref");
        if (string == null) {
            AttributeGroupDecl attributeGroupDecl = new AttributeGroupDecl(schema);
            this._attributeGroup = attributeGroupDecl;
            attributeGroupDecl.setName(attributeList.getValue("name"));
            attributeGroupDecl.setId(attributeList.getValue("id"));
            return;
        }
        if (string.length() > 0) {
            this.isRef = true;
            this._attributeGroup = new AttributeGroupReference(schema, string);
            return;
        }
        String string2 = "The value of the 'ref' attribute for attribute group must contain a valid value.";
        throw new SAXException(string2);
    }

    public String elementName() {
        return "attributeGroup";
    }

    public AttributeGroup getAttributeGroup() {
        return this._attributeGroup;
    }

    public Object getObject() {
        return this.getAttributeGroup();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if ("attribute".equals(string)) {
            this.allowAnnotations = false;
            if (this.isRef) {
                this.error("AttributeGroup references may not have children.");
            }
            this.unmarshaller = new AttributeUnmarshaller(this._schema, attributeList, this.getResolver());
        } else if ("attributeGroup".equals(string)) {
            this.allowAnnotations = false;
            if (this.isRef) {
                this.error("AttributeGroup references may not have children.");
            }
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, attributeList);
        } else if (string.equals("annotation")) {
            if (!this.allowAnnotations) {
                this.outOfOrder(string);
            }
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String string) throws SAXException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("attribute".equals(string)) {
            AttributeDecl attributeDecl = ((AttributeUnmarshaller)this.unmarshaller).getAttribute();
            ((AttributeGroupDecl)this._attributeGroup).addAttribute(attributeDecl);
        } else if ("attributeGroup".equals(string)) {
            Object object = this.unmarshaller.getObject();
            try {
                ((AttributeGroupDecl)this._attributeGroup).addReference((AttributeGroupReference)object);
            }
            catch (ClassCastException classCastException) {
                String string2 = "AttributeGroups cannot contain new AttributeGroup definitions, only references to top-level AttributeGroups are allowed.";
                this.error(string2);
            }
        } else if ("annotation".equals(string)) {
            Annotation annotation = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._attributeGroup.addAnnotation(annotation);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

