/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public final class XSInt
extends XSPatternBase {
    Integer maxInclusive = null;
    Integer maxExclusive = null;
    Integer minInclusive = null;
    Integer minExclusive = null;
    private static JType jType = JType.Int;

    public XSInt() {
        this(SourceGenerator.usePrimitiveWrapper());
    }

    public XSInt(boolean bl) {
        super((short)36);
        jType = bl ? new JClass("java.lang.Integer") : JType.Int;
    }

    public JType getJType() {
        return jType;
    }

    public Integer getMaxExclusive() {
        return this.maxExclusive;
    }

    public Integer getMaxInclusive() {
        return this.maxInclusive;
    }

    public Integer getMinExclusive() {
        return this.minExclusive;
    }

    public Integer getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(int n) {
        this.maxExclusive = new Integer(n);
        this.maxInclusive = null;
    }

    public void setMaxExclusive(Integer n) {
        this.maxExclusive = n;
        this.maxInclusive = null;
    }

    public void setMaxInclusive(int n) {
        this.maxInclusive = new Integer(n);
        this.maxExclusive = null;
    }

    public void setMaxInclusive(Integer n) {
        this.maxInclusive = n;
        this.maxExclusive = null;
    }

    public void setMinExclusive(int n) {
        this.minExclusive = new Integer(n);
        this.minInclusive = null;
    }

    public void setMinExclusive(Integer n) {
        this.minExclusive = n;
        this.minInclusive = null;
    }

    public void setMinInclusive(int n) {
        this.minInclusive = new Integer(n);
        this.minExclusive = null;
    }

    public void setMinInclusive(Integer n) {
        this.minInclusive = n;
        this.minExclusive = null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            if ("maxExclusive".equals(string)) {
                this.setMaxExclusive(facet.toInt());
                continue;
            }
            if ("maxInclusive".equals(string)) {
                this.setMaxInclusive(facet.toInt());
                continue;
            }
            if ("minExclusive".equals(string)) {
                this.setMinExclusive(facet.toInt());
                continue;
            }
            if ("minInclusive".equals(string)) {
                this.setMinInclusive(facet.toInt());
                continue;
            }
            if (!"pattern".equals(string)) continue;
            this.setPattern(facet.getValue());
        }
    }

    public String createToJavaObjectCode(String string) {
        if (SourceGenerator.usePrimitiveWrapper()) {
            return super.createToJavaObjectCode(string);
        }
        StringBuffer stringBuffer = new StringBuffer("new Integer(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String createFromJavaObjectCode(String string) {
        StringBuffer stringBuffer = new StringBuffer("((Integer)");
        stringBuffer.append(string);
        stringBuffer.append(").intValue()");
        return stringBuffer.toString();
    }
}

