/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.ClassInfoResolver;
import org.exolab.castor.builder.CollectionInfo;
import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.TypeConversion;
import org.exolab.castor.builder.XMLInfo;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public class MemberFactory {
    private FieldInfoFactory infoFactory = null;

    public MemberFactory() {
        this(new FieldInfoFactory());
    }

    public MemberFactory(FieldInfoFactory fieldInfoFactory) {
        this.infoFactory = fieldInfoFactory == null ? new FieldInfoFactory() : fieldInfoFactory;
    }

    public FieldInfo createFieldInfoForAny() {
        XSClass xSClass = new XSClass(SGTypes.Object, "any");
        String string = "_anyObject";
        String string2 = null;
        CollectionInfo collectionInfo = this.infoFactory.createCollection(xSClass, string, "anyObject");
        XSList xSList = collectionInfo.getXSList();
        xSList.setMinimumSize(0);
        collectionInfo.setRequired(false);
        collectionInfo.setNodeName(string2);
        return collectionInfo;
    }

    public FieldInfo createFieldInfoForContent(XSType xSType) {
        String string = "_content";
        FieldInfo fieldInfo = this.infoFactory.createFieldInfo(xSType, string);
        fieldInfo.setNodeType((short)3);
        fieldInfo.setComment("internal content storage");
        fieldInfo.setRequired(false);
        fieldInfo.setNodeName("#text");
        if (xSType instanceof XSString) {
            fieldInfo.setDefaultValue("\"\"");
        }
        return fieldInfo;
    }

    public FieldInfo createFieldInfo(AttributeDecl attributeDecl, ClassInfoResolver classInfoResolver) {
        String string;
        String string2 = JavaNaming.toJavaMemberName(attributeDecl.getName(false));
        if (!string2.startsWith("_")) {
            string2 = "_" + string2;
        }
        FieldInfo fieldInfo = null;
        SimpleType simpleType = attributeDecl.getSimpleType();
        XSType xSType = null;
        ClassInfo classInfo = null;
        boolean bl = false;
        if (simpleType != null) {
            if (simpleType.hasFacet("enumeration")) {
                bl = true;
                if (classInfoResolver != null) {
                    classInfo = classInfoResolver.resolve(simpleType);
                }
                if (classInfo != null) {
                    xSType = classInfo.getSchemaType();
                }
            }
            if (xSType == null) {
                xSType = TypeConversion.convertType(simpleType);
            }
        } else {
            xSType = new XSString();
        }
        switch (xSType.getType()) {
            case 32: {
                fieldInfo = this.infoFactory.createFieldInfo(xSType, string2);
                break;
            }
            case 25: {
                fieldInfo = this.infoFactory.createIdentity(string2);
                break;
            }
            case 45: {
                fieldInfo = this.infoFactory.createCollection(((XSList)xSType).getContentType(), string2, attributeDecl.getName());
                break;
            }
            default: {
                fieldInfo = this.infoFactory.createFieldInfo(xSType, string2);
            }
        }
        fieldInfo.setNodeName(attributeDecl.getName());
        fieldInfo.setNodeType((short)0);
        fieldInfo.setRequired(attributeDecl.isRequired());
        String string3 = attributeDecl.getValue();
        if (string3 != null) {
            if (string3.length() == 0) {
                string3 = "\"\"";
            }
            if (xSType.getJType().toString().equals("java.lang.String")) {
                char c = string3.charAt(0);
                switch (c) {
                    case '\"': 
                    case '\'': {
                        break;
                    }
                    default: {
                        string3 = '\"' + string3 + '\"';
                        break;
                    }
                }
            } else if (bl) {
                JClass jClass = classInfo.getJClass();
                String string4 = jClass.getName() + ".valueOf(\"" + string3;
                string3 = string4 = string4 + "\");";
            } else if (!xSType.getJType().isPrimitive()) {
                string3 = "new " + xSType.getJType().toString() + "(\"" + string3 + "\")";
            }
            if (attributeDecl.isFixed()) {
                fieldInfo.setFixedValue(string3);
            } else {
                fieldInfo.setDefaultValue(string3);
            }
        }
        if ((string = this.createComment(attributeDecl)) != null) {
            fieldInfo.setComment(string);
        }
        return fieldInfo;
    }

    public FieldInfo createFieldInfo(ElementDecl elementDecl, ClassInfoResolver classInfoResolver) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ElementDecl elementDecl2;
        int n = elementDecl.getMaxOccurs();
        int n2 = elementDecl.getMinOccurs();
        ElementDecl elementDecl3 = elementDecl;
        ClassInfo classInfo = null;
        if (elementDecl3.isReference()) {
            elementDecl2 = elementDecl3.getReference();
            if (elementDecl2 == null) {
                String string = "unable to resolve element reference: ";
                string = string + elementDecl.getName();
                System.out.println(string);
                return null;
            }
            if (SourceGenerator.mappingSchemaElement2Java()) {
                elementDecl3 = elementDecl2;
            }
            elementDecl2 = null;
        }
        elementDecl2 = null;
        Object object5 = null;
        XSType xSType = null;
        XMLType xMLType = elementDecl3.getType();
        boolean bl = false;
        boolean bl2 = false;
        if (xMLType != null && xMLType.isSimpleType()) {
            object4 = (SimpleType)xMLType;
            if (((SimpleType)object4).hasFacet("enumeration")) {
                bl = true;
                if (classInfoResolver != null) {
                    classInfo = classInfoResolver.resolve(object4);
                }
                if (classInfo != null) {
                    xSType = classInfo.getSchemaType();
                }
            }
            if (xSType == null) {
                xSType = TypeConversion.convertType((SimpleType)object4);
            }
            if (xSType.getType() == 25 || xSType.getType() == 27 || xSType.getType() == 45 && ((XSList)xSType).getContentType().getType() == 26 || xSType.getType() == 30) {
                System.out.println("Warning : For XML Compatibility " + xSType.getName() + " should be used only on attributes\n");
            }
        } else {
            int n3;
            object4 = null;
            if (SourceGenerator.mappingSchemaElement2Java()) {
                object4 = JavaNaming.toJavaClassName(elementDecl3.getName());
                if (object4 == null) {
                    return null;
                }
                object3 = SourceGenerator.getJavaPackage(elementDecl3.getSchema().getTargetNamespace());
                if (object3 != null && ((String)object3).length() > 0) {
                    object4 = (String)object3 + '.' + (String)object4;
                }
                object3 = null;
            } else if (SourceGenerator.mappingSchemaType2Java()) {
                object4 = JavaNaming.toJavaClassName(this.getElementType(elementDecl3));
                if (elementDecl3.getType() != null && (object3 = elementDecl3.getSchema()) != (object2 = elementDecl3.getType().getSchema())) {
                    object4 = SourceGenerator.getQualifiedClassName(((Schema)object2).getTargetNamespace(), (String)object4);
                }
            }
            xSType = new XSClass(new JClass((String)object4));
            if (xMLType == null || !xMLType.isComplexType() || (n3 = ((ComplexType)(object3 = (ComplexType)xMLType)).getMaxOccurs()) < 0 || n3 > 1) {
                // empty if block
            }
        }
        if (((String)(object4 = JavaNaming.toJavaMemberName(elementDecl3.getName(false)))).charAt(0) != '_') {
            object4 = "_" + (String)object4;
        }
        if (n != 1) {
            object3 = (String)object4 + "List";
            object2 = this.infoFactory.createCollection(xSType, (String)object3, elementDecl3.getName(false));
            object = ((CollectionInfo)object2).getXSList();
            ((XSList)object).setMaximumSize(n);
            ((XSList)object).setMinimumSize(n2);
            object5 = object2;
        } else {
            object5 = xSType.getType() == 45 ? this.infoFactory.createCollection(((XSList)xSType).getContentType(), (String)object4, elementDecl3.getName(false)) : this.infoFactory.createFieldInfo(xSType, (String)object4);
        }
        ((XMLInfo)object5).setRequired(n2 > 0);
        ((XMLInfo)object5).setNodeName(elementDecl3.getName(false));
        ((FieldInfo)object5).setContainer(bl2);
        Object object6 = object3 = elementDecl3.getDefaultValue() != null ? elementDecl3.getDefaultValue() : elementDecl3.getFixedValue();
        if (object3 != null) {
            if (((String)object3).length() == 0) {
                object3 = "\"\"";
            }
            if (xSType.getJType().toString().equals("java.lang.String")) {
                char c = ((String)object3).charAt(0);
                switch (c) {
                    case '\"': 
                    case '\'': {
                        break;
                    }
                    default: {
                        object3 = '\"' + (String)object3 + '\"';
                        break;
                    }
                }
            } else if (bl) {
                object2 = classInfo.getJClass();
                object = ((JType)object2).getName() + ".valueOf(\"" + (String)object3;
                object3 = object = (String)object + "\");";
            } else if (!xSType.getJType().isPrimitive()) {
                object3 = "new " + xSType.getJType().toString() + "(\"" + (String)object3 + "\")";
            }
            if (elementDecl3.getFixedValue() != null) {
                ((FieldInfo)object5).setFixedValue((String)object3);
            } else {
                ((FieldInfo)object5).setDefaultValue((String)object3);
            }
        }
        String string = null;
        object = elementDecl.getAnnotations();
        string = object.hasMoreElements() ? this.createComment((Annotation)object.nextElement()) : this.createComment(elementDecl3);
        if (string != null) {
            ((FieldInfo)object5).setComment(string);
        }
        return object5;
    }

    public FieldInfo createFieldInfo(Group group, SGStateInfo sGStateInfo) {
        String string;
        String string2 = group.getName();
        if (string2 == null && (string2 = sGStateInfo.getGroupNaming().createClassName(group)) == null) {
            String string3 = "Unable to create name for group";
            throw new IllegalStateException(string3);
        }
        int n = group.getMaxOccurs();
        int n2 = group.getMinOccurs();
        Object var6_7 = null;
        FieldInfo fieldInfo = null;
        XSType xSType = null;
        JClass jClass = null;
        String string4 = null;
        ClassInfo classInfo = sGStateInfo.resolve(group);
        if (classInfo != null) {
            jClass = classInfo.getJClass();
            xSType = classInfo.getSchemaType();
        }
        if (jClass == null) {
            string4 = JavaNaming.toJavaClassName(string2);
            xSType = new XSClass(new JClass(string4));
        } else {
            string4 = jClass.getName();
        }
        String string5 = JavaNaming.toJavaMemberName(string4);
        if (string5.charAt(0) != '_') {
            string5 = "_" + string5;
        }
        if (n != 1) {
            string = string5 + "List";
            CollectionInfo collectionInfo = this.infoFactory.createCollection(xSType, string, string2);
            XSList xSList = collectionInfo.getXSList();
            xSList.setMaximumSize(n);
            xSList.setMinimumSize(n2);
            fieldInfo = collectionInfo;
        } else {
            fieldInfo = this.infoFactory.createFieldInfo(xSType, string5);
        }
        fieldInfo.setRequired(n2 > 0);
        fieldInfo.setNodeName("-error-if-this-is-used-");
        fieldInfo.setContainer(true);
        string = null;
        string = this.createComment(group);
        if (string != null) {
            fieldInfo.setComment(string);
        }
        return fieldInfo;
    }

    private String getElementType(ElementDecl elementDecl) {
        ElementDecl elementDecl2 = elementDecl;
        Hashtable<String, ElementDecl> hashtable = new Hashtable<String, ElementDecl>();
        String string = null;
        while (string == null) {
            Object object;
            if (elementDecl.isReference()) {
                elementDecl = elementDecl.getReference();
            }
            if (elementDecl == null) {
                object = "unable to resolve element reference: ";
                object = (String)object + elementDecl2.getName(false);
                System.out.println((String)object);
                return null;
            }
            if (hashtable.get(elementDecl.getName()) != null) {
                object = "cyclic element reference: ";
                object = (String)object + elementDecl2.getName(false);
                System.out.println((String)object);
                return null;
            }
            hashtable.put(elementDecl.getName(), elementDecl);
            if (elementDecl.isReference()) continue;
            object = elementDecl.getType();
            if (object != null) {
                string = ((XMLType)object).getName();
            }
            if (string != null) continue;
            string = elementDecl.getName(false);
        }
        return string;
    }

    private String createComment(Annotated annotated) {
        Enumeration enumeration = annotated.getAnnotations();
        if (enumeration.hasMoreElements()) {
            return this.createComment((Annotation)enumeration.nextElement());
        }
        return null;
    }

    private String createComment(Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        Enumeration enumeration = annotation.getDocumentation();
        if (enumeration.hasMoreElements()) {
            Documentation documentation = (Documentation)enumeration.nextElement();
            return documentation.getContent();
        }
        return null;
    }
}

