/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.ant;

import com.sun.xml.rpc.tools.xrpcc.XrpccCompile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Xrpcc
extends MatchingTask {
    protected boolean both = true;
    protected Path compileClasspath = null;
    protected boolean client = false;
    private File baseDir = null;
    private File sourceBase;
    private boolean debug = false;
    private boolean keep = false;
    private boolean noWarn = false;
    protected boolean server = false;
    protected boolean verbose = false;
    protected boolean version = false;
    private String XActionsFile = null;
    protected boolean xDHOnly = false;
    protected boolean xExplicitContext = false;
    private String HTTPProxyURL = null;
    private URL proxyURL = null;
    protected boolean xImport = false;
    protected boolean xModel = false;
    private String xModelFile = null;
    protected boolean xNoCompile = false;
    protected boolean xNoDataBinding = false;
    protected boolean xNoEncodedTypes = false;
    protected boolean xNoMultiRefs = false;
    protected boolean xNoValidation = false;
    protected boolean xPrintStackTrace = false;
    protected boolean xSerializeIF = false;
    protected boolean xSearchSchema = false;
    private String XMLModelFile = null;
    private File config;
    private boolean includeAntRuntime = false;
    private boolean includeJavaRuntime = false;

    public boolean getBoth() {
        return this.both;
    }

    public void setBoth(boolean bl) {
        this.both = bl;
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setClasspath(Path path) {
        if (this.compileClasspath == null) {
            this.compileClasspath = path;
        } else {
            this.compileClasspath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public boolean getClient() {
        return this.client;
    }

    public void setClient(boolean bl) {
        this.client = bl;
        this.setBoth(false);
    }

    public File getBase() {
        return this.baseDir;
    }

    public void setBase(File file) {
        this.baseDir = file;
    }

    public void setSourceBase(File file) {
        this.keep = true;
        this.sourceBase = file;
    }

    public File getSourceBase() {
        return this.sourceBase;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getKeep() {
        return this.keep;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public boolean getNoWarn() {
        return this.noWarn;
    }

    public void setNoWarn(boolean bl) {
        this.noWarn = bl;
    }

    public boolean getServer() {
        return this.server;
    }

    public void setServer(boolean bl) {
        this.server = bl;
        this.setBoth(false);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getVersion() {
        return this.version;
    }

    public void setVersion(boolean bl) {
        this.version = bl;
    }

    public String getXActionsFile() {
        return this.XActionsFile;
    }

    public void setXActionsFile(String string) {
        this.XActionsFile = string;
    }

    public boolean getXDataHandlerOnly() {
        return this.xDHOnly;
    }

    public void setXDataHandlerOnly(boolean bl) {
        this.xDHOnly = bl;
    }

    public boolean getXExplicitContext() {
        return this.xExplicitContext;
    }

    public void setXExplicitContext(boolean bl) {
        this.xExplicitContext = bl;
    }

    public String getXHTTPProxy() {
        return this.HTTPProxyURL;
    }

    public void setXHTTPProxy(String string) {
        if (string != null && !string.equals("")) {
            this.HTTPProxyURL = string.startsWith("http://") ? string : "http://" + string;
            try {
                URL uRL = new URL(this.HTTPProxyURL);
                this.setProxyServer(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                throw new Error("Invalid HTTP URL specified: " + this.HTTPProxyURL);
            }
        }
    }

    public URL getProxyServer() {
        return this.proxyURL;
    }

    public void setProxyServer(URL uRL) {
        this.proxyURL = uRL;
    }

    public boolean getXImport() {
        return this.xImport;
    }

    public void setXImport(boolean bl) {
        this.xImport = bl;
    }

    public boolean getXModel() {
        return this.xModel;
    }

    public void setXModel(boolean bl) {
        this.xModel = bl;
    }

    public String getXModelFile() {
        return this.xModelFile;
    }

    public void setXModelFile(String string) {
        this.xModelFile = string;
        this.setXModel(true);
    }

    public boolean getXNoCompile() {
        return this.xNoCompile;
    }

    public void setXNoCompile(boolean bl) {
        this.xNoCompile = bl;
    }

    public boolean getXNoDataBinding() {
        return this.xNoDataBinding;
    }

    public void setXNoDataBinding(boolean bl) {
        this.xNoDataBinding = bl;
    }

    public boolean getXNoEncodedTypes() {
        return this.xNoEncodedTypes;
    }

    public void setXNoEncodedTypes(boolean bl) {
        this.xNoEncodedTypes = bl;
    }

    public boolean getXNoMultiRefs() {
        return this.xNoMultiRefs;
    }

    public void setXNoMultiRefs(boolean bl) {
        this.xNoMultiRefs = bl;
    }

    public boolean getXNoValidation() {
        return this.xNoValidation;
    }

    public void setXNoValidation(boolean bl) {
        this.xNoValidation = bl;
    }

    public boolean getXPrintStackTrace() {
        return this.xPrintStackTrace;
    }

    public void setXPrintStackTrace(boolean bl) {
        this.xPrintStackTrace = bl;
    }

    public boolean getXSerializeInterfaces() {
        return this.xSerializeIF;
    }

    public void setXSerializeInterfaces(boolean bl) {
        this.xSerializeIF = bl;
    }

    public boolean getXSearchSchema() {
        return this.xSearchSchema;
    }

    public void setXSearchSchema(boolean bl) {
        this.xSearchSchema = bl;
    }

    public String getXMLModelFile() {
        return this.XMLModelFile;
    }

    public void setXMLModelFile(String string) {
        this.XMLModelFile = string;
    }

    public File getConfig() {
        return this.config;
    }

    public void setConfig(File file) {
        this.config = file;
    }

    public void setIncludeantruntime(boolean bl) {
        this.includeAntRuntime = bl;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean bl) {
        this.includeJavaRuntime = bl;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    private Path generateCompileClasspath() {
        Path path = new Path(this.getProject());
        if (this.getClasspath() == null) {
            if (this.getIncludeantruntime()) {
                path.addExisting(Path.systemClasspath);
            }
        } else if (this.getIncludeantruntime()) {
            path.addExisting(this.getClasspath().concatSystemClasspath("last"));
        } else {
            path.addExisting(this.getClasspath().concatSystemClasspath("ignore"));
        }
        if (this.getIncludejavaruntime()) {
            path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
            path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
        }
        return path;
    }

    private Commandline setupXrpccCommand(String[] stringArray) {
        String string;
        Commandline commandline = new Commandline();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                commandline.createArgument().setValue(stringArray[n]);
                ++n;
            }
        }
        if (this.getBoth()) {
            commandline.createArgument().setValue("-both");
        } else if (this.getClient()) {
            commandline.createArgument().setValue("-client");
        } else if (this.getServer()) {
            commandline.createArgument().setValue("-server");
        }
        Path path = this.getClasspath();
        if (path != null && !path.toString().equals("")) {
            commandline.createArgument().setValue("-classpath");
            commandline.createArgument().setPath(path);
        }
        if (null != this.getBase() && !this.getBase().equals("")) {
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setFile(this.getBase());
        }
        if (null != this.getSourceBase() && !this.getSourceBase().equals("")) {
            commandline.createArgument().setValue("-s");
            commandline.createArgument().setFile(this.getSourceBase());
        }
        if (this.getDebug()) {
            commandline.createArgument().setValue("-g");
        }
        if (this.getKeep()) {
            commandline.createArgument().setValue("-keep");
        }
        if (this.getNoWarn()) {
            commandline.createArgument().setValue("-nowarn");
        }
        if (this.getVerbose()) {
            commandline.createArgument().setValue("-verbose");
        }
        if (this.getVersion()) {
            commandline.createArgument().setValue("-version");
        }
        if (this.getXActionsFile() != null && !this.getXActionsFile().equals("")) {
            commandline.createArgument().setValue("-Xactions:" + this.getXActionsFile());
        }
        if (this.getXDataHandlerOnly()) {
            commandline.createArgument().setValue("-Xdatahandleronly");
        }
        if (this.getXExplicitContext()) {
            commandline.createArgument().setValue("-Xexplicitcontext");
        }
        if (this.getProxyServer() != null && (string = this.getProxyServer().getHost()) != null && !string.equals("")) {
            String string2 = "-Xhttpproxy:" + string;
            if (this.getProxyServer().getPort() != -1) {
                string2 = string2 + ":" + this.getProxyServer().getPort();
            }
            commandline.createArgument().setValue(string2);
        }
        if (this.getXImport()) {
            commandline.createArgument().setValue("-Ximport");
        }
        if (this.getXModel()) {
            string = "-Xmodel";
            if (this.getXModelFile() != null && !this.getXModelFile().equals("")) {
                string = string + ":" + this.getXModelFile();
            }
            commandline.createArgument().setValue(string);
        }
        if (this.getXNoCompile()) {
            commandline.createArgument().setValue("-Xnocompile");
        }
        if (this.getXNoDataBinding()) {
            commandline.createArgument().setValue("-Xnodatabinding");
        }
        if (this.getXNoEncodedTypes()) {
            commandline.createArgument().setValue("-Xnoencodedtypes");
        }
        if (this.getXNoMultiRefs()) {
            commandline.createArgument().setValue("-Xnomultirefs");
        }
        if (this.getXNoValidation()) {
            commandline.createArgument().setValue("-Xnovalidation");
        }
        if (this.getXPrintStackTrace()) {
            commandline.createArgument().setValue("-Xprintstacktrace");
        }
        if (this.getXSerializeInterfaces()) {
            commandline.createArgument().setValue("-Xserializeinterfaces");
        }
        if (this.getXSearchSchema()) {
            commandline.createArgument().setValue("-Xsearchschema");
        }
        if (this.getXMLModelFile() != null && !this.getXMLModelFile().equals("")) {
            commandline.createArgument().setValue("-Xxmodel:" + this.getXMLModelFile());
        }
        commandline.createArgument().setValue(this.config.toString());
        return commandline;
    }

    private Commandline setupXrpccCommand() {
        return this.setupXrpccCommand(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (!this.getVersion()) {
            if (this.getConfig() == null) throw new BuildException("xrpcc config file does not exist!", this.location);
            if (!this.getConfig().exists()) {
                throw new BuildException("xrpcc config file does not exist!", this.location);
            }
        }
        Commandline commandline = this.setupXrpccCommand();
        if (this.verbose) {
            this.log("command line: xrpcc " + commandline.toString());
        }
        LogOutputStream logOutputStream = new LogOutputStream((Task)this, 1);
        try {
            try {
                XrpccCompile xrpccCompile = new XrpccCompile((OutputStream)logOutputStream, "xrpcc");
                boolean bl = xrpccCompile.compile(commandline.getArguments());
                if (!bl) {
                    if (this.verbose) throw new BuildException("xrpcc failed", this.location);
                    this.log("Command invoked: xrpcc " + commandline.toString());
                    throw new BuildException("xrpcc failed", this.location);
                }
                Object var6_6 = null;
            }
            catch (Exception exception) {
                if (!(exception instanceof BuildException)) throw new BuildException("Error starting xrpcc: ", (Throwable)exception, this.getLocation());
                throw (BuildException)exception;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                logOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
        try {}
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        logOutputStream.close();
    }
}

