/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.encoding.InternalEncodingConstants;
import com.sun.xml.rpc.processor.config.ImportedDocumentInfo;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.SOAPObjectSerializerGenerator;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationEntry;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.sun.xml.rpc.processor.modeler.rmi.SOAPSimpleTypeCreator;
import com.sun.xml.rpc.wsdl.document.Definitions;
import com.sun.xml.rpc.wsdl.document.Import;
import com.sun.xml.rpc.wsdl.document.Types;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.WSDLDocument;
import com.sun.xml.rpc.wsdl.document.schema.Schema;
import com.sun.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.document.soap.SOAPConstants;
import com.sun.xml.rpc.wsdl.framework.Extension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class WSDLTypeGenerator {
    private Model model;
    private WSDLDocument document;
    private Definitions definitions;
    private Set generatedTypes;
    private Map nsSchemaMap;
    private Set actuallyImportedDocuments;
    private SOAPSimpleTypeCreator soapTypes;

    public WSDLTypeGenerator(Model model, WSDLDocument wSDLDocument) {
        this.model = model;
        this.document = wSDLDocument;
        this.definitions = wSDLDocument.getDefinitions();
        this.generatedTypes = new HashSet();
        this.nsSchemaMap = new HashMap();
        this.actuallyImportedDocuments = new HashSet();
        this.soapTypes = new SOAPSimpleTypeCreator();
    }

    public void run() throws Exception {
        Object object;
        Iterator iterator;
        Object object2;
        Iterator iterator2;
        Object object3;
        Object object4;
        Object object5;
        Types types = new Types();
        Iterator iterator3 = this.model.getServices();
        while (iterator3.hasNext()) {
            object5 = (Service)iterator3.next();
            object4 = ((Service)object5).getPorts();
            while (object4.hasNext()) {
                object3 = (Port)object4.next();
                iterator2 = ((Port)object3).getOperations();
                while (iterator2.hasNext()) {
                    object2 = (Operation)iterator2.next();
                    this.processTypesInMessage(((Operation)object2).getRequest());
                    this.processTypesInMessage(((Operation)object2).getResponse());
                    iterator = ((Operation)object2).getAllFaults();
                    while (iterator != null && iterator.hasNext()) {
                        object = (Fault)iterator.next();
                        this.processFault((Fault)object);
                    }
                }
            }
        }
        object5 = this.model.getExtraTypes();
        while (object5.hasNext()) {
            this.processType((AbstractType)object5.next());
        }
        object4 = new ArrayList();
        object3 = this.actuallyImportedDocuments.iterator();
        while (object3.hasNext()) {
            iterator2 = (ImportedDocumentInfo)object3.next();
            object2 = new Import();
            ((Import)object2).setNamespace(((ImportedDocumentInfo)((Object)iterator2)).getNamespace());
            ((Import)object2).setLocation(((ImportedDocumentInfo)((Object)iterator2)).getLocation());
            this.definitions.add((Import)object2);
            object4.add(0, iterator2);
        }
        iterator2 = this.nsSchemaMap.values().iterator();
        while (iterator2.hasNext()) {
            Object object6;
            Object object7;
            object2 = (Schema)iterator2.next();
            iterator = ((Schema)object2).definedEntities();
            if (!iterator.hasNext()) continue;
            object = ((Schema)object2).getContent();
            Iterator iterator4 = object4.iterator();
            while (iterator4.hasNext()) {
                object7 = (ImportedDocumentInfo)iterator4.next();
                object6 = new SchemaElement(SchemaConstants.QNAME_IMPORT);
                ((SchemaElement)object6).addAttribute("namespace", ((ImportedDocumentInfo)object7).getNamespace());
                ((SchemaElement)object6).addAttribute("schemaLocation", ((ImportedDocumentInfo)object7).getLocation());
                ((SchemaElement)object).insertChildAtTop((SchemaElement)object6);
            }
            object7 = this.nsSchemaMap.keySet().iterator();
            while (object7.hasNext()) {
                Schema schema;
                Iterator iterator5;
                object6 = (String)object7.next();
                if (((Schema)object2).getTargetNamespaceURI().equals(object6) || !(iterator5 = (schema = (Schema)this.nsSchemaMap.get(object6)).definedEntities()).hasNext()) continue;
                SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_IMPORT);
                schemaElement.addAttribute("namespace", (String)object6);
                ((SchemaElement)object).insertChildAtTop(schemaElement);
            }
            object6 = new SchemaElement(SchemaConstants.QNAME_IMPORT);
            ((SchemaElement)object6).addAttribute("namespace", "http://schemas.xmlsoap.org/soap/encoding/");
            ((SchemaElement)object).insertChildAtTop((SchemaElement)object6);
            types.addExtension((Extension)object2);
        }
        this.definitions.setTypes(types);
    }

    private void processTypesInMessage(Message message) throws Exception {
        Object object;
        Object object2;
        if (message == null) {
            return;
        }
        Iterator iterator = message.getBodyBlocks();
        while (iterator.hasNext()) {
            object2 = (Block)iterator.next();
            object = ((Block)object2).getType();
            this.processType((AbstractType)object);
        }
        object2 = message.getHeaderBlocks();
        while (object2.hasNext()) {
            object = (Block)object2.next();
            AbstractType abstractType = ((Block)object).getType();
            this.processType(abstractType);
        }
    }

    private void processType(AbstractType abstractType) throws Exception {
        if (!(abstractType instanceof RPCRequestOrderedStructureType || abstractType instanceof RPCRequestOrderedStructureType || abstractType instanceof RPCResponseStructureType || abstractType.getName() != null && !this.generatedTypes.contains(abstractType.getName()))) {
            return;
        }
        if (abstractType.getName().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || abstractType.getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return;
        }
        ImportedDocumentInfo importedDocumentInfo = this.model.getImportedDocument(abstractType.getName().getNamespaceURI());
        if (importedDocumentInfo != null && importedDocumentInfo.getType() == 1) {
            this.actuallyImportedDocuments.add(importedDocumentInfo);
            return;
        }
        Schema schema = (Schema)this.nsSchemaMap.get(abstractType.getName().getNamespaceURI());
        if (schema == null) {
            schema = new Schema(this.document);
            schema.setTargetNamespaceURI(abstractType.getName().getNamespaceURI());
            SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_SCHEMA);
            schemaElement.addAttribute("targetNamespace", schema.getTargetNamespaceURI());
            schemaElement.addPrefix("", "http://www.w3.org/2001/XMLSchema");
            schemaElement.addPrefix("wsdl", "http://schemas.xmlsoap.org/wsdl/");
            schemaElement.addPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            schemaElement.addPrefix("soap-enc", "http://schemas.xmlsoap.org/soap/encoding/");
            schemaElement.addPrefix("tns", schema.getTargetNamespaceURI());
            schema.setContent(schemaElement);
            this.nsSchemaMap.put(abstractType.getName().getNamespaceURI(), schema);
        }
        if (abstractType.isLiteralType()) {
            throw new GeneratorException("generator.literalTypesNotSupported", new Object[]{abstractType.getName().getLocalPart(), abstractType.getName().getNamespaceURI()});
        }
        this.generatedTypes.add(abstractType.getName());
        this.processType((SOAPType)abstractType, schema);
    }

    private void processType(SOAPType sOAPType, final Schema schema) throws Exception {
        sOAPType.accept(new SOAPTypeVisitor(){

            public void visit(SOAPArrayType sOAPArrayType) throws Exception {
                SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(schemaElement);
                schemaElement.addAttribute("name", sOAPArrayType.getName().getLocalPart());
                SchemaElement schemaElement2 = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                schemaElement.addChild(schemaElement2);
                SchemaElement schemaElement3 = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                schemaElement2.addChild(schemaElement3);
                schemaElement3.addAttribute("base", "soap-enc:Array");
                SchemaElement schemaElement4 = new SchemaElement(SchemaConstants.QNAME_ATTRIBUTE);
                schemaElement3.addChild(schemaElement4);
                schemaElement4.addAttribute("ref", SOAPConstants.QNAME_ATTR_ARRAY_TYPE);
                schema.defineEntity(schemaElement, SchemaKinds.XSD_TYPE, sOAPArrayType.getName());
                SchemaAttribute schemaAttribute = new SchemaAttribute(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getLocalPart());
                schemaAttribute.setNamespaceURI(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getNamespaceURI());
                String string = schemaElement4.asString(sOAPArrayType.getElementType().getName()) + "[]";
                schemaAttribute.setValue(string);
                schemaElement4.addAttribute(schemaAttribute);
                WSDLTypeGenerator.this.processType(sOAPArrayType.getElementType());
            }

            public void visit(SOAPCustomType sOAPCustomType) throws Exception {
                SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(schemaElement);
                schemaElement.addAttribute("name", sOAPCustomType.getName().getLocalPart());
                SchemaElement schemaElement2 = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                schemaElement.addChild(schemaElement2);
                SchemaElement schemaElement3 = new SchemaElement(SchemaConstants.QNAME_ANY);
                schemaElement2.addChild(schemaElement3);
                schema.defineEntity(schemaElement, SchemaKinds.XSD_TYPE, sOAPCustomType.getName());
            }

            public void visit(SOAPEnumerationType sOAPEnumerationType) throws Exception {
                SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_SIMPLE_TYPE);
                schema.getContent().addChild(schemaElement);
                schemaElement.addAttribute("name", sOAPEnumerationType.getName().getLocalPart());
                SchemaElement schemaElement2 = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                schemaElement.addChild(schemaElement2);
                schemaElement2.addAttribute("base", sOAPEnumerationType.getBaseType().getName());
                JavaEnumerationType javaEnumerationType = (JavaEnumerationType)sOAPEnumerationType.getJavaType();
                Iterator iterator = javaEnumerationType.getEntries();
                while (iterator.hasNext()) {
                    JavaEnumerationEntry javaEnumerationEntry = (JavaEnumerationEntry)iterator.next();
                    SchemaElement schemaElement3 = new SchemaElement(SchemaConstants.QNAME_ENUMERATION);
                    schemaElement3.addAttribute("value", javaEnumerationEntry.getLiteralValue());
                    schemaElement2.addChild(schemaElement3);
                }
                schema.defineEntity(schemaElement, SchemaKinds.XSD_TYPE, sOAPEnumerationType.getName());
            }

            public void visit(SOAPSimpleType sOAPSimpleType) throws Exception {
                if (sOAPSimpleType.getName().getNamespaceURI().equals("http://java.sun.com/jax-rpc-ri/internal")) {
                    if (sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY)) {
                        this.writeJAXRpcMapEntryType();
                    } else if (sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_MAP)) {
                        this.writeMapType();
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.JAX_RPC_MAP_ENTRY_SOAPTYPE);
                    } else if (sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_HASH_MAP) || sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_TREE_MAP) || sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_HASHTABLE) || sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_PROPERTIES)) {
                        this.writeTypeSubtype(sOAPSimpleType, InternalEncodingConstants.QNAME_TYPE_MAP);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.MAP_SOAPTYPE);
                    } else if (sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_COLLECTION)) {
                        this.writeCollectionType(sOAPSimpleType);
                    } else if (sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_LIST) || sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_SET)) {
                        this.writeTypeSubtype(sOAPSimpleType, InternalEncodingConstants.QNAME_TYPE_COLLECTION);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.COLLECTION_SOAPTYPE);
                    } else if (sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_ARRAY_LIST) || sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_VECTOR) || sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_STACK) || sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_LINKED_LIST)) {
                        this.writeTypeSubtype(sOAPSimpleType, InternalEncodingConstants.QNAME_TYPE_LIST);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.LIST_SOAPTYPE);
                    } else if (sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_HASH_SET) || sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_TREE_SET)) {
                        this.writeTypeSubtype(sOAPSimpleType, InternalEncodingConstants.QNAME_TYPE_SET);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.SET_SOAPTYPE);
                    } else {
                        SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_SIMPLE_TYPE);
                        schema.getContent().addChild(schemaElement);
                        schemaElement.addAttribute("name", sOAPSimpleType.getName().getLocalPart());
                        SchemaElement schemaElement2 = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                        schemaElement.addChild(schemaElement2);
                        QName qName = SchemaConstants.QNAME_TYPE_BASE64_BINARY;
                        if (sOAPSimpleType.getName().equals(InternalEncodingConstants.QNAME_TYPE_SOURCE)) {
                            qName = SchemaConstants.QNAME_TYPE_STRING;
                        }
                        schemaElement2.addAttribute("base", qName);
                        schema.defineEntity(schemaElement, SchemaKinds.XSD_TYPE, sOAPSimpleType.getName());
                    }
                }
            }

            private void writeJAXRpcMapEntryType() throws Exception {
                SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(schemaElement);
                schemaElement.addAttribute("name", InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY.getLocalPart());
                SchemaElement schemaElement2 = schemaElement;
                SchemaElement schemaElement3 = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                schemaElement2.addChild(schemaElement3);
                SchemaElement schemaElement4 = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                schemaElement3.addChild(schemaElement4);
                schemaElement4.addAttribute("name", InternalEncodingConstants.JAX_RPC_MAP_ENTRY_KEY_NAME.getLocalPart());
                schemaElement4.addAttribute("type", SchemaConstants.QNAME_TYPE_URTYPE);
                schemaElement4 = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                schemaElement3.addChild(schemaElement4);
                schemaElement4.addAttribute("name", InternalEncodingConstants.JAX_RPC_MAP_ENTRY_VALUE_NAME.getLocalPart());
                schemaElement4.addAttribute("type", SchemaConstants.QNAME_TYPE_URTYPE);
                schema.defineEntity(schemaElement, SchemaKinds.XSD_TYPE, InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY);
            }

            private void writeMapType() throws Exception {
                SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(schemaElement);
                schemaElement.addAttribute("name", InternalEncodingConstants.QNAME_TYPE_MAP.getLocalPart());
                SchemaElement schemaElement2 = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                schemaElement.addChild(schemaElement2);
                SchemaElement schemaElement3 = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                schemaElement2.addChild(schemaElement3);
                schemaElement3.addAttribute("base", "soap-enc:Array");
                SchemaElement schemaElement4 = new SchemaElement(SchemaConstants.QNAME_ATTRIBUTE);
                schemaElement3.addChild(schemaElement4);
                schemaElement4.addAttribute("ref", SOAPConstants.QNAME_ATTR_ARRAY_TYPE);
                schema.defineEntity(schemaElement, SchemaKinds.XSD_TYPE, InternalEncodingConstants.QNAME_TYPE_MAP);
                SchemaAttribute schemaAttribute = new SchemaAttribute(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getLocalPart());
                schemaAttribute.setNamespaceURI(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getNamespaceURI());
                String string = schemaElement4.asString(InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY) + "[]";
                schemaAttribute.setValue(string);
                schemaElement4.addAttribute(schemaAttribute);
            }

            private void writeTypeSubtype(AbstractType abstractType, QName qName) throws Exception {
                SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(schemaElement);
                schemaElement.addAttribute("name", abstractType.getName().getLocalPart());
                SchemaElement schemaElement2 = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                schemaElement.addChild(schemaElement2);
                SchemaElement schemaElement3 = new SchemaElement(SchemaConstants.QNAME_EXTENSION);
                schemaElement2.addChild(schemaElement3);
                schemaElement3.addAttribute("base", qName);
                SchemaElement schemaElement4 = schemaElement3;
                SchemaElement schemaElement5 = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                schemaElement4.addChild(schemaElement5);
                schema.defineEntity(schemaElement, SchemaKinds.XSD_TYPE, abstractType.getName());
            }

            private void writeCollectionType(AbstractType abstractType) throws Exception {
                SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(schemaElement);
                schemaElement.addAttribute("name", abstractType.getName().getLocalPart());
                SchemaElement schemaElement2 = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                schemaElement.addChild(schemaElement2);
                SchemaElement schemaElement3 = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                schemaElement2.addChild(schemaElement3);
                schemaElement3.addAttribute("base", "soap-enc:Array");
                SchemaElement schemaElement4 = new SchemaElement(SchemaConstants.QNAME_ATTRIBUTE);
                schemaElement3.addChild(schemaElement4);
                schemaElement4.addAttribute("ref", SOAPConstants.QNAME_ATTR_ARRAY_TYPE);
                schema.defineEntity(schemaElement, SchemaKinds.XSD_TYPE, abstractType.getName());
                SchemaAttribute schemaAttribute = new SchemaAttribute(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getLocalPart());
                schemaAttribute.setNamespaceURI(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getNamespaceURI());
                String string = schemaElement4.asString(SchemaConstants.QNAME_TYPE_URTYPE) + "[]";
                schemaAttribute.setValue(string);
                schemaElement4.addAttribute(schemaAttribute);
            }

            public void visit(SOAPAnyType sOAPAnyType) throws Exception {
            }

            public void visit(SOAPOrderedStructureType sOAPOrderedStructureType) throws Exception {
                this.visit((SOAPStructureType)sOAPOrderedStructureType);
            }

            public void visit(SOAPUnorderedStructureType sOAPUnorderedStructureType) throws Exception {
                this.visit((SOAPStructureType)sOAPUnorderedStructureType);
            }

            public void visit(RPCRequestOrderedStructureType rPCRequestOrderedStructureType) throws Exception {
                Iterator iterator = rPCRequestOrderedStructureType.getMembers();
                while (iterator.hasNext()) {
                    SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)iterator.next();
                    WSDLTypeGenerator.this.processType(sOAPStructureMember.getType());
                }
            }

            public void visit(RPCRequestUnorderedStructureType rPCRequestUnorderedStructureType) throws Exception {
                Iterator iterator = rPCRequestUnorderedStructureType.getMembers();
                while (iterator.hasNext()) {
                    SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)iterator.next();
                    WSDLTypeGenerator.this.processType(sOAPStructureMember.getType());
                }
            }

            public void visit(RPCResponseStructureType rPCResponseStructureType) throws Exception {
                Iterator iterator = rPCResponseStructureType.getMembers();
                while (iterator.hasNext()) {
                    SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)iterator.next();
                    WSDLTypeGenerator.this.processType(sOAPStructureMember.getType());
                }
            }

            protected void visit(SOAPStructureType sOAPStructureType) throws Exception {
                Object object;
                Object object2;
                Object object3;
                SchemaElement schemaElement;
                SOAPStructureType sOAPStructureType2 = sOAPStructureType.getParentType();
                SchemaElement schemaElement2 = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(schemaElement2);
                schemaElement2.addAttribute("name", sOAPStructureType.getName().getLocalPart());
                Object object4 = schemaElement2;
                if (sOAPStructureType2 != null) {
                    schemaElement = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                    schemaElement2.addChild(schemaElement);
                    object3 = new SchemaElement(SchemaConstants.QNAME_EXTENSION);
                    schemaElement.addChild((SchemaElement)object3);
                    ((SchemaElement)object3).addAttribute("base", sOAPStructureType2.getName());
                    object4 = object3;
                }
                schemaElement = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                ((SchemaElement)object4).addChild(schemaElement);
                object3 = sOAPStructureType.getMembers();
                while (object3.hasNext()) {
                    object2 = (SOAPStructureMember)object3.next();
                    if (((SOAPStructureMember)object2).isInherited() && sOAPStructureType.getParentType() != null) continue;
                    object = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                    schemaElement.addChild((SchemaElement)object);
                    ((SchemaElement)object).addAttribute("name", ((SOAPStructureMember)object2).getName().getLocalPart());
                    ((SchemaElement)object).addAttribute("type", ((SOAPStructureMember)object2).getType().getName());
                }
                schema.defineEntity(schemaElement2, SchemaKinds.XSD_TYPE, sOAPStructureType.getName());
                if (sOAPStructureType2 != null) {
                    WSDLTypeGenerator.this.processType(sOAPStructureType.getParentType());
                }
                object2 = sOAPStructureType.getMembers();
                while (object2.hasNext()) {
                    object = (SOAPStructureMember)object2.next();
                    WSDLTypeGenerator.this.processType(((SOAPStructureMember)object).getType());
                }
                object = sOAPStructureType.getSubtypes();
                if (object != null) {
                    while (object.hasNext()) {
                        WSDLTypeGenerator.this.processType((AbstractType)object.next());
                    }
                }
            }
        });
    }

    private void processFault(Fault fault) throws Exception {
        AbstractType abstractType = fault.getBlock().getType();
        AbstractType abstractType2 = abstractType instanceof SOAPStructureType ? abstractType : (AbstractType)fault.getJavaException().getOwner();
        if (abstractType2.getName() == null || this.generatedTypes.contains(abstractType2.getName())) {
            return;
        }
        if ((abstractType.getName().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || abstractType.getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) && fault.getAllFaults() == null) {
            return;
        }
        ImportedDocumentInfo importedDocumentInfo = this.model.getImportedDocument(abstractType.getName().getNamespaceURI());
        if (importedDocumentInfo != null && importedDocumentInfo.getType() == 1) {
            this.actuallyImportedDocuments.add(importedDocumentInfo);
            return;
        }
        Schema schema = (Schema)this.nsSchemaMap.get(abstractType2.getName().getNamespaceURI());
        if (schema == null) {
            schema = new Schema(this.document);
            schema.setTargetNamespaceURI(abstractType.getName().getNamespaceURI());
            SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_SCHEMA);
            schemaElement.addAttribute("targetNamespace", schema.getTargetNamespaceURI());
            schemaElement.addPrefix("", "http://www.w3.org/2001/XMLSchema");
            schemaElement.addPrefix("wsdl", "http://schemas.xmlsoap.org/wsdl/");
            schemaElement.addPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            schemaElement.addPrefix("soap-enc", "http://schemas.xmlsoap.org/soap/encoding/");
            schemaElement.addPrefix("tns", schema.getTargetNamespaceURI());
            schema.setContent(schemaElement);
            this.nsSchemaMap.put(abstractType.getName().getNamespaceURI(), schema);
        }
        if (abstractType2.isLiteralType()) {
            throw new GeneratorException("generator.literalTypesNotSupported", new Object[]{abstractType.getName().getLocalPart(), abstractType.getName().getNamespaceURI()});
        }
        this.generatedTypes.add(abstractType2.getName());
        this.processFault(fault, schema);
    }

    private void processFault(Fault fault, Schema schema) throws Exception {
        Object object;
        Object object2;
        Object object3;
        SchemaElement schemaElement;
        Object object4;
        Fault fault2 = fault.getParentFault();
        SOAPType sOAPType = (SOAPType)fault.getBlock().getType();
        SOAPType sOAPType2 = fault2 != null ? (SOAPType)fault2.getBlock().getType() : null;
        SchemaElement schemaElement2 = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
        schema.getContent().addChild(schemaElement2);
        boolean bl = false;
        if (sOAPType instanceof SOAPStructureType) {
            schemaElement2.addAttribute("name", sOAPType.getName().getLocalPart());
            bl = SOAPObjectSerializerGenerator.deserializeToDetail((SOAPStructureType)sOAPType);
        } else {
            object4 = fault.getJavaException();
            schemaElement2.addAttribute("name", ((SOAPType)((JavaStructureType)object4).getOwner()).getName().getLocalPart());
        }
        object4 = schemaElement2;
        if (sOAPType2 != null) {
            schemaElement = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
            schemaElement2.addChild(schemaElement);
            object3 = new SchemaElement(SchemaConstants.QNAME_EXTENSION);
            schemaElement.addChild((SchemaElement)object3);
            if (sOAPType2 instanceof SOAPStructureType) {
                ((SchemaElement)object3).addAttribute("base", sOAPType2.getName());
            } else {
                object2 = fault2.getJavaException();
                ((SchemaElement)object3).addAttribute("base", ((SOAPType)((JavaStructureType)object2).getOwner()).getName());
            }
            object4 = object3;
        }
        schemaElement = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
        ((SchemaElement)object4).addChild(schemaElement);
        if (sOAPType instanceof SOAPStructureType) {
            object3 = ((SOAPStructureType)sOAPType).getMembers();
            while (object3.hasNext()) {
                object2 = (SOAPStructureMember)object3.next();
                if (((SOAPStructureMember)object2).isInherited() && fault2 != null) continue;
                object = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                schemaElement.addChild((SchemaElement)object);
                ((SchemaElement)object).addAttribute("name", ((SOAPStructureMember)object2).getName().getLocalPart());
                ((SchemaElement)object).addAttribute("type", ((SOAPStructureMember)object2).getType().getName());
            }
            schema.defineEntity(schemaElement2, SchemaKinds.XSD_TYPE, sOAPType.getName());
        } else {
            object3 = fault.getJavaException();
            object2 = (SOAPStructureType)((JavaStructureType)object3).getOwner();
            object = ((SOAPStructureType)object2).getMembers();
            SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)object.next();
            if (!sOAPStructureMember.isInherited() || fault.getParentFault() == null) {
                SchemaElement schemaElement3 = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                schemaElement.addChild(schemaElement3);
                schemaElement3.addAttribute("name", sOAPStructureMember.getName().getLocalPart());
                schemaElement3.addAttribute("type", sOAPStructureMember.getType().getName());
            }
            schema.defineEntity(schemaElement2, SchemaKinds.XSD_TYPE, ((SOAPType)((JavaStructureType)object3).getOwner()).getName());
        }
        if (sOAPType2 != null) {
            this.processFault(fault2);
        }
        if (sOAPType instanceof SOAPStructureType) {
            object3 = ((SOAPStructureType)sOAPType).getMembers();
            while (object3.hasNext()) {
                object2 = (SOAPStructureMember)object3.next();
                this.processType(((SOAPStructureMember)object2).getType());
            }
            object2 = ((SOAPStructureType)sOAPType).getSubtypes();
            if (object2 != null) {
                while (object2.hasNext()) {
                    this.processType((AbstractType)object2.next());
                }
            }
        }
    }
}

