/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.CombinedSerializer;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SerializerConstants;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;

public abstract class SerializerBase
implements CombinedSerializer,
SerializerConstants {
    protected QName type;
    protected boolean encodeType;
    protected boolean isNullable;
    protected String encodingStyle;

    protected SerializerBase(QName qName, boolean bl, boolean bl2, String string) {
        if (qName == null) {
            throw new IllegalArgumentException("xmlType parameter is not allowed to be null");
        }
        this.type = qName;
        this.encodeType = bl;
        this.isNullable = bl2;
        this.encodingStyle = string;
    }

    public QName getXmlType() {
        return this.type;
    }

    public boolean getEncodeType() {
        return this.encodeType;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public CombinedSerializer getInnermostSerializer() {
        return this;
    }

    public Object deserialize(DataHandler dataHandler, SOAPDeserializationContext sOAPDeserializationContext) {
        throw new UnsupportedOperationException();
    }

    protected QName getName(XMLReader xMLReader) throws Exception {
        return xMLReader.getName();
    }

    public static QName getType(XMLReader xMLReader) throws Exception {
        QName qName = null;
        Attributes attributes = xMLReader.getAttributes();
        String string = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (string != null) {
            qName = XMLReaderUtil.decodeQName(xMLReader, string);
        }
        return qName;
    }

    public static boolean getNullStatus(XMLReader xMLReader) throws Exception {
        boolean bl = false;
        Attributes attributes = xMLReader.getAttributes();
        String string = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        bl = string != null && SerializerBase.decodeBoolean(string);
        return bl;
    }

    public static boolean decodeBoolean(String string) throws Exception {
        return string.equals("true") || string.equals("1");
    }

    protected String getID(XMLReader xMLReader) throws Exception {
        Attributes attributes = xMLReader.getAttributes();
        return attributes.getValue("", "id");
    }

    protected void verifyName(XMLReader xMLReader, QName qName) throws Exception {
        QName qName2 = this.getName(xMLReader);
        if (!qName2.equals(qName)) {
            throw new DeserializationException("soap.unexpectedElementName", new Object[]{qName.toString(), qName2.toString()});
        }
    }

    protected void verifyType(XMLReader xMLReader) throws Exception {
        if (this.typeIsEmpty()) {
            return;
        }
        QName qName = SerializerBase.getType(xMLReader);
        if (qName != null && !qName.equals(this.type) && !this.isAcceptableType(qName)) {
            throw new DeserializationException("soap.unexpectedElementType", new Object[]{this.type.toString(), qName.toString()});
        }
    }

    protected boolean isAcceptableType(QName qName) {
        return false;
    }

    protected void skipEmptyContent(XMLReader xMLReader) throws Exception {
        xMLReader.skipElement();
    }

    public String getMechanismType() {
        return "http://java.sun.com/jax-rpc-ri/1.0/streaming/";
    }

    protected boolean typeIsEmpty() {
        return this.type.getNamespaceURI().equals("") && this.type.getLocalPart().equals("");
    }
}

