/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.ReferenceableSerializer;
import com.sun.xml.rpc.encoding.SOAPSerializationState;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.soap.SOAPMessage;

public class SOAPSerializationContext {
    protected HashMap map;
    protected Map properties;
    protected LinkedList list;
    protected String prefix;
    protected long next;
    protected Stack encodingStyleContext = new Stack();
    protected String curEncodingStyle = null;
    protected Set activeObjects;
    protected SOAPMessage message;

    public SOAPSerializationContext() {
        this(null);
    }

    public SOAPSerializationContext(String string) {
        if (string == null) {
            string = "ID";
        }
        this.map = new HashMap();
        this.properties = new HashMap();
        this.list = new LinkedList();
        this.prefix = string;
        this.next = 1L;
    }

    public SOAPSerializationState registerObject(Object object, ReferenceableSerializer referenceableSerializer) {
        MapKey mapKey = new MapKey(object);
        SOAPSerializationState sOAPSerializationState = (SOAPSerializationState)this.map.get(mapKey);
        if (sOAPSerializationState == null) {
            sOAPSerializationState = new SOAPSerializationState(object, this.nextID(), referenceableSerializer);
            this.map.put(mapKey, sOAPSerializationState);
            this.list.add(sOAPSerializationState);
        }
        return sOAPSerializationState;
    }

    public SOAPSerializationState lookupObject(Object object) {
        MapKey mapKey = new MapKey(object);
        return (SOAPSerializationState)this.map.get(mapKey);
    }

    public void serializeMultiRefObjects(XMLWriter xMLWriter) {
        while (!this.list.isEmpty()) {
            SOAPSerializationState sOAPSerializationState = (SOAPSerializationState)this.list.removeFirst();
            Object object = sOAPSerializationState.getObject();
            ReferenceableSerializer referenceableSerializer = sOAPSerializationState.getSerializer();
            referenceableSerializer.serializeInstance(object, null, true, xMLWriter, this);
        }
    }

    public String nextID() {
        return this.prefix + this.next++;
    }

    public boolean pushEncodingStyle(String string, XMLWriter xMLWriter) throws Exception {
        if (string == this.curEncodingStyle || string.equals(this.curEncodingStyle)) {
            return false;
        }
        xMLWriter.writeAttribute(SOAPConstants.QNAME_ENVELOPE_ENCODINGSTYLE, string);
        this.encodingStyleContext.push(string);
        this.initEncodingStyleInfo();
        return true;
    }

    public void popEncodingStyle() {
        this.encodingStyleContext.pop();
        this.initEncodingStyleInfo();
    }

    private void initEncodingStyleInfo() {
        this.curEncodingStyle = this.encodingStyleContext.empty() ? null : (String)this.encodingStyleContext.peek();
    }

    public String getEncodingStyle() {
        return this.curEncodingStyle;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void removeProperty(String string) {
        this.properties.remove(string);
    }

    public void beginFragment() {
        this.activeObjects = new HashSet();
    }

    public void beginSerializing(Object object) throws SerializationException {
        if (object != null && this.activeObjects != null) {
            if (this.activeObjects.contains(object)) {
                throw new SerializationException("soap.circularReferenceDetected", new Object[]{object});
            }
            this.activeObjects.add(object);
        }
    }

    public void doneSerializing(Object object) throws SerializationException {
        if (object != null && this.activeObjects != null) {
            this.activeObjects.remove(object);
        }
    }

    public void endFragment() {
        this.activeObjects = null;
    }

    public void setMessage(SOAPMessage sOAPMessage) {
        this.message = sOAPMessage;
    }

    public SOAPMessage getMessage() {
        return this.message;
    }

    private static class MapKey {
        Object obj;

        public MapKey(Object object) {
            this.obj = object;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MapKey)) {
                return false;
            }
            return this.obj == ((MapKey)object).obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }
    }
}

