/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.tags;

import com.sun.xml.messaging.saaj.tags.JaxmContext;
import com.sun.xml.messaging.saaj.tags.SAttachment;
import com.sun.xml.messaging.saaj.tags.SBody;
import com.sun.xml.messaging.saaj.tags.SHeader;
import com.sun.xml.messaging.saaj.tags.StringDataSource;
import com.sun.xml.messaging.util.StringManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.xml.messaging.URLEndpoint;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JaxmSend {
    private static Log logger = LogFactory.getLog((String)"javax.enterprise.system.webservices.saaj");
    private static StringManager localStrings = StringManager.getManager("com.sun.xml.messaging");
    String endpointS;
    URL endpointURL;
    boolean reuseConnection = true;
    int dL = 0;
    String msgId;
    String jaxmCtx;
    SBody sbody;
    SHeader sheader;
    Vector attachments = new Vector();
    public static final String SOAP_ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    SOAPConnection con;
    SOAPMessage msg;
    URLEndpoint endPoint;
    JaxmContext gctx;

    public void setEndpoint(String string) {
        this.endpointS = string;
    }

    public void setReuseConnection(boolean bl) {
        this.reuseConnection = bl;
    }

    public void setDebug(int n) {
        this.dL = n;
    }

    public void setMsgId(String string) {
        this.msgId = string;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setJaxmContext(String string) {
        this.jaxmCtx = string;
    }

    public SHeader createSHeader() {
        this.sheader = new SHeader();
        return this.sheader;
    }

    public SBody createSBody() {
        this.sbody = new SBody();
        return this.sbody;
    }

    public void addAttachment(SAttachment sAttachment) {
        this.attachments.addElement(sAttachment);
    }

    public void setRemoteURL(String string) {
        try {
            this.endpointURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public void prepareAttachments(SOAPMessage sOAPMessage) throws SOAPException {
        int n = 0;
        while (n < this.attachments.size()) {
            AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
            SAttachment sAttachment = (SAttachment)this.attachments.elementAt(n);
            attachmentPart.setContentType("text/xml");
            String string = "text/plain";
            StringDataSource stringDataSource = new StringDataSource(sAttachment.getBody(), sAttachment.getContentType(), sAttachment.getName());
            attachmentPart.setContent((Object)sAttachment.getBody(), sAttachment.getContentType());
            sOAPMessage.addAttachmentPart(attachmentPart);
            if (this.dL > 0 || logger.isDebugEnabled()) {
                this.debug("Added attachment " + n);
            }
            ++n;
        }
    }

    public SOAPMessage prepareMessage(MessageFactory messageFactory) throws SOAPException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.msg2SB(stringBuffer);
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.setHeader("Content-Type", "text/xml");
        SOAPMessage sOAPMessage = messageFactory.createMessage(mimeHeaders, (InputStream)new StringBufferInputStream(stringBuffer.toString()));
        return sOAPMessage;
    }

    public void msg2SB(StringBuffer stringBuffer) {
        stringBuffer.append("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"");
        stringBuffer.append(SOAP_ENV_NS);
        stringBuffer.append("\" >");
        if (this.sheader != null) {
            stringBuffer.append("<SOAP-ENV:Header>");
            stringBuffer.append(this.sheader.getBody());
            stringBuffer.append("</SOAP-ENV:Header>");
        }
        if (this.sbody != null) {
            stringBuffer.append("<SOAP-ENV:Body>");
            stringBuffer.append(this.sbody.getBody());
            stringBuffer.append("</SOAP-ENV:Body>");
        }
        stringBuffer.append("</SOAP-ENV:Envelope>\n");
    }

    public void setMessage(SOAPMessage sOAPMessage) {
        this.msg = sOAPMessage;
    }

    public SOAPMessage getMessage() {
        return this.msg;
    }

    public void initMessage() throws Exception {
        this.gctx = JaxmContext.getJaxmContext(this.jaxmCtx);
        try {
            if (this.msgId != null) {
                this.msg = (SOAPMessage)this.gctx.getAttribute(this.msgId);
            }
            if (this.msg != null) {
                return;
            }
            SOAPConnectionFactory sOAPConnectionFactory = SOAPConnectionFactory.newInstance();
            this.con = sOAPConnectionFactory.createConnection();
            MessageFactory messageFactory = MessageFactory.newInstance();
            this.msg = this.prepareMessage(messageFactory);
            this.prepareAttachments(this.msg);
            if (this.dL > 0 || logger.isDebugEnabled()) {
                this.debug("Created SOAPPart");
            }
            if (this.msgId != null) {
                if (this.dL > 0 || logger.isDebugEnabled()) {
                    this.debug("Set " + this.msgId);
                }
                this.gctx.setAttribute(this.msgId, this.msg);
            }
        }
        catch (Exception exception) {
            this.gctx.setAttribute("lastException", exception);
            this.dumpException(exception);
        }
    }

    public void initEndpoint() throws Exception {
        this.gctx = JaxmContext.getJaxmContext(this.jaxmCtx);
        try {
            if (this.endpointS == null) {
                this.endpointS = "endpoint";
            }
            if (this.endpointURL != null) {
                this.gctx.addURIMapping(this.endpointS, this.endpointURL);
            }
            this.endPoint = new URLEndpoint(this.endpointS);
        }
        catch (Exception exception) {
            this.gctx.setAttribute("lastException", exception);
            this.dumpException(exception);
        }
    }

    public void execute() throws Exception {
        try {
            this.initMessage();
            this.initEndpoint();
            if (this.dL > 0 || logger.isDebugEnabled()) {
                this.debug("Sent message");
            }
        }
        catch (Exception exception) {
            this.dumpException(exception);
            this.gctx.setAttribute("lastException", exception);
        }
    }

    public void dumpException(Throwable throwable) {
        throwable.printStackTrace();
        while (throwable instanceof SOAPException) {
            if ((throwable = ((SOAPException)throwable).getCause()) == null) continue;
            throwable.printStackTrace();
        }
    }

    public void debug(String string) {
        String string2 = localStrings.getString("saaj.debug.saaj_snd");
        logger.debug((Object)(string2 + " " + string));
    }
}

