/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http.ea;

import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.server.http.ea.ImplementorInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ImplementorRegistry {
    private Map _implementors = new HashMap();
    private static final String PROPERTY_PORT_COUNT = "portcount";
    private static final String PROPERTY_PORT = "port";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_TIE = "tie";
    private static final String PROPERTY_SERVANT = "servant";

    public ImplementorInfo getImplementorInfo(String string) {
        ImplementorInfo implementorInfo = (ImplementorInfo)this._implementors.get(string);
        if (implementorInfo == null) {
            throw new JAXRPCServletException("error.implementorRegistry.unknownName", string);
        }
        return implementorInfo;
    }

    public boolean containsName(String string) {
        return this._implementors.containsKey(string);
    }

    public Iterator names() {
        return this._implementors.keySet().iterator();
    }

    public void readFrom(String string) {
        try {
            this.readFrom(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JAXRPCServletException("error.implementorRegistry.fileNotFound", string);
        }
    }

    public void readFrom(InputStream inputStream) {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            int n = Integer.parseInt(properties.getProperty(PROPERTY_PORT_COUNT));
            int n2 = 0;
            while (n2 < n) {
                String string = PROPERTY_PORT + Integer.toString(n2) + ".";
                String string2 = properties.getProperty(string + PROPERTY_NAME);
                String string3 = properties.getProperty(string + PROPERTY_TIE);
                String string4 = properties.getProperty(string + PROPERTY_SERVANT);
                if (string2 == null || string3 == null || string4 == null) {
                    throw new JAXRPCServletException("error.implementorRegistry.incompleteInformation");
                }
                this.register(string2, string3, string4);
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new JAXRPCServletException("error.implementorRegistry.cannotReadConfiguration");
        }
    }

    public void register(String string, String string2, String string3) {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXRPCServletException("error.implementorRegistry.classNotFound", string2);
        }
        try {
            clazz2 = Thread.currentThread().getContextClassLoader().loadClass(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXRPCServletException("error.implementorRegistry.classNotFound", string3);
        }
        this.register(string, new ImplementorInfo(clazz, clazz2));
    }

    public void register(String string, ImplementorInfo implementorInfo) {
        if (this._implementors.containsKey(string)) {
            throw new JAXRPCServletException("error.implementorRegistry.duplicateName", string);
        }
        this._implementors.put(string, implementorInfo);
    }
}

