/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.config.parser;

import com.sun.xml.rpc.processor.config.ConfigurationException;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;

public class ParserUtil {
    public static String getAttribute(XMLReader xMLReader, String string) {
        Attributes attributes = xMLReader.getAttributes();
        return attributes.getValue(string);
    }

    public static String getMandatoryAttribute(XMLReader xMLReader, String string) {
        String string2 = ParserUtil.getAttribute(xMLReader, string);
        if (string2 == null) {
            ParserUtil.failWithLocalName("configuration.missing.attribute", xMLReader, string);
        }
        return string2;
    }

    public static String getMandatoryNonEmptyAttribute(XMLReader xMLReader, String string) {
        String string2 = ParserUtil.getAttribute(xMLReader, string);
        if (string2 == null) {
            ParserUtil.failWithLocalName("configuration.missing.attribute", xMLReader, string);
        } else if (string2.equals("")) {
            ParserUtil.failWithLocalName("configuration.invalidAttributeValue", xMLReader, string);
        }
        return string2;
    }

    public static void ensureNoContent(XMLReader xMLReader) {
        if (xMLReader.nextElementContent() != 2) {
            ParserUtil.fail("configuration.unexpectedContent", xMLReader);
        }
    }

    public static void fail(String string, XMLReader xMLReader) {
        throw new ConfigurationException(string, Integer.toString(xMLReader.getLineNumber()));
    }

    public static void failWithFullName(String string, XMLReader xMLReader) {
        throw new ConfigurationException(string, new Object[]{Integer.toString(xMLReader.getLineNumber()), xMLReader.getName().toString()});
    }

    public static void failWithLocalName(String string, XMLReader xMLReader) {
        throw new ConfigurationException(string, new Object[]{Integer.toString(xMLReader.getLineNumber()), xMLReader.getLocalName()});
    }

    public static void failWithLocalName(String string, XMLReader xMLReader, String string2) {
        throw new ConfigurationException(string, new Object[]{Integer.toString(xMLReader.getLineNumber()), xMLReader.getLocalName(), string2});
    }
}

