/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.simpletype.EncoderUtils;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;

public class XSDBooleanEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDBooleanEncoder();

    private XSDBooleanEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    public String objectToString(Object object, XMLWriter xMLWriter) throws Exception {
        if (object == null) {
            return null;
        }
        return ((Boolean)object).toString();
    }

    public Object stringToObject(String string, XMLReader xMLReader) throws Exception {
        if (string == null) {
            return null;
        }
        String string2 = EncoderUtils.collapseWhitespace(string);
        if (string2.equals("true")) {
            return Boolean.TRUE;
        }
        if (string2.equals("false")) {
            return Boolean.FALSE;
        }
        if (string2.equals("1")) {
            return Boolean.TRUE;
        }
        if (string2.equals("0")) {
            return Boolean.FALSE;
        }
        throw new DeserializationException("xsd.invalid.boolean", string2);
    }

    public void writeValue(Object object, XMLWriter xMLWriter) throws Exception {
        xMLWriter.writeCharsUnquoted(this.objectToString(object, xMLWriter));
    }
}

