/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.SimpleTypeSerializer;
import com.sun.xml.rpc.encoding.simpletype.AttachmentEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeConstants;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;

public class AttachmentSerializer
extends SimpleTypeSerializer {
    protected AttachmentEncoder attachmentEncoder;
    protected boolean serializerAsAttachment;

    public AttachmentSerializer(QName qName, boolean bl, boolean bl2, String string, boolean bl3, SimpleTypeEncoder simpleTypeEncoder) {
        super(qName, bl, bl2, string, simpleTypeEncoder);
        this.serializerAsAttachment = bl3;
        if (simpleTypeEncoder instanceof AttachmentEncoder) {
            this.attachmentEncoder = (AttachmentEncoder)((Object)simpleTypeEncoder);
        } else if (bl3) {
            throw new SerializationException("soap.no.attachment.encoder.and.serializeAsAttachment", qName.toString());
        }
    }

    public AttachmentSerializer(QName qName, boolean bl, boolean bl2, String string, boolean bl3, AttachmentEncoder attachmentEncoder) {
        super(qName, bl, bl2, string, null);
        this.serializerAsAttachment = bl3;
        this.attachmentEncoder = attachmentEncoder;
    }

    public void serialize(Object object, QName qName, SerializerCallback serializerCallback, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) {
        if (this.serializerAsAttachment) {
            this.serializeAsAttachment(object, qName, serializerCallback, xMLWriter, sOAPSerializationContext);
        } else if (this.encoder != null) {
            super.serialize(object, qName, serializerCallback, xMLWriter, sOAPSerializationContext);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void serializeAsAttachment(Object object, QName qName, SerializerCallback serializerCallback, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) {
        try {
            xMLWriter.startElement(qName != null ? qName : this.type);
            if (object == null) {
                if (!this.isNullable) {
                    throw new SerializationException("xsd.unexpectedNull");
                }
                xMLWriter.writeAttributeUnquoted(SimpleTypeConstants.QNAME_XSI_NIL, "1");
            } else {
                String string;
                if (this.encodeType) {
                    string = XMLWriterUtil.encodeQName(xMLWriter, this.type);
                    xMLWriter.writeAttributeUnquoted(SimpleTypeConstants.QNAME_XSI_TYPE, string);
                }
                string = sOAPSerializationContext.nextID();
                xMLWriter.writeAttribute(SOAPConstants.QNAME_ATTR_HREF, "cid:" + string);
                SOAPMessage sOAPMessage = sOAPSerializationContext.getMessage();
                AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart(this.attachmentEncoder.objectToDataHandler(object));
                attachmentPart.setContentId(string);
                sOAPMessage.addAttachmentPart(attachmentPart);
            }
            xMLWriter.endElement();
        }
        catch (SerializationException serializationException) {
            throw serializationException;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new SerializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new SerializationException(new LocalizableExceptionAdapter(exception));
        }
    }

    public Object deserialize(QName qName, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) {
        boolean bl = false;
        try {
            String string = this.getHRef(xMLReader);
            if (string != null) {
                this.skipEmptyContent(xMLReader);
                SOAPMessage sOAPMessage = sOAPDeserializationContext.getMessage();
                MimeHeaders mimeHeaders = new MimeHeaders();
                mimeHeaders.addHeader("Content-Id", string.substring(4));
                Iterator iterator = sOAPMessage.getAttachments(mimeHeaders);
                if (!iterator.hasNext()) {
                    throw new DeserializationException("soap.missing.attachment.for.id", string);
                }
                AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
                if (iterator.hasNext()) {
                    throw new DeserializationException("soap.multiple.attachments.for.id", string);
                }
                return this.deserialize(attachmentPart.getDataHandler(), sOAPDeserializationContext);
            }
        }
        catch (DeserializationException deserializationException) {
            throw deserializationException;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new DeserializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new DeserializationException(new LocalizableExceptionAdapter(exception));
        }
        return super.deserialize(qName, xMLReader, sOAPDeserializationContext);
    }

    public Object deserialize(DataHandler dataHandler, SOAPDeserializationContext sOAPDeserializationContext) throws DeserializationException, UnsupportedOperationException {
        if (this.attachmentEncoder == null) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.attachmentEncoder.dataHandlerToObject(dataHandler);
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new DeserializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new DeserializationException(new LocalizableExceptionAdapter(exception));
        }
    }

    protected String getHRef(XMLReader xMLReader) throws Exception {
        String string = null;
        Attributes attributes = xMLReader.getAttributes();
        string = attributes.getValue("", "href");
        if (string != null && !string.startsWith("cid:")) {
            throw new DeserializationException("soap.nonLocalReference", string);
        }
        return string;
    }
}

