/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.util.DirectoryUtil;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class ServletConfigGenerator
extends GeneratorBase {
    private File configFile = null;
    private Service currentService;
    private IndentingWriter out = null;
    private int portCount = 0;
    private TreeSet operations = null;

    public ServletConfigGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new ServletConfigGenerator(model, configuration, properties);
    }

    private ServletConfigGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected void preVisitService(Service service) throws Exception {
        try {
            this.currentService = service;
            String string = service.getName().getLocalPart();
            this.configFile = ServletConfigGenerator.configFileForClass(string, this.nonclassDestDir, this.env);
            this.out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(this.configFile)));
            this.portCount = 0;
            this.out.pln("# This file is generated by xrpcc.");
            this.out.pln();
        }
        catch (IOException iOException) {
            GeneratorBase.fail("cant.write", this.configFile.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postVisitService(Service service) throws Exception {
        try {
            try {
                this.out.pln("portcount=" + this.portCount);
                this.closeFile();
            }
            catch (IOException iOException) {
                GeneratorBase.fail("cant.write", this.configFile.toString());
                Object var4_3 = null;
                this.currentService = null;
            }
            Object var4_2 = null;
            this.currentService = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.currentService = null;
            throw throwable;
        }
    }

    public void visit(Port port) throws Exception {
        int n = this.portCount;
        this.portCount = n + 1;
        this.operations = new TreeSet(new StringLenComparator());
        Iterator iterator = port.getOperations();
        while (iterator.hasNext()) {
            ((Operation)iterator.next()).accept(this);
        }
        try {
            String string = "port" + n;
            String string2 = null;
            string2 = port.getJavaInterface().getImpl();
            if (string2 == null) {
                string2 = "Please specify the servant class for port:" + port.getName().getLocalPart();
            }
            this.out.pln(string + ".tie=" + this.env.getNames().tieFor(port.getJavaInterface()));
            this.out.pln(string + ".servant=" + string2);
            this.out.pln(string + ".name=" + port.getName().getLocalPart());
            this.out.pln(string + ".wsdl.targetNamespace=" + this.model.getTargetNamespaceURI());
            this.out.pln(string + ".wsdl.serviceName=" + this.currentService.getName().getLocalPart());
            QName qName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
            this.out.pln(string + ".wsdl.portName=" + qName.getLocalPart());
        }
        catch (IOException iOException) {
            GeneratorBase.fail("generator.cant.write", this.configFile.toString());
        }
    }

    protected void visitOperation(Operation operation) throws Exception {
        this.operations.add(operation);
    }

    private void closeFile() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    private String getBaseName(String string) {
        if (string.endsWith("Port")) {
            return string.substring(0, string.length() - 4);
        }
        return string;
    }

    private String getPortName(String string) {
        return this.getBaseName(string) + "Port";
    }

    protected static File configFileForClass(String string, File file, ProcessorEnvironment processorEnvironment) throws GeneratorException {
        File file2 = DirectoryUtil.getOutputDirectoryFor(string, file, processorEnvironment);
        processorEnvironment.getNames();
        String string2 = Names.stripQualifier(string);
        String string3 = string2 + "_Config.properties";
        return new File(file2, string3);
    }

    private static class StringLenComparator
    implements Comparator {
        private StringLenComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = ((Operation)object).getName().getLocalPart().length();
            return n2 <= (n = ((Operation)object2).getName().getLocalPart().length()) ? -1 : 1;
        }
    }
}

