/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.simpletype.EncoderUtils;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;

public class XSDFloatEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDFloatEncoder();

    private XSDFloatEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    public String objectToString(Object object, XMLWriter xMLWriter) throws Exception {
        if (object == null) {
            return null;
        }
        Float f = (Float)object;
        float f2 = f.floatValue();
        if (f.isInfinite()) {
            if (f2 == Float.NEGATIVE_INFINITY) {
                return "-INF";
            }
            return "INF";
        }
        if (f.isNaN()) {
            return "NaN";
        }
        return f.toString();
    }

    public Object stringToObject(String string, XMLReader xMLReader) throws Exception {
        if (string == null) {
            return null;
        }
        if ((string = EncoderUtils.collapseWhitespace(string)).equals("-INF")) {
            return new Float(Float.NEGATIVE_INFINITY);
        }
        if (string.equals("INF")) {
            return new Float(Float.POSITIVE_INFINITY);
        }
        if (string.equals("NaN")) {
            return new Float(Float.NaN);
        }
        return new Float(string);
    }

    public void writeValue(Object object, XMLWriter xMLWriter) throws Exception {
        xMLWriter.writeCharsUnquoted(this.objectToString(object, xMLWriter));
    }
}

