/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.ArraySerializerBase;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ObjectArraySerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Array;
import javax.xml.namespace.QName;

public class PolymorphicArraySerializer
extends SerializerBase
implements Initializable {
    protected QName elemName;
    protected InternalTypeMappingRegistry registry;

    public PolymorphicArraySerializer(QName qName, boolean bl, boolean bl2, String string, QName qName2) {
        super(qName, bl, bl2, string);
        this.elemName = qName2;
    }

    public void initialize(InternalTypeMappingRegistry internalTypeMappingRegistry) throws Exception {
        this.registry = internalTypeMappingRegistry;
    }

    public void serialize(Object object, QName qName, SerializerCallback serializerCallback, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws SerializationException {
        boolean bl = false;
        try {
            block14: {
                try {
                    String string;
                    if (object == null) {
                        if (!this.isNullable) {
                            throw new SerializationException("soap.unexpectedNull");
                        }
                        this.serializeNull(qName, xMLWriter, sOAPSerializationContext);
                        break block14;
                    }
                    if (!object.getClass().isArray()) {
                        throw new SerializationException("type.is.not.array", new Object[]{object.getClass().getName()});
                    }
                    xMLWriter.startElement(qName != null ? qName : this.type);
                    if (serializerCallback != null) {
                        serializerCallback.onStartTag(object, qName, xMLWriter, sOAPSerializationContext);
                    }
                    bl = sOAPSerializationContext.pushEncodingStyle(this.encodingStyle, xMLWriter);
                    if (this.encodeType) {
                        string = XMLWriterUtil.encodeQName(xMLWriter, SOAPConstants.QNAME_ENCODING_ARRAY);
                        xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, string);
                    }
                    int[] nArray = ArraySerializerBase.getArrayDimensions(object, this.getArrayRank(object));
                    String string2 = ArraySerializerBase.encodeArrayDimensions(nArray);
                    QName qName2 = this.registry.getXmlType(this.encodingStyle, object.getClass());
                    if (qName2 == null) {
                        throw new SerializationException("typemapping.serializerNotRegistered", new Object[]{object.getClass().getName()});
                    }
                    string = XMLWriterUtil.encodeQName(xMLWriter, qName2) + string2;
                    xMLWriter.writeAttributeUnquoted(SOAPConstants.QNAME_ENCODING_ARRAYTYPE, string);
                    this.serializeArrayInstance(object, nArray, xMLWriter, sOAPSerializationContext);
                    xMLWriter.endElement();
                }
                catch (SerializationException serializationException) {
                    throw serializationException;
                }
                catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
                    throw new SerializationException(jAXRPCExceptionBase);
                }
                catch (Exception exception) {
                    throw new SerializationException(new LocalizableExceptionAdapter(exception));
                }
            }
            Object var12_14 = null;
            if (bl) {
                sOAPSerializationContext.popEncodingStyle();
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (bl) {
                sOAPSerializationContext.popEncodingStyle();
            }
            throw throwable;
        }
    }

    protected void serializeArrayInstance(Object object, int[] nArray, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        this.serializeArrayElements((Object[])object, 0, nArray, xMLWriter, sOAPSerializationContext);
    }

    protected void serializeArrayElements(Object[] objectArray, int n, int[] nArray, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        if (objectArray == null || objectArray.length != nArray[n]) {
            throw new SerializationException("soap.irregularMultiDimensionalArray");
        }
        boolean bl = false;
        JAXRPCSerializer jAXRPCSerializer = null;
        if (n == nArray.length - 1) {
            bl = true;
            jAXRPCSerializer = (JAXRPCSerializer)this.registry.getSerializer(this.encodingStyle, objectArray.getClass().getComponentType());
        }
        int n2 = 0;
        while (n2 < nArray[n]) {
            Object object = objectArray[n2];
            if (bl) {
                jAXRPCSerializer.serialize(object, this.elemName, null, xMLWriter, sOAPSerializationContext);
            } else {
                this.serializeArrayElements((Object[])object, n + 1, nArray, xMLWriter, sOAPSerializationContext);
            }
            ++n2;
        }
    }

    protected void serializeNull(QName qName, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        boolean bl = false;
        xMLWriter.startElement(qName != null ? qName : this.type);
        bl = sOAPSerializationContext.pushEncodingStyle(this.encodingStyle, xMLWriter);
        if (this.encodeType) {
            String string = XMLWriterUtil.encodeQName(xMLWriter, this.type);
            xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, string);
        }
        xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
        xMLWriter.endElement();
        if (bl) {
            sOAPSerializationContext.popEncodingStyle();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object deserialize(QName qName, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) {
        Object var6_8;
        boolean bl = false;
        try {
            try {
                boolean bl2;
                bl = sOAPDeserializationContext.processEncodingStyle(xMLReader);
                sOAPDeserializationContext.verifyEncodingStyle(this.encodingStyle);
                if (qName != null) {
                    this.verifyName(xMLReader, qName);
                }
                if (!(bl2 = SerializerBase.getNullStatus(xMLReader))) {
                    QName qName2 = SerializerBase.getType(xMLReader);
                    if (qName2 != null && !qName2.equals(this.type) && !qName2.equals(SOAPConstants.QNAME_ENCODING_ARRAY)) {
                        throw new DeserializationException("soap.unexpectedElementType", new Object[]{this.type.toString(), qName2.toString()});
                    }
                    String string = null;
                    Attributes attributes = xMLReader.getAttributes();
                    string = attributes.getValue("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
                    if (string == null) {
                        throw new DeserializationException("soap.malformedArrayType", "<arrayType attribute missing>");
                    }
                    int[] nArray = ArraySerializerBase.getArrayDimensions(string, xMLReader);
                    QName qName3 = ArraySerializerBase.getArrayElementType(string, xMLReader);
                    Class clazz = this.registry.getJavaType(this.encodingStyle, qName3);
                    if (clazz == null) {
                        throw new SerializationException("typemapping.deserializerNotRegistered", new Object[]{qName3});
                    }
                    JAXRPCDeserializer jAXRPCDeserializer = (JAXRPCDeserializer)this.registry.getDeserializer(this.encodingStyle, qName3);
                    Object object = this.deserializeArrayInstance(xMLReader, sOAPDeserializationContext, nArray, clazz, jAXRPCDeserializer);
                    XMLReaderUtil.verifyReaderState(xMLReader, 2);
                    Object object2 = object;
                    Object var16_19 = null;
                    if (!bl) return object2;
                    sOAPDeserializationContext.popEncodingStyle();
                    return object2;
                }
                if (!this.isNullable) {
                    throw new DeserializationException("soap.unexpectedNull");
                }
                this.skipEmptyContent(xMLReader);
                var6_8 = null;
            }
            catch (DeserializationException deserializationException) {
                throw deserializationException;
            }
            catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
                throw new DeserializationException(jAXRPCExceptionBase);
            }
            catch (Exception exception) {
                throw new DeserializationException(new LocalizableExceptionAdapter(exception));
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            if (!bl) throw throwable;
            sOAPDeserializationContext.popEncodingStyle();
            throw throwable;
        }
        Object var16_20 = null;
        if (!bl) return var6_8;
        sOAPDeserializationContext.popEncodingStyle();
        return var6_8;
    }

    protected Object deserializeArrayInstance(XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext, int[] nArray, Class clazz, JAXRPCDeserializer jAXRPCDeserializer) throws Exception {
        String string = this.getID(xMLReader);
        SOAPDeserializationState sOAPDeserializationState = string != null ? sOAPDeserializationContext.getStateFor(string) : null;
        boolean bl = true;
        boolean bl2 = ArraySerializerBase.isEmptyDimensions(nArray);
        int[] nArray2 = ArraySerializerBase.getDimensionOffsets(nArray);
        int[] nArray3 = ArraySerializerBase.getArrayOffset(xMLReader, nArray);
        if (nArray3 == null) {
            nArray3 = new int[bl2 ? 1 : nArray.length];
        }
        Object[] objectArray = null;
        int n = 0;
        int n2 = 0;
        if (xMLReader.nextElementContent() != 2) {
            Object[] objectArray2;
            boolean bl3;
            int[] nArray4 = ArraySerializerBase.getArrayElementPosition(xMLReader, nArray);
            boolean bl4 = bl3 = nArray4 != null;
            if (!bl3) {
                nArray4 = nArray3;
            }
            if (bl2) {
                n = nArray4[0];
                n2 = Math.max(n * 2, 1024);
                objectArray = (Object[])Array.newInstance(clazz, n2);
            } else {
                objectArray = (Object[])Array.newInstance(clazz, nArray);
            }
            while (true) {
                if (!bl2 && !ArraySerializerBase.isPositionWithinBounds(nArray4, nArray)) {
                    if (bl3) {
                        throw new DeserializationException("soap.outOfBoundsArrayElementPosition", ArraySerializerBase.encodeArrayDimensions(nArray4));
                    }
                    throw new DeserializationException("soap.tooManyArrayElements");
                }
                if (bl2 && nArray4[0] >= n2) {
                    int n3 = n2 * 2;
                    while (nArray4[0] >= n3) {
                        n3 *= 2;
                    }
                    objectArray2 = (Object[])Array.newInstance(clazz, n3);
                    System.arraycopy(objectArray, 0, objectArray2, 0, n2);
                    objectArray = objectArray2;
                    n2 = n3;
                }
                Object object = null;
                object = jAXRPCDeserializer.deserialize(this.elemName, xMLReader, sOAPDeserializationContext);
                if (object instanceof SOAPDeserializationState) {
                    objectArray2 = (Object[])object;
                    bl = false;
                    if (sOAPDeserializationState == null) {
                        sOAPDeserializationState = new SOAPDeserializationState();
                    }
                    sOAPDeserializationState.setInstance(objectArray);
                    if (sOAPDeserializationState.getBuilder() == null) {
                        sOAPDeserializationState.setBuilder(new ObjectArrayInstanceBuilder(nArray2));
                    }
                    objectArray2.registerListener(sOAPDeserializationState, ArraySerializerBase.indexFromPosition(nArray4, nArray2));
                } else {
                    ObjectArraySerializer.setElement(objectArray, nArray4, object);
                }
                if (xMLReader.nextElementContent() == 2) break;
                if (bl3) {
                    nArray4 = ArraySerializerBase.getArrayElementPosition(xMLReader, nArray);
                    if (nArray4 == null) {
                        throw new DeserializationException("soap.missingArrayElementPosition");
                    }
                } else if (bl2) {
                    nArray4[0] = nArray4[0] + 1;
                } else {
                    ArraySerializerBase.incrementPosition(nArray4, nArray);
                }
                if (!bl2) continue;
                n = Math.max(nArray4[0], n);
            }
            if (bl2 && n2 != n + 1) {
                int n4 = n + 1;
                objectArray2 = (Object[])Array.newInstance(clazz, n4);
                System.arraycopy(objectArray, 0, objectArray2, 0, n4);
                objectArray = objectArray2;
                n2 = n4;
            }
        } else {
            objectArray = bl2 ? (Object[])Array.newInstance(clazz, 0) : (Object[])Array.newInstance(clazz, nArray);
        }
        if (sOAPDeserializationState != null) {
            sOAPDeserializationState.setDeserializer(this);
            sOAPDeserializationState.setInstance(objectArray);
            sOAPDeserializationState.doneReading();
        }
        if (bl) {
            return objectArray;
        }
        return sOAPDeserializationState;
    }

    protected int getArrayRank(Object object) {
        int n = 0;
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        return n;
    }

    private class ObjectArrayInstanceBuilder
    implements SOAPInstanceBuilder {
        Object[] instance = null;
        int[] dimOffsets = null;

        ObjectArrayInstanceBuilder(int[] nArray) {
            this.dimOffsets = nArray;
        }

        public int memberGateType(int n) {
            return 6;
        }

        public void construct() {
            throw new IllegalStateException();
        }

        public void setMember(int n, Object object) {
            int[] nArray = ArraySerializerBase.positionFromIndex(n, this.dimOffsets);
            ObjectArraySerializer.setElement(this.instance, nArray, object);
        }

        public void initialize() {
        }

        public void setInstance(Object object) {
            this.instance = (Object[])object;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

