/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.util.DatatypeHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLInstance2SchemaHandler
implements DocumentHandler,
ErrorHandler {
    private static final String XMLNS = "xmlns";
    private static final String DEFAULT_PREFIX = "xsd";
    private Locator _locator = null;
    private Schema _schema = null;
    private Stack _siStack = null;
    private String _nsPrefix = null;
    private Order _defaultGroupOrder = Order.seq;

    public XMLInstance2SchemaHandler() {
        this(null);
    }

    public XMLInstance2SchemaHandler(Schema schema) {
        this._siStack = new Stack();
        this._schema = schema;
        if (this._schema == null) {
            this._schema = new Schema();
            this._schema.addNamespace(DEFAULT_PREFIX, "http://www.w3.org/2001/XMLSchema");
            this._nsPrefix = DEFAULT_PREFIX;
        } else {
            this._nsPrefix = null;
            Hashtable hashtable = this._schema.getNamespaces();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!hashtable.get(string).equals("http://www.w3.org/2001/XMLSchema")) continue;
                this._nsPrefix = string;
                break;
            }
            if (this._nsPrefix == null) {
                this._schema.addNamespace(DEFAULT_PREFIX, "http://www.w3.org/2001/XMLSchema");
                this._nsPrefix = DEFAULT_PREFIX;
            }
        }
    }

    public Schema getSchema() {
        return this._schema;
    }

    protected void setDefaultGroupOrder(Order order) {
        this._defaultGroupOrder = order;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._siStack.isEmpty()) {
            return;
        }
        StateInfo stateInfo = (StateInfo)this._siStack.peek();
        if (stateInfo.buffer == null) {
            stateInfo.buffer = new StringBuffer();
        }
        stateInfo.buffer.append(cArray, n, n2);
        if (stateInfo.complex) {
            stateInfo.mixed = true;
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String string) throws SAXException {
        Object object;
        int n = string.indexOf(58);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        StateInfo stateInfo = (StateInfo)this._siStack.pop();
        if (stateInfo.element.getType() == null) {
            object = this._nsPrefix + ':' + DatatypeHandler.guessType(stateInfo.buffer.toString());
            stateInfo.element.setTypeReference((String)object);
        }
        if (!this._siStack.isEmpty()) {
            object = (StateInfo)this._siStack.peek();
            ComplexType complexType = (ComplexType)((StateInfo)object).element.getType();
            Group group = null;
            if (complexType == null) {
                ((StateInfo)object).complex = true;
                complexType = new ComplexType(this._schema);
                ((StateInfo)object).element.setType(complexType);
                group = new Group();
                group.setOrder(this._defaultGroupOrder);
                complexType.addGroup(group);
                group.addElementDecl(stateInfo.element);
            } else {
                group = (Group)complexType.getParticle(0);
                ElementDecl elementDecl = group.getElementDecl(string);
                boolean bl = false;
                if (elementDecl != null) {
                    if (stateInfo.complex) {
                        this.merge(elementDecl, stateInfo.element);
                    }
                    elementDecl.setMaxOccurs(Particle.UNBOUNDED);
                    bl = true;
                } else {
                    group.addElementDecl(stateInfo.element);
                }
                if (bl && group.getOrder() == Order.seq) {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int n2 = 0;
                    while (n2 < group.getParticleCount()) {
                        if (bl2) {
                            bl3 = true;
                            break;
                        }
                        if (elementDecl == group.getParticle(n2)) {
                            bl2 = true;
                        }
                        ++n2;
                    }
                    if (bl3) {
                        group.setOrder(Order.all);
                    }
                }
            }
        } else {
            this._schema.addElementDecl(stateInfo.element);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        int n = string.indexOf(58);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        StateInfo stateInfo = null;
        if (!this._siStack.isEmpty()) {
            stateInfo = (StateInfo)this._siStack.peek();
            stateInfo.complex = true;
        }
        stateInfo = new StateInfo();
        this._siStack.push(stateInfo);
        stateInfo.element = new ElementDecl(this._schema, string);
        int n2 = 0;
        while (n2 < attributeList.getLength()) {
            String string2 = attributeList.getName(n2);
            if (!string2.equals(XMLNS)) {
                String string3 = "";
                n = string.indexOf(58);
                if (n >= 0) {
                    string3 = string.substring(0, n);
                    string = string.substring(n + 1);
                }
                if (!string3.equals(XMLNS)) {
                    AttributeDecl attributeDecl = new AttributeDecl(this._schema, string);
                    String string4 = this._nsPrefix + ':' + DatatypeHandler.guessType(attributeList.getValue(n2));
                    attributeDecl.setSimpleTypeReference(string4);
                    stateInfo.attributes.addElement(attributeDecl);
                }
            }
            ++n2;
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private static boolean isWhiteSpace(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c = cArray[n4];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++n4;
        }
        return true;
    }

    private void merge(ElementDecl elementDecl, ElementDecl elementDecl2) throws SchemaException {
        ElementDecl elementDecl3;
        Particle particle;
        XMLType xMLType = elementDecl.getType();
        XMLType xMLType2 = elementDecl2.getType();
        if (xMLType.isSimpleType() || xMLType2.isSimpleType()) {
            return;
        }
        Group group = (Group)((ComplexType)xMLType).getParticle(0);
        Group group2 = (Group)((ComplexType)xMLType2).getParticle(0);
        Enumeration enumeration = group2.enumerate();
        while (enumeration.hasMoreElements()) {
            ElementDecl elementDecl4;
            particle = (Particle)enumeration.nextElement();
            if (particle.getStructureType() != 7 || (elementDecl4 = group.getElementDecl((elementDecl3 = (ElementDecl)particle).getName())) != null) continue;
            group.addElementDecl(elementDecl3);
            elementDecl3.setMinOccurs(0);
        }
        enumeration = group.enumerate();
        while (enumeration.hasMoreElements()) {
            particle = (Particle)enumeration.nextElement();
            if (particle.getStructureType() != 7 || group2.getElementDecl((elementDecl3 = (ElementDecl)particle).getName()) != null) continue;
            elementDecl3.setMinOccurs(0);
        }
    }

    class StateInfo {
        ElementDecl element = null;
        Vector attributes = new Vector();
        StringBuffer buffer = null;
        boolean mixed = false;
        boolean complex = false;
    }
}

