/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.dtd;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import org.exolab.castor.xml.dtd.Attribute;
import org.exolab.castor.xml.dtd.ContentParticle;
import org.exolab.castor.xml.dtd.DTDException;
import org.exolab.castor.xml.dtd.DTDdocument;
import org.exolab.castor.xml.dtd.Element;
import org.exolab.castor.xml.dtd.GeneralEntity;
import org.exolab.castor.xml.dtd.Notation;
import org.exolab.castor.xml.dtd.parser.DTDInitialParser;
import org.exolab.castor.xml.dtd.parser.DTDParser;
import org.exolab.castor.xml.dtd.parser.InputCharStream;
import org.exolab.castor.xml.dtd.parser.ParseException;
import org.exolab.castor.xml.dtd.parser.TokenMgrError;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.writer.SchemaWriter;
import org.xml.sax.SAXException;

public class Converter {
    public static void main(String[] stringArray) throws IOException, DTDException, SchemaException, SAXException {
        if (stringArray.length < 2 || stringArray.length > 3) {
            String string = "\nUsage:\n";
            string = string + "java org.exolab.castor.xml.dtd.Converter dtd_file xsd_file [character_encoding]\n\n";
            string = string + "dtd_file: name of the input DTD file\n";
            string = string + "xsd_file: name of the output Schema file\n";
            string = string + "character_encoding: name of the character encoding,\n";
            string = string + "                    if not specified, ASCII is chosen\n";
            System.out.println(string);
        } else {
            String string = stringArray.length == 2 ? "US-ASCII" : (stringArray[2].equals("ascii") || stringArray[2].equals("ASCII") || stringArray[2].equals("us-ascii") ? "US-ASCII" : (stringArray[2].equals("utf-8") ? "UTF-8" : (stringArray[2].equals("utf-16") ? "UTF-16" : stringArray[2])));
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string);
            Converter.convertDTDtoSchema(inputStreamReader, outputStreamWriter);
            inputStreamReader.close();
            outputStreamWriter.close();
        }
    }

    public static void convertDTDtoSchema(Reader reader, Writer writer) throws DTDException, SchemaException, IOException, SAXException {
        DTDdocument dTDdocument = Converter.parseDTD(reader);
        Schema schema = Converter.convertDTDObjectToSchemaObject(dTDdocument);
        Converter.marshalSchema(schema, writer);
    }

    public static DTDdocument parseDTD(Reader reader) throws DTDException {
        try {
            InputCharStream inputCharStream = new InputCharStream(reader);
            DTDInitialParser dTDInitialParser = new DTDInitialParser(inputCharStream);
            String string = dTDInitialParser.Input();
            StringReader stringReader = new StringReader(string);
            inputCharStream = new InputCharStream(stringReader);
            DTDParser dTDParser = new DTDParser(inputCharStream);
            DTDdocument dTDdocument = dTDParser.Input();
            stringReader.close();
            return dTDdocument;
        }
        catch (TokenMgrError tokenMgrError) {
            String string = tokenMgrError.getMessage();
            throw new DTDException("TokenMgrError" + (string == null ? "" : ": " + string));
        }
        catch (ParseException parseException) {
            String string = parseException.getMessage();
            throw new DTDException("ParseException" + (string == null ? "" : ": " + string));
        }
    }

    public static Schema convertDTDObjectToSchemaObject(DTDdocument dTDdocument) throws DTDException, SchemaException {
        Structure structure;
        Object object;
        Object object2;
        Schema schema = new Schema();
        String string = dTDdocument.getName();
        if (string != null && !string.equals("")) {
            schema.setId(string);
        }
        Enumeration enumeration = dTDdocument.getNotations();
        while (enumeration.hasMoreElements()) {
            Notation notation = (Notation)enumeration.nextElement();
        }
        Enumeration enumeration2 = dTDdocument.getGeneralEntities();
        if (enumeration2.hasMoreElements()) {
            object2 = new Annotation();
            while (enumeration2.hasMoreElements()) {
                object = (GeneralEntity)enumeration2.nextElement();
                structure = new Documentation();
                String string2 = "General Entity Declaration";
                ((Documentation)structure).setContent(string2);
                ((Documentation)structure).add(object);
                ((Annotation)object2).addDocumentation((Documentation)structure);
            }
            schema.addAnnotation((Annotation)object2);
        }
        object = dTDdocument.getElements();
        while (object.hasMoreElements()) {
            object2 = (Element)object.nextElement();
            structure = Converter.convertDTDElementToSchemaElement((Element)object2, schema);
            schema.addElementDecl((ElementDecl)structure);
        }
        return schema;
    }

    public static ElementDecl convertDTDElementToSchemaElement(Element element, Schema schema) throws DTDException, SchemaException {
        Object object;
        Object object2;
        String string = element.getName();
        if (string == null || string.equals("")) {
            String string2 = "DTD to Schema converter: a DTD element has no name.";
            throw new DTDException(string2);
        }
        ElementDecl elementDecl = new ElementDecl(schema, string);
        ComplexType complexType = schema.createComplexType();
        ContentType contentType = null;
        Group group = null;
        Iterator iterator = null;
        String string3 = null;
        ElementDecl elementDecl2 = null;
        if (element.isEmptyContent()) {
            contentType = ContentType.elemOnly;
        } else if (element.isAnyContent()) {
            contentType = ContentType.mixed;
            group = new Group();
            group.setOrder(Order.seq);
            group.setMinOccurs(0);
            group.setMaxOccurs(-1);
            object2 = new Wildcard(group);
            group.addWildcard((Wildcard)object2);
            complexType.addGroup(group);
        } else if (element.isElemOnlyContent()) {
            contentType = ContentType.elemOnly;
            object2 = element.getContent();
            if (object2 == null) {
                String string4 = "DTD to Schema converter: element \"" + element.getName();
                string4 = string4 + "\" has no content.";
                throw new DTDException(string4);
            }
            object = null;
            try {
                object = Converter.convertContentParticle((ContentParticle)object2, schema);
            }
            catch (DTDException dTDException) {
                String string5 = "DTD to Schema converter: content of DTD element \"" + element.getName();
                string5 = string5 + "\", represented by a Content Particle, is malformed.";
                throw new DTDException(string5);
            }
            if (object instanceof ElementDecl) {
                group = new Group();
                group.setOrder(Order.seq);
                group.addElementDecl((ElementDecl)object);
                complexType.addGroup(group);
            } else {
                complexType.addGroup((Group)object);
            }
        } else if (element.isMixedContent()) {
            contentType = ContentType.mixed;
            iterator = element.getMixedContentChildren();
            if (iterator != null && iterator.hasNext()) {
                group = new Group();
                group.setOrder(Order.choice);
                group.setMinOccurs(0);
                group.setMaxOccurs(-1);
                while (iterator.hasNext()) {
                    string3 = (String)iterator.next();
                    elementDecl2 = new ElementDecl(schema);
                    elementDecl2.setReference(string3);
                    group.addElementDecl(elementDecl2);
                }
                complexType.addGroup(group);
            }
        } else {
            String string6 = "DTD to Schema converter: content type of DTD element \"" + element.getName();
            string6 = string6 + "\" has not been specified.";
            throw new DTDException(string6);
        }
        complexType.setContentType(contentType);
        object2 = element.getAttributes();
        while (object2.hasMoreElements()) {
            object = (Attribute)object2.nextElement();
            AttributeDecl attributeDecl = Converter.convertAttribute((Attribute)object, schema);
            complexType.addAttributeDecl(attributeDecl);
        }
        elementDecl.setType(complexType);
        return elementDecl;
    }

    public static Particle convertContentParticle(ContentParticle contentParticle, Schema schema) throws DTDException, SchemaException {
        Particle particle;
        if (contentParticle.isReferenceType()) {
            ElementDecl elementDecl = new ElementDecl(schema);
            elementDecl.setReference(contentParticle.getReference());
            particle = elementDecl;
        } else if (contentParticle.isSeqType() || contentParticle.isChoiceType()) {
            Group group = new Group();
            if (contentParticle.isSeqType()) {
                group.setOrder(Order.seq);
            } else {
                group.setOrder(Order.choice);
            }
            Enumeration enumeration = contentParticle.getChildren();
            while (enumeration.hasMoreElements()) {
                ContentParticle contentParticle2 = (ContentParticle)enumeration.nextElement();
                Particle particle2 = Converter.convertContentParticle(contentParticle2, schema);
                if (particle2 instanceof ElementDecl) {
                    group.addElementDecl((ElementDecl)particle2);
                    continue;
                }
                group.addGroup((Group)particle2);
            }
            particle = group;
        } else {
            throw new DTDException();
        }
        if (contentParticle.isOneOccurance()) {
            particle.setMinOccurs(1);
            particle.setMaxOccurs(1);
        } else if (contentParticle.isOneOrMoreOccurances()) {
            particle.setMinOccurs(1);
            particle.setMaxOccurs(-1);
        } else if (contentParticle.isZeroOrMoreOccurances()) {
            particle.setMinOccurs(0);
            particle.setMaxOccurs(-1);
        } else if (contentParticle.isZeroOrOneOccurance()) {
            particle.setMinOccurs(0);
            particle.setMaxOccurs(1);
        }
        return particle;
    }

    public static AttributeDecl convertAttribute(Attribute attribute, Schema schema) throws DTDException {
        AttributeDecl attributeDecl = new AttributeDecl(schema, attribute.getName());
        SimpleType simpleType = null;
        if (attribute.isStringType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(1));
        } else if (attribute.isIDType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(25));
        } else if (attribute.isIDREFType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(26));
        } else if (attribute.isIDREFSType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(27));
        } else if (attribute.isENTITYType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(28));
        } else if (attribute.isENTITIESType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(29));
        } else if (attribute.isNMTOKENType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(30));
        } else if (attribute.isNMTOKENSType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(31));
        } else if (attribute.isNOTATIONType()) {
            simpleType = schema.createSimpleType(null, schema.getBuiltInTypeName(19), "restriction");
            Iterator iterator = attribute.getValues();
            while (iterator.hasNext()) {
                simpleType.addFacet(new Facet("enumeration", (String)iterator.next()));
            }
        } else if (attribute.isEnumerationType()) {
            simpleType = schema.createSimpleType(null, schema.getBuiltInTypeName(30), "restriction");
            Iterator iterator = attribute.getValues();
            while (iterator.hasNext()) {
                simpleType.addFacet(new Facet("enumeration", (String)iterator.next()));
            }
        } else {
            String string = "DTD to Schema converter: DTD attribute \"" + attribute.getName();
            string = string + "\" has unspecified type.";
            throw new DTDException(string);
        }
        attributeDecl.setSimpleType(simpleType);
        if (attribute.isREQUIRED()) {
            attributeDecl.setUse("required");
        } else if (attribute.isIMPLIED()) {
            attributeDecl.setUse("optional");
        } else if (attribute.isFIXED()) {
            attributeDecl.setValue(attribute.getDefaultValue());
            attributeDecl.setFixed();
        } else {
            attributeDecl.setValue(attribute.getDefaultValue());
            attributeDecl.setDefault();
        }
        return attributeDecl;
    }

    public static void marshalSchema(Schema schema, Writer writer) throws IOException, SAXException {
        SchemaWriter.enable = true;
        SchemaWriter schemaWriter = new SchemaWriter(writer);
        schemaWriter.write(schema);
    }
}

