/*
 * Decompiled with CFR 0.152.
 */
package samples.xml.xslt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import samples.xml.xslt.AddressBookReader02;

public class TransformationApp04 {
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: java TransformationApp filename");
            System.exit(1);
        }
        AddressBookReader02 addressBookReader02 = new AddressBookReader02();
        try {
            File file = new File(stringArray[0]);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            InputSource inputSource = new InputSource(fileReader);
            SAXSource sAXSource = new SAXSource(addressBookReader02, inputSource);
            StreamResult streamResult = new StreamResult(System.out);
            transformer.transform(sAXSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.out.println("\n** Transformer Factory error");
            System.out.println("   " + transformerConfigurationException.getMessage());
            Throwable throwable = transformerConfigurationException;
            if (transformerConfigurationException.getException() != null) {
                throwable = transformerConfigurationException.getException();
            }
            ((Throwable)throwable).printStackTrace();
        }
        catch (TransformerException transformerException) {
            System.out.println("\n** Transformation error");
            System.out.println("   " + transformerException.getMessage());
            Throwable throwable = transformerException;
            if (transformerException.getException() != null) {
                throwable = transformerException.getException();
            }
            ((Throwable)throwable).printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

