/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.simple;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import samples.connectors.simple.CometConnection;
import samples.connectors.simple.CometConnectionEventListener;
import samples.connectors.simple.CometManagedConnectionMetaData;
import samples.connectors.simple.Messages;
import samples.connectors.simple.Util;

public class CometManagedConnection
implements ManagedConnection {
    private String user;
    private ManagedConnectionFactory mcf;
    private CometConnectionEventListener CometListener;
    private Set connectionSet;
    private PrintWriter logWriter;
    private boolean destroyed;
    private static int testCounter = 0;
    private Socket backendSocket = null;
    private OutputStream outStream = null;
    private ObjectOutputStream objOutputStream = null;
    private InputStream inStream = null;
    private ObjectInputStream objInputStream = null;

    CometManagedConnection(ManagedConnectionFactory managedConnectionFactory, String string) {
        System.out.println(" 4. In CometManagedConnection ctor " + testCounter++);
        this.mcf = managedConnectionFactory;
        this.user = string;
        this.connectionSet = new HashSet();
        this.CometListener = new CometConnectionEventListener(this);
    }

    public void addCometConnection(CometConnection cometConnection) {
        this.connectionSet.add(cometConnection);
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.CometListener.addConnectorListener(connectionEventListener);
    }

    public void associateConnection(Object object) throws ResourceException {
        this.checkIfDestroyed();
        if (!(object instanceof CometConnection)) {
            throw new IllegalStateException(Messages.getMessage("3"), "3");
        }
        CometConnection cometConnection = (CometConnection)object;
        cometConnection.associateConnection(this);
    }

    private void checkIfDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException(Messages.getMessage("4"), "4");
        }
    }

    public void cleanup() throws ResourceException {
        this.checkIfDestroyed();
        Iterator iterator = this.connectionSet.iterator();
        while (iterator.hasNext()) {
            CometConnection cometConnection = (CometConnection)iterator.next();
            cometConnection.invalidate();
        }
        this.connectionSet.clear();
    }

    public boolean connect(String string, String string2) {
        try {
            System.out.println(" -- In CometManagedConnection:: connect (" + testCounter + ") " + string + ":" + string2);
            this.backendSocket = new Socket(InetAddress.getByName(string), Integer.parseInt(string2));
            this.outStream = this.backendSocket.getOutputStream();
            this.objOutputStream = new ObjectOutputStream(this.outStream);
            this.inStream = this.backendSocket.getInputStream();
            this.objInputStream = new ObjectInputStream(this.inStream);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void destroy() throws ResourceException {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        --testCounter;
        try {
            this.objInputStream.close();
            this.objOutputStream.close();
            this.backendSocket.close();
        }
        catch (Exception exception) {}
        Iterator iterator = this.connectionSet.iterator();
        while (iterator.hasNext()) {
            CometConnection cometConnection = (CometConnection)iterator.next();
            cometConnection.invalidate();
        }
        this.connectionSet.clear();
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        PasswordCredential passwordCredential = Util.getPasswordCredential(this.mcf, subject, connectionRequestInfo);
        if (passwordCredential == null ? this.user != null : !passwordCredential.getUserName().equals(this.user)) {
            throw new SecurityException(Messages.getMessage("7"), "7");
        }
        this.checkIfDestroyed();
        CometConnection cometConnection = new CometConnection(this);
        this.addCometConnection(cometConnection);
        return cometConnection;
    }

    public Object getData() throws ResourceException {
        Object object = null;
        try {
            object = this.objInputStream.readObject();
        }
        catch (Exception exception) {
            System.out.println(" -- Get data FAILED !!!");
            throw new ResourceException(Messages.getMessage("11"), "11");
        }
        return object;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException(Messages.getMessage("1"), "1");
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.checkIfDestroyed();
        return new CometManagedConnectionMetaData(this);
    }

    public String getUserName() {
        return this.user;
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException(Messages.getMessage("8"), "8");
    }

    boolean isDestroyed() {
        return this.destroyed;
    }

    public void removeCometConnection(CometConnection cometConnection) {
        this.connectionSet.remove(cometConnection);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.CometListener.removeConnectorListener(connectionEventListener);
    }

    public void sendData(Object object) throws ResourceException {
        try {
            this.objOutputStream.writeObject(object);
            this.objOutputStream.flush();
        }
        catch (Exception exception) {
            System.out.println(" -- Send data FAILED !!!");
            throw new ResourceException(Messages.getMessage("11"), "11");
        }
    }

    public void sendEvent(int n, Exception exception) {
        this.CometListener.sendEvent(n, exception, null);
    }

    public void sendEvent(int n, Exception exception, Object object) {
        this.CometListener.sendEvent(n, exception, object);
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
    }
}

