/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.util.Vector;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.KeyAlreadyImportedException;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.TokenProxy;
import org.mozilla.jss.util.Assert;

public final class PK11Store
implements CryptoStore {
    protected boolean updated;
    protected TokenProxy storeProxy;

    protected PK11Store() {
    }

    public PK11Store(TokenProxy tokenProxy) {
        Assert.assert(tokenProxy != null);
        this.storeProxy = tokenProxy;
    }

    public native void deleteCert(X509Certificate var1) throws NoSuchItemOnTokenException, TokenException;

    public native void deletePrivateKey(PrivateKey var1) throws NoSuchItemOnTokenException, TokenException;

    public X509Certificate[] getCertificates() throws TokenException {
        Vector vector = new Vector();
        this.putCertsInVector(vector);
        Object[] objectArray = new X509Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized PrivateKey[] getPrivateKeys() throws TokenException {
        Vector vector = new Vector();
        this.putKeysInVector(vector);
        Object[] objectArray = new PrivateKey[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public native void importPrivateKey(byte[] var1, PrivateKey.Type var2) throws TokenException, KeyAlreadyImportedException;

    protected native void putCertsInVector(Vector var1) throws TokenException;

    protected native void putKeysInVector(Vector var1) throws TokenException;
}

