/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class BOOLEAN
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 1L);
    public static final Form FORM = Form.PRIMITIVE;
    private boolean val;
    private static final Template templateInstance = new Template();

    private BOOLEAN() {
    }

    public BOOLEAN(boolean bl) {
        this.val = bl;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.getHeader(tag).encode(outputStream);
        if (this.val) {
            outputStream.write(255);
        } else {
            outputStream.write(0);
        }
    }

    private ASN1Header getHeader() {
        return this.getHeader(TAG);
    }

    private ASN1Header getHeader(Tag tag) {
        return new ASN1Header(tag, FORM, 1L);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public boolean toBoolean() {
        return this.val;
    }

    public String toString() {
        if (this.val) {
            return "true";
        }
        return "false";
    }

    public static class Template
    implements ASN1Template {
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                ASN1Header aSN1Header = new ASN1Header(inputStream);
                aSN1Header.validate(tag, FORM);
                int n = inputStream.read();
                if (n == -1) {
                    throw new InvalidBERException("End-of-file reached while decoding BOOLEAN");
                }
                if (n == 0) {
                    return new BOOLEAN(false);
                }
                return new BOOLEAN(true);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "BOOLEAN");
            }
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }
    }
}

