/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class ErrorDispatcherValve
extends ValveBase {
    protected int debug = 0;
    protected static final String info = "org.apache.catalina.valves.ErrorDispatcherValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public String getInfo() {
        return info;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        return 1;
    }

    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        response.setSuspended(false);
        ServletRequest servletRequest = request.getRequest();
        Throwable throwable = (Throwable)servletRequest.getAttribute("javax.servlet.error.exception");
        if (throwable != null) {
            this.throwable(request, response, throwable);
        } else {
            this.status(request, response);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ErrorDispatcherValve[");
        stringBuffer.append(this.container.getName());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void throwable(Request request, Response response, Throwable throwable) {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        Throwable throwable2 = throwable;
        ErrorPage errorPage = ErrorDispatcherValve.findErrorPage(context, throwable2);
        if (errorPage == null && throwable2 instanceof ServletException) {
            if ((throwable2 = ((ServletException)throwable2).getRootCause()) != null) {
                errorPage = ErrorDispatcherValve.findErrorPage(context, throwable2);
            } else {
                throwable2 = throwable;
            }
        }
        if (errorPage != null) {
            response.setAppCommitted(false);
            ServletRequest servletRequest = request.getRequest();
            ServletResponse servletResponse = response.getResponse();
            servletRequest.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
            servletRequest.setAttribute("javax.servlet.error.message", (Object)throwable.getMessage());
            servletRequest.setAttribute("javax.servlet.error.exception", (Object)throwable);
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                servletRequest.setAttribute("javax.servlet.error.servlet_name", (Object)wrapper.getName());
            }
            if (servletRequest instanceof HttpServletRequest) {
                servletRequest.setAttribute("javax.servlet.error.request_uri", (Object)((HttpServletRequest)servletRequest).getRequestURI());
            }
            servletRequest.setAttribute("javax.servlet.error.exception_type", throwable.getClass());
            if (this.custom(request, response, errorPage)) {
                try {
                    servletResponse.flushBuffer();
                }
                catch (IOException iOException) {
                    this.log("Exception Processing " + errorPage, iOException);
                }
            }
        } else {
            ServletResponse servletResponse = (ServletResponse)response;
            if (servletResponse instanceof HttpServletResponse) {
                ((HttpServletResponse)servletResponse).setStatus(500);
                response.setError();
                this.status(request, response);
            }
        }
    }

    protected void status(Request request, Response response) {
        block9: {
            if (!(response instanceof HttpResponse)) {
                return;
            }
            HttpResponse httpResponse = (HttpResponse)response;
            if (!(response.getResponse() instanceof HttpServletResponse)) {
                return;
            }
            int n = httpResponse.getStatus();
            Context context = request.getContext();
            if (context == null) {
                return;
            }
            ErrorPage errorPage = context.findErrorPage(n);
            if (errorPage == null) break block9;
            response.setAppCommitted(false);
            ServletRequest servletRequest = request.getRequest();
            ServletResponse servletResponse = response.getResponse();
            servletRequest.setAttribute("javax.servlet.error.status_code", (Object)new Integer(n));
            String string = RequestUtil.filter(httpResponse.getMessage());
            if (string == null) {
                string = "";
            }
            servletRequest.setAttribute("javax.servlet.error.message", (Object)string);
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                servletRequest.setAttribute("javax.servlet.error.servlet_name", (Object)wrapper.getName());
            }
            if (servletRequest instanceof HttpServletRequest) {
                servletRequest.setAttribute("javax.servlet.error.request_uri", (Object)((HttpServletRequest)servletRequest).getRequestURI());
            }
            if (this.custom(request, response, errorPage)) {
                try {
                    servletResponse.flushBuffer();
                }
                catch (IOException iOException) {
                    this.log("Exception Processing " + errorPage, iOException);
                }
            }
        }
    }

    protected static ErrorPage findErrorPage(Context context, Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Class<?> clazz = throwable.getClass();
        String string = clazz.getName();
        while (!"java.lang.Object".equals(clazz)) {
            ErrorPage errorPage = context.findErrorPage(string);
            if (errorPage != null) {
                return errorPage;
            }
            if ((clazz = clazz.getSuperclass()) == null) break;
            string = clazz.getName();
        }
        return null;
    }

    protected boolean custom(Request request, Response response, ErrorPage errorPage) {
        if (this.debug >= 1) {
            this.log("Processing " + errorPage);
        }
        if (!(request instanceof HttpRequest)) {
            if (this.debug >= 1) {
                this.log(" Not processing an HTTP request --> default handling");
            }
            return false;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
        if (!(response instanceof HttpResponse)) {
            if (this.debug >= 1) {
                this.log("Not processing an HTTP response --> default handling");
            }
            return false;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
        try {
            Integer n = (Integer)httpServletRequest.getAttribute("javax.servlet.error.status_code");
            int n2 = n;
            String string = (String)httpServletRequest.getAttribute("javax.servlet.error.message");
            ((HttpResponse)response).reset(n2, string);
            ServletContext servletContext = request.getContext().getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(errorPage.getLocation());
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            response.setSuspended(false);
            return true;
        }
        catch (Throwable throwable) {
            this.log("Exception Processing " + errorPage, throwable);
            return false;
        }
    }

    protected void log(String string) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + string);
        } else {
            System.out.println(this.toString() + ": " + string);
        }
    }

    protected void log(String string, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + string, throwable);
        } else {
            System.out.println(this.toString() + ": " + string);
            throwable.printStackTrace(System.out);
        }
    }
}

